/*
 * Decompiled with CFR 0.152.
 */
package de.jannik.createrailwaysignal.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public final class CameraConfig {
    private static final File FILE = FabricLoader.getInstance().getConfigDir().resolve("createrailwaysignal-camera.properties").toFile();
    private static final Properties PROPS = new Properties();
    private static boolean unzoomEnabled = false;
    private static volatile boolean normalizeOnce = false;

    private CameraConfig() {
    }

    public static void load() {
        if (!FILE.exists()) {
            CameraConfig.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(FILE.toPath());){
            PROPS.load(reader);
            unzoomEnabled = Boolean.parseBoolean(PROPS.getProperty("unzoomEnabled", "false"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(FILE.toPath(), new OpenOption[0]);){
            PROPS.setProperty("unzoomEnabled", Boolean.toString(unzoomEnabled));
            PROPS.store(writer, "CreateRailwaySignal camera settings");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isUnzoomEnabled() {
        return unzoomEnabled;
    }

    public static void setUnzoomEnabled(boolean value) {
        unzoomEnabled = value;
        CameraConfig.save();
    }

    public static void resetConfig() {
        unzoomEnabled = false;
        CameraConfig.save();
    }

    public static void requestNormalizeOnce() {
        normalizeOnce = true;
    }

    public static boolean consumeNormalizeOnce() {
        if (normalizeOnce) {
            normalizeOnce = false;
            return true;
        }
        return false;
    }
}

