/*
 * Decompiled with CFR 0.152.
 */
package de.jannik.createrailwaysignal.graph;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.infrastructure.config.AllConfigs;
import de.jannik.createrailwaysignal.Createrailwaysignal;
import de.jannik.createrailwaysignal.block.TrackLimitBlock;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2769;

public class SpeedSignalBoundary
extends SingleBlockEntityEdgePoint {
    private int speedLimitKilometersPerHour = 0;
    private boolean migration = false;

    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        if (blockEntity.method_10997() == null) {
            Createrailwaysignal.LOGGER.error("World ist null in blockEntityAdded");
            return;
        }
        int speedLimitKilometersPerHour = (Integer)blockEntity.method_10997().method_8320(blockEntity.method_11016()).method_11654((class_2769)TrackLimitBlock.SPEED_LIMIT) * 10;
        this.setSpeedLimitKilometersPerHour(blockEntity.method_10997(), speedLimitKilometersPerHour);
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
    }

    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        if (!nbt.method_10545("speedLimitKilometersPerHour")) {
            this.migration = true;
        }
        this.speedLimitKilometersPerHour = nbt.method_10550("speedLimitKilometersPerHour");
    }

    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10569("speedLimitKilometersPerHour", this.speedLimitKilometersPerHour);
    }

    private void notifyTrains(class_1937 world) {
        if (world == null || this.edgeLocation == null) {
            return;
        }
        try {
            TrackGraph graph = Create.RAILWAYS.sided((class_1936)world).getGraph((class_1936)world, (TrackNodeLocation)this.edgeLocation.getFirst());
            if (graph == null) {
                return;
            }
            TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
            if (edge == null) {
                return;
            }
            SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
        }
        catch (Exception e) {
            Createrailwaysignal.LOGGER.error("Fehler beim Benachrichtigen der Z\u00fcge", (Throwable)e);
        }
    }

    public double calculateSpeedLimit() {
        if (this.speedLimitKilometersPerHour == 0) {
            return 0.0;
        }
        float topSpeed = AllConfigs.server().trains.trainTopSpeed.getF();
        return (double)this.speedLimitKilometersPerHour / ((double)topSpeed * 3.6);
    }

    public boolean resetsLimit() {
        return this.speedLimitKilometersPerHour == 0;
    }

    public int getSpeedLimitKilometersPerHour() {
        return this.speedLimitKilometersPerHour;
    }

    public void setSpeedLimitKilometersPerHour(class_1937 world, int speedLimitKilometersPerHour) {
        if (this.speedLimitKilometersPerHour == speedLimitKilometersPerHour) {
            return;
        }
        this.speedLimitKilometersPerHour = speedLimitKilometersPerHour;
        this.notifyTrains(world);
    }

    public boolean migration() {
        return this.migration;
    }
}

