/*
 * Decompiled with CFR 0.152.
 */
package de.jannik.createrailwaysignal.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.jannik.createrailwaysignal.block.kilometer.KilometerMarkerBlock;
import de.jannik.createrailwaysignal.debug.KMDbg;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public final class CreaterailwayCommands {
    public static final class_1928.class_4313<class_1928.class_4310> SHOW_SPEED_BLOCK = GameRuleRegistry.register((String)"showSpeedBlock", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
    public static final class_1928.class_4313<class_1928.class_4310> SHOW_WHISTLE_BLOCK = GameRuleRegistry.register((String)"showWhistleBlock", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));

    private CreaterailwayCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"createrailwaysignal").executes(ctx -> {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Use:\n  /createrailwaysignal debugspeedblock [status|on|off|toggle]\n  /createrailwaysignal debugwhistleblock [status|on|off|toggle]\n  /createrailwaysignal kmdebug [on|off|toggle]\n  /createrailwaysignal kmdump\n"), false);
                return 1;
            })).then(CreaterailwayCommands.buildToggleBranch("debugspeedblock", SHOW_SPEED_BLOCK))).then(CreaterailwayCommands.buildToggleBranch("debugwhistleblock", SHOW_WHISTLE_BLOCK))).then(CreaterailwayCommands.buildKmDebugNode())).then(CreaterailwayCommands.buildKmDumpNode()));
            dispatcher.register(CreaterailwayCommands.buildToggleBranch("debugspeedblock", SHOW_SPEED_BLOCK));
            dispatcher.register(CreaterailwayCommands.buildToggleBranch("debugwhistleblock", SHOW_WHISTLE_BLOCK));
            dispatcher.register(CreaterailwayCommands.buildKmDebugNode());
            dispatcher.register(CreaterailwayCommands.buildKmDumpNode());
        });
    }

    private static LiteralArgumentBuilder<class_2168> buildToggleBranch(String literal, class_1928.class_4313<class_1928.class_4310> key) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)literal).executes(ctx -> {
            boolean on = ((class_1928.class_4310)((class_2168)ctx.getSource()).method_9225().method_8450().method_20746(key)).method_20753();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(CreaterailwayCommands.prettyName(literal) + " is currently: " + (on ? "ON" : "OFF"))), false);
            return 1;
        })).then(class_2170.method_9247((String)"status").executes(ctx -> {
            boolean on = ((class_1928.class_4310)((class_2168)ctx.getSource()).method_9225().method_8450().method_20746(key)).method_20753();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(CreaterailwayCommands.prettyName(literal) + " is currently: " + (on ? "ON" : "OFF"))), false);
            return 1;
        }))).then(class_2170.method_9247((String)"on").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1928 rules = src.method_9225().method_8450();
            ((class_1928.class_4310)rules.method_20746(key)).method_20758(true, src.method_9211());
            src.method_9226(() -> class_2561.method_43470((String)(CreaterailwayCommands.prettyName(literal) + ": ON")), false);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1928 rules = src.method_9225().method_8450();
            ((class_1928.class_4310)rules.method_20746(key)).method_20758(false, src.method_9211());
            src.method_9226(() -> class_2561.method_43470((String)(CreaterailwayCommands.prettyName(literal) + ": OFF")), false);
            return 1;
        }))).then(class_2170.method_9247((String)"toggle").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1928 rules = src.method_9225().method_8450();
            class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746(key);
            boolean newVal = !rule.method_20753();
            rule.method_20758(newVal, src.method_9211());
            src.method_9226(() -> class_2561.method_43470((String)CreaterailwayCommands.prettyToggleName(literal, newVal)), false);
            return 1;
        }));
    }

    private static String prettyName(String literal) {
        return switch (literal) {
            case "debugspeedblock" -> "Speed block location display";
            case "debugwhistleblock" -> "Whistle block log display";
            default -> literal;
        };
    }

    private static String prettyToggleName(String literal, boolean on) {
        return CreaterailwayCommands.prettyName(literal) + ": " + (on ? "ON" : "OFF");
    }

    private static LiteralArgumentBuilder<class_2168> buildKmDebugNode() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kmdebug").then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
            b.suggest("on");
            b.suggest("off");
            b.suggest("toggle");
            return b.buildFuture();
        }).executes(ctx -> {
            String mode;
            switch (mode = StringArgumentType.getString((CommandContext)ctx, (String)"mode").toLowerCase()) {
                case "on": {
                    KMDbg.set(true);
                    break;
                }
                case "off": {
                    KMDbg.set(false);
                    break;
                }
                case "toggle": {
                    KMDbg.set(!KMDbg.on());
                    break;
                }
                default: {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Usage: /kmdebug <on|off|toggle>"));
                    return 0;
                }
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("KM debug: " + (KMDbg.on() ? "ON" : "OFF"))), false);
            return 1;
        }))).executes(ctx -> {
            KMDbg.set(!KMDbg.on());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("KM debug: " + (KMDbg.on() ? "ON" : "OFF"))), false);
            return 1;
        });
    }

    private static LiteralArgumentBuilder<class_2168> buildKmDumpNode() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"kmdump").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Players only."));
                return 0;
            }
            class_3965 hit = (class_3965)player.method_5745(8.0, 0.0f, false);
            class_2338 pos = hit.method_17777();
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof KilometerMarkerBlock)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Look at a Kilometer Marker to use /kmdump."));
                return 0;
            }
            return 0;
        });
    }
}

