/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.api.BlockEntityTemperatureProvider;
import com.lumintorious.tfcambiental.api.EnvironmentalTemperatureProvider;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@FunctionalInterface
public interface BlockTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1, BlockPos var2, BlockState var3);

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
        BlockPos p = player.getOnPos();
        BlockPos pos1 = new BlockPos(p.getX() - 12, p.getY() - 5, p.getZ() - 12);
        BlockPos pos2 = new BlockPos(p.getX() + 12, p.getY() + 7, p.getZ() + 12);
        Iterable allPositions = BlockPos.betweenClosed((BlockPos)pos1, (BlockPos)pos2);
        for (BlockPos pos : allPositions) {
            boolean isInside;
            BlockState state;
            if (!player.level().isLoaded(pos) || (state = player.level().getBlockState(pos)).isAir()) continue;
            double distance = Math.sqrt(player.getOnPos().distSqr((Vec3i)pos));
            float distanceMultiplier = (float)distance / 9.0f;
            distanceMultiplier = Math.min(1.0f, Math.max(0.0f, distanceMultiplier));
            distanceMultiplier = 1.0f - distanceMultiplier;
            boolean bl = isInside = EnvironmentalTemperatureProvider.getSkylight(player) < 14 && EnvironmentalTemperatureProvider.getBlockLight(player) > 3;
            if (isInside) {
                distanceMultiplier = Math.min(1.0f, distanceMultiplier * 2.5f);
            }
            float finalDistanceMultiplier = distanceMultiplier;
            for (BlockTemperatureProvider provider : AmbientalRegistry.BLOCKS) {
                provider.getModifier(player, pos, state).ifPresent(mod -> {
                    mod.setChange(mod.getChange() * finalDistanceMultiplier);
                    mod.setPotency(mod.getPotency() * finalDistanceMultiplier);
                    mod.setWetness(mod.getWetness() * finalDistanceMultiplier);
                    cache.add((TemperatureModifier)mod);
                });
            }
            BlockEntity blockEntity = player.level().getBlockEntity(pos);
            if (blockEntity == null) continue;
            for (BlockEntityTemperatureProvider provider : AmbientalRegistry.BLOCK_ENTITIES) {
                provider.getModifier(player, blockEntity).ifPresent(mod -> {
                    mod.setChange(mod.getChange() * finalDistanceMultiplier);
                    mod.setPotency(mod.getPotency() * finalDistanceMultiplier);
                    mod.setWetness(mod.getWetness() * finalDistanceMultiplier);
                    cache.add((TemperatureModifier)mod);
                });
            }
        }
    }
}

