/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.TFCAmbientalTags;
import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

@FunctionalInterface
public interface EntityTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1);

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
        for (EntityTemperatureProvider fn : AmbientalRegistry.ENTITIES) {
            cache.add(fn.getModifier(player));
        }
    }

    public static Optional<TemperatureModifier> handleHotEntities(Player player) {
        List nearbyEntities = player.level().getEntitiesOfClass(Entity.class, new AABB(player.blockPosition()).inflate(5.0, 2.0, 5.0));
        if (nearbyEntities.size() > 0) {
            AtomicReference<Float> change = new AtomicReference<Float>(Float.valueOf(0.0f));
            nearbyEntities.forEach(entity -> {
                if (entity.getType().is(TFCAmbientalTags.HOT_ENTITIES)) {
                    change.updateAndGet(v -> Float.valueOf(v.floatValue() + 1.0f));
                }
            });
            return TemperatureModifier.defined("hot_entity", change.get().floatValue(), 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleColdEntities(Player player) {
        List nearbyEntities = player.level().getEntitiesOfClass(Entity.class, new AABB(player.blockPosition()).inflate(5.0, 2.0, 5.0));
        if (!nearbyEntities.isEmpty()) {
            AtomicReference<Float> change = new AtomicReference<Float>(Float.valueOf(0.0f));
            nearbyEntities.forEach(entity -> {
                if (entity.getType().is(TFCAmbientalTags.COLD_ENTITIES)) {
                    change.updateAndGet(v -> Float.valueOf(v.floatValue() + 1.0f));
                }
            });
            return TemperatureModifier.defined("cold_entity", -1.0f * change.get().floatValue(), 0.0f);
        }
        return TemperatureModifier.none();
    }
}

