/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.TFCAmbiental;
import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.api.BuildingInsulationPathNodeEvaluator;
import com.lumintorious.tfcambiental.data.PlayerTemperature;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.player.PlayerInfo;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;

@FunctionalInterface
public interface EnvironmentalTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1);

    public static boolean calculateEnclosure(Player player, int radius) {
        PathNavigationRegion region = new PathNavigationRegion(player.level(), player.getOnPos().above().offset(-radius, -radius, -radius), player.getOnPos().above().offset(radius, 400, radius));
        Bat guineaPig = new Bat(EntityType.BAT, player.level());
        guineaPig.setPos(player.getPosition(0.0f).add(0.0, 1.0, 0.0));
        guineaPig.setBaby(true);
        BuildingInsulationPathNodeEvaluator evaluator = new BuildingInsulationPathNodeEvaluator();
        PathFinder finder = new PathFinder((NodeEvaluator)evaluator, 500);
        Path path = finder.findPath(region, (Mob)guineaPig, Set.of(player.getOnPos().above().atY(258)), 500.0f, 0, 12.0f);
        return path == null || path.getNodeCount() < 255 - player.getOnPos().above().getY();
    }

    public static float getEnvironmentTemperatureWithTimeOfDay(Player player) {
        return EnvironmentalTemperatureProvider.getEnvironmentTemperature(player) + EnvironmentalTemperatureProvider.handleTimeOfDay(player).get().getChange();
    }

    public static float getEnvironmentTemperature(Player player) {
        float actual = Climate.getTemperature((Level)player.level(), (BlockPos)player.getOnPos()) + 4.0f;
        float diff = actual - (float)((Integer)TFCAmbientalConfig.averageTemperature.get()).intValue();
        return (float)((Integer)TFCAmbientalConfig.averageTemperature.get()).intValue() + (diff + Math.signum(diff) * 4.0f * (Math.min(4.0f, Math.abs(diff)) / 4.0f));
    }

    public static float getEnvironmentHumidity(Player player) {
        return Climate.getRainfall((Level)player.level(), (BlockPos)player.getOnPos()) / 3000.0f;
    }

    public static int getSkylight(Player player) {
        BlockPos pos = new BlockPos((Vec3i)player.getOnPos()).above(2);
        return player.level().getBrightness(LightLayer.SKY, pos);
    }

    public static int getBlockLight(Player player) {
        BlockPos pos = new BlockPos((Vec3i)player.getOnPos()).above(1);
        return player.level().getBrightness(LightLayer.BLOCK, pos);
    }

    public static Optional<TemperatureModifier> handleFire(Player player) {
        if (player.isOnFire()) {
            TemperatureModifier.defined("on_fire", 4.0f, 4.0f, -1.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleGeneralTemperature(Player player) {
        return Optional.of(new TemperatureModifier("environment", EnvironmentalTemperatureProvider.getEnvironmentTemperature(player), EnvironmentalTemperatureProvider.getEnvironmentHumidity(player)));
    }

    public static Optional<TemperatureModifier> handleTimeOfDay(Player player) {
        int dayTicks = (int)(player.level().dayTime() % 24000L);
        if (dayTicks < 6000) {
            return TemperatureModifier.defined("morning", 1.0f, 0.0f);
        }
        if (dayTicks < 12000) {
            return TemperatureModifier.defined("afternoon", 4.0f, 0.0f, -0.02f);
        }
        if (dayTicks < 18000) {
            return TemperatureModifier.defined("evening", 1.0f, 0.0f);
        }
        return TemperatureModifier.defined("night", -1.0f, 0.0f);
    }

    public static Optional<TemperatureModifier> handleWater(Player player) {
        if (player.isInWater()) {
            BlockPos pos = player.getOnPos().above();
            BlockState state = player.level().getBlockState(pos);
            if (state.getFluidState().is((Fluid)TFCFluids.SPRING_WATER.getFlowing()) || state.getFluidState().is((Fluid)TFCFluids.SPRING_WATER.getSource())) {
                return TemperatureModifier.defined("in_hot_water", 6.0f, 2.0f, 10.0f);
            }
            if (state.getBlock() == Blocks.LAVA) {
                return TemperatureModifier.defined("in_lava", 10.0f, 5.0f, -10.0f);
            }
            return TemperatureModifier.defined("in_water", -6.0f, 2.0f, 10.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleRain(Player player) {
        if (player.level().isRaining()) {
            boolean isInRain = player.level().isRainingAt(player.blockPosition());
            if (EnvironmentalTemperatureProvider.getSkylight(player) < 15) {
                return TemperatureModifier.defined("weather", -2.0f, 0.1f, isInRain ? 0.5f : 0.0f);
            }
            return TemperatureModifier.defined("weather", -4.0f, 0.3f, isInRain ? 4.0f : 0.5f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleSprinting(Player player) {
        if (player.isSprinting()) {
            return TemperatureModifier.defined("sprint", 2.0f, 0.3f, -0.05f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleUnderground(Player player) {
        if (EnvironmentalTemperatureProvider.getSkylight(player) < 2 && player.getOnPos().getY() < 60) {
            return TemperatureModifier.defined("underground", (float)(-0.1 * (double)(60 - player.getOnPos().getY())), 0.2f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleShade(Player player) {
        int light = Math.max(12, EnvironmentalTemperatureProvider.getSkylight(player));
        if (light < 15) {
            ((PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE)).setUnderRoof(true);
            float temp = EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player);
            float avg = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
            if (temp > avg) {
                return TemperatureModifier.defined("shade", -Math.abs(avg - temp) * 0.6f, 0.0f);
            }
        } else {
            ((PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE)).setUnderRoof(false);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleCozy(Player player) {
        float temp = EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player);
        float avg = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
        PlayerTemperature temperatureCapability = (PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE);
        temperatureCapability.setInside(EnvironmentalTemperatureProvider.calculateEnclosure(player, 30));
        if (temp < avg - 1.0f) {
            boolean[] isInside = new boolean[]{false};
            isInside[0] = temperatureCapability.isInside();
            if (isInside[0]) {
                return TemperatureModifier.defined("cozy", Math.abs(avg - 1.0f - temp) * 0.6f, 0.0f);
            }
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleThirst(Player player) {
        PlayerInfo stats;
        IPlayerInfo iPlayerInfo = IPlayerInfo.get((Player)player);
        if (iPlayerInfo instanceof PlayerInfo && (stats = (PlayerInfo)iPlayerInfo).getThirst() > 70.0f && EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player) > ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue() + 3.0f) {
            return TemperatureModifier.defined("well_hydrated", -1.5f, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleFood(Player player) {
        if (player.getFoodData().getFoodLevel() > 14 && EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player) < ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue() - 3.0f) {
            return TemperatureModifier.defined("well_fed", 1.5f, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleDiet(Player player) {
        IPlayerInfo iPlayerInfo = IPlayerInfo.get((Player)player);
        if (iPlayerInfo instanceof PlayerInfo) {
            PlayerInfo stats = (PlayerInfo)iPlayerInfo;
            if (EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player) < ((Double)TFCAmbientalConfig.coolThreshold.get()).floatValue()) {
                float grainLevel = stats.nutrition().getNutrient(Nutrient.GRAIN);
                float meatLevel = stats.nutrition().getNutrient(Nutrient.PROTEIN);
                return TemperatureModifier.defined("nutrients", 4.0f * grainLevel * meatLevel, 0.0f);
            }
            if (EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player) > ((Double)TFCAmbientalConfig.hotThreshold.get()).floatValue()) {
                float fruitLevel = stats.nutrition().getNutrient(Nutrient.FRUIT);
                float veggieLevel = stats.nutrition().getNutrient(Nutrient.VEGETABLES);
                return TemperatureModifier.defined("nutrients", -4.0f * fruitLevel * veggieLevel, 0.0f);
            }
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleWetness(Player player) {
        PlayerTemperature temperatureCapability = (PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE);
        float mod = -0.01f;
        float potency = 0.2f;
        if (temperatureCapability.getWetness() > 1.5f && !player.isInWater()) {
            float envTemperature = EnvironmentalTemperatureProvider.getEnvironmentTemperature(player);
            potency = envTemperature < temperatureCapability.getTemperature() ? 5.5f : potency;
        }
        return TemperatureModifier.defined("wetness", mod * temperatureCapability.getWetness(), potency, !player.isInWater() ? -0.03f : 0.0f);
    }

    public static Optional<TemperatureModifier> handleTFCSurviveEffects(Player player) {
        if (player.getActiveEffects().stream().anyMatch(instance -> ((MobEffect)instance.getEffect().value()).getDescriptionId().endsWith("warming"))) {
            return TemperatureModifier.defined("warming_effect", 4.0f, 0.0f);
        }
        if (player.getActiveEffects().stream().anyMatch(instance -> ((MobEffect)instance.getEffect().value()).getDescriptionId().endsWith("cooling"))) {
            return TemperatureModifier.defined("cooling_effect", -4.0f, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
        for (EnvironmentalTemperatureProvider fn : AmbientalRegistry.ENVIRONMENT) {
            cache.add(fn.getModifier(player));
        }
    }
}

