/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.api.EnvironmentalTemperatureProvider;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import com.lumintorious.tfcambiental.item.ClothesItem;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import top.theillusivec4.curios.api.CuriosApi;

@FunctionalInterface
public interface EquipmentTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1, ItemStack var2);

    public static Optional<TemperatureModifier> handleClothes(Player player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ClothesItem) {
            ClothesItem clothesItem = (ClothesItem)item;
            return clothesItem.getProvider().getModifier(player, stack);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleSunlightCap(Player player, ItemStack stack) {
        float envTemp;
        ArmorItem armorItem;
        float AVERAGE = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
        Item item = stack.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getType() == ArmorItem.Type.HELMET && player.level().getBrightness(LightLayer.SKY, player.getOnPos().above()) > 14 && (envTemp = EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player)) > AVERAGE) {
            float diff = envTemp - AVERAGE;
            Optional<TemperatureModifier> helmetMod = EquipmentTemperatureProvider.handleClothes(player, stack);
            diff = helmetMod.isPresent() ? (diff -= helmetMod.get().getChange()) : (diff -= 1.0f);
            return TemperatureModifier.defined("sunlight_protection", diff * -0.2f, -0.1f);
        }
        return TemperatureModifier.none();
    }

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack stack = c.getStackInSlot(i);
                for (EquipmentTemperatureProvider fn : AmbientalRegistry.EQUIPMENT) {
                    cache.add(fn.getModifier(player, stack));
                }
            }
        });
        for (EquipmentTemperatureProvider fn : AmbientalRegistry.EQUIPMENT) {
            cache.add(fn.getModifier(player, player.getItemBySlot(EquipmentSlot.HEAD)));
            cache.add(fn.getModifier(player, player.getItemBySlot(EquipmentSlot.CHEST)));
            cache.add(fn.getModifier(player, player.getItemBySlot(EquipmentSlot.LEGS)));
            cache.add(fn.getModifier(player, player.getItemBySlot(EquipmentSlot.FEET)));
        }
    }

    public static ItemStack getEquipmentByType(Player player, ArmorItem.Type type) {
        ArmorItem armorItem;
        Item item;
        ItemStack feetArmor = player.getItemBySlot(EquipmentSlot.FEET);
        if (!feetArmor.isEmpty() && (item = feetArmor.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)item).getType().equals((Object)type)) {
            return feetArmor;
        }
        return CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).map(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ArmorItem armorItem;
                ItemStack stack = c.getStackInSlot(i);
                Item patt0$temp = stack.getItem();
                if (!(patt0$temp instanceof ArmorItem) || !(armorItem = (ArmorItem)patt0$temp).getType().equals((Object)type)) continue;
                return stack;
            }
            return ItemStack.EMPTY;
        }).orElse(ItemStack.EMPTY);
    }
}

