/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.client;

import com.lumintorious.tfcambiental.TFCAmbiental;
import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.data.PlayerTemperature;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class TFCAmbientalGuiRenderer
implements LayeredDraw.Layer {
    public static final TFCAmbientalGuiRenderer INSTANCE = new TFCAmbientalGuiRenderer();
    public static final ResourceLocation COLD_VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/cold_vignette.png");
    public static final ResourceLocation HOT_VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/hot_vignette.png");
    public static final ResourceLocation MINUS = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/lower.png");
    public static final ResourceLocation PLUS = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/higher.png");
    public static final ResourceLocation MINUSER = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/lowerer.png");
    public static final ResourceLocation PLUSER = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/higherer.png");
    public static final ResourceLocation WET = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/wet.png");
    public static final ResourceLocation SHELTER_ROOF = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/shelter_roof.png");
    public static final ResourceLocation SHELTER_FULL = ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"textures/gui/shelter_full.png");

    public void render(GuiGraphics stack, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        if (entity instanceof Player) {
            float blueCol;
            float greenCol;
            float redCol;
            Player player = (Player)entity;
            if (player.isCreative() || !player.isAlive() || player.isSpectator()) {
                return;
            }
            PlayerTemperature tempSystem = (PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE);
            int width = mc.getWindow().getGuiScaledWidth();
            int height = mc.getWindow().getGuiScaledHeight();
            int healthRowHeight = mc.getWindow().getGuiScaledHeight();
            int armorRowHeight = healthRowHeight - 51;
            int mid = mc.getWindow().getGuiScaledWidth() / 2;
            RenderSystem.enableBlend();
            float AVERAGE = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
            float HOT_THRESHOLD = ((Double)TFCAmbientalConfig.hotThreshold.get()).floatValue();
            float COOL_THRESHOLD = ((Double)TFCAmbientalConfig.coolThreshold.get()).floatValue();
            if (tempSystem.getTemperature() > AVERAGE) {
                float hotRange = HOT_THRESHOLD - AVERAGE + 2.0f;
                float red = Math.max(0.0f, Math.min(1.0f, (tempSystem.getTemperature() - AVERAGE) / hotRange));
                redCol = 1.0f;
                greenCol = 1.0f - red / 2.4f;
                blueCol = 1.0f - red / 1.6f;
            } else {
                float coolRange = AVERAGE - COOL_THRESHOLD - 2.0f;
                float blue = Math.max(0.0f, Math.min(1.0f, (AVERAGE - tempSystem.getTemperature()) / coolRange));
                redCol = 1.0f - blue / 1.6f;
                greenCol = 1.0f - blue / 2.4f;
                blueCol = 1.0f;
            }
            float change = tempSystem.getTemperatureChange();
            if (tempSystem.isInside()) {
                this.drawTexturedModalRect(stack, (float)(mid - 9) + ((Double)TFCAmbientalConfig.shelterX.get()).floatValue(), (float)(armorRowHeight - 8) + ((Double)TFCAmbientalConfig.shelterY.get()).floatValue(), 18.0f, 18.0f, SHELTER_FULL);
            } else if (tempSystem.isUnderRoof()) {
                this.drawTexturedModalRect(stack, (float)(mid - 9) + ((Double)TFCAmbientalConfig.shelterX.get()).floatValue(), (float)(armorRowHeight - 8) + ((Double)TFCAmbientalConfig.shelterY.get()).floatValue(), 18.0f, 18.0f, SHELTER_ROOF);
            }
            RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
            if ((double)tempSystem.getTemperature() > (Double)TFCAmbientalConfig.hotThreshold.get()) {
                this.drawTexturedModalRect(stack, (float)(mid + 85) + ((Double)TFCAmbientalConfig.thirstDrainX.get()).floatValue(), (float)(armorRowHeight + 12) + ((Double)TFCAmbientalConfig.thirstDrainY.get()).floatValue(), 14.0f, 14.0f, MINUSER);
            }
            if ((double)tempSystem.getTemperature() < (Double)TFCAmbientalConfig.coolThreshold.get()) {
                this.drawTexturedModalRect(stack, (float)(mid + 85) + ((Double)TFCAmbientalConfig.hungerDrainX.get()).floatValue(), (float)(armorRowHeight + 5) + ((Double)TFCAmbientalConfig.hungerDrainY.get()).floatValue(), 14.0f, 14.0f, MINUSER);
            }
            if ((double)tempSystem.getTemperature() < (Double)TFCAmbientalConfig.freezeThreshold.get() || (double)tempSystem.getTemperature() > (Double)TFCAmbientalConfig.burnThreshold.get()) {
                RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
                this.drawTexturedModalRect(stack, (float)(mid - 98) + ((Double)TFCAmbientalConfig.healthDrainX.get()).floatValue(), (float)(armorRowHeight + 10) + ((Double)TFCAmbientalConfig.healthDrainY.get()).floatValue(), 14.0f, 14.0f, MINUSER);
            }
            RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)redCol, (float)greenCol, (float)blueCol, (float)0.9f);
            if (change > 0.0f) {
                if (change > 0.004f) {
                    this.drawTexturedModalRect(stack, (float)(mid - 8) + ((Double)TFCAmbientalConfig.temperatureX.get()).floatValue(), (float)(armorRowHeight - 5) + ((Double)TFCAmbientalConfig.temperatureY.get()).floatValue(), 16.0f, 16.0f, PLUSER);
                } else {
                    this.drawTexturedModalRect(stack, (float)(mid - 8) + ((Double)TFCAmbientalConfig.temperatureX.get()).floatValue(), (float)(armorRowHeight - 5) + ((Double)TFCAmbientalConfig.temperatureY.get()).floatValue(), 16.0f, 16.0f, PLUS);
                }
            } else if (change < -0.004f) {
                this.drawTexturedModalRect(stack, (float)(mid - 8) + ((Double)TFCAmbientalConfig.temperatureX.get()).floatValue(), (float)(armorRowHeight - 5) + ((Double)TFCAmbientalConfig.temperatureY.get()).floatValue(), 16.0f, 16.0f, MINUSER);
            } else {
                this.drawTexturedModalRect(stack, (float)(mid - 8) + ((Double)TFCAmbientalConfig.temperatureX.get()).floatValue(), (float)(armorRowHeight - 5) + ((Double)TFCAmbientalConfig.temperatureY.get()).floatValue(), 16.0f, 16.0f, MINUS);
            }
            if (tempSystem.getWetness() > 1.0f) {
                this.drawTexturedModalRect(stack, (float)((double)(mid - 12) + (Double)TFCAmbientalConfig.wetnessX.get()), (float)((double)(armorRowHeight + 5) + (Double)TFCAmbientalConfig.wetnessY.get()), 16.0f, 16.0f, WET);
            }
            if (player.isCrouching()) {
                float shiftHeight = 0.0f;
                int air = player.getAirSupply();
                if (player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || air < 300) {
                    shiftHeight = 10.0f;
                }
                Font f = Minecraft.getInstance().font;
                String tempStr = String.format("%.1f\u00ba -> %.1f\u00ba", Float.valueOf(tempSystem.getTemperature()), Float.valueOf(tempSystem.getTargetTemperature()));
                stack.drawString(f, tempStr, (float)(mid + 94) + ((Double)TFCAmbientalConfig.textStatusX.get()).floatValue(), (float)(armorRowHeight + 40) + ((Double)TFCAmbientalConfig.textStatusY.get()).floatValue(), TFCAmbientalGuiRenderer.getIntFromColor(redCol, greenCol, blueCol), false);
            }
            TFCAmbientalGuiRenderer.drawTemperatureVignettes(stack, width, height, player);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
            RenderSystem.disableBlend();
        }
    }

    private void drawTexturedModalRect(GuiGraphics stack, float x, float y, float width, float height, ResourceLocation loc) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.getTextureManager().bindForSetup(loc);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)loc);
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        stack.blit(loc, (int)x, (int)y, 0.0f, 0.0f, (int)width, (int)height, (int)width, (int)height);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawTemperatureVignettes(GuiGraphics stack, int width, int height, Player player) {
        ResourceLocation vignetteLocation = null;
        PlayerTemperature tempSystem = (PlayerTemperature)player.getData(TFCAmbiental.PLAYER_TEMPERATURE);
        float temperature = tempSystem.getTemperature();
        float BURN_THRESHOLD = ((Double)TFCAmbientalConfig.burnThreshold.get()).floatValue();
        float FREEZE_THRESHOLD = ((Double)TFCAmbientalConfig.freezeThreshold.get()).floatValue();
        float opacity = 0.0f;
        if (temperature > BURN_THRESHOLD - 2.5f) {
            vignetteLocation = HOT_VIGNETTE;
            opacity = Math.min(0.5f, (temperature - (BURN_THRESHOLD - 2.5f)) / 18.0f);
        } else if (temperature < FREEZE_THRESHOLD + 2.5f) {
            vignetteLocation = COLD_VIGNETTE;
            opacity = Math.min(0.5f, (FREEZE_THRESHOLD + 2.5f - temperature) / 18.0f);
        }
        if (vignetteLocation != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)vignetteLocation);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            stack.setColor(1.0f, 1.0f, 1.0f, opacity);
            stack.blit(vignetteLocation, 0, 0, 0.0f, 0.0f, width, height, width, height);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static int getIntFromColor(float red, float green, float blue) {
        int R = Math.round(255.0f * red);
        int G = Math.round(255.0f * green);
        int B = Math.round(255.0f * blue);
        R = R << 16 & 0xFF0000;
        G = G << 8 & 0xFF00;
        return 0xFF000000 | R | G | (B &= 0xFF);
    }
}

