/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.compat.curios;

import com.google.common.collect.Maps;
import com.lumintorious.tfcambiental.compat.curios.CurioClothesLayer;
import com.lumintorious.tfcambiental.item.ClothesItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ClothesCurioRenderer
implements ICurioRenderer {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            livingEntity = stack.getItem();
            if (livingEntity instanceof ClothesItem) {
                ClothesItem clothesItem = (ClothesItem)livingEntity;
                if (slotContext.entity().getItemBySlot(clothesItem.getType().getSlot()).isEmpty()) {
                    HumanoidModel model = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
                    CurioClothesLayer<LivingEntity, M, HumanoidModel> layer = new CurioClothesLayer<LivingEntity, M, HumanoidModel>(renderLayerParent, model, model);
                    poseStack.pushPose();
                    layer.render(stack, poseStack, renderTypeBuffer, light, slotContext.entity());
                    poseStack.popPose();
                }
            }
        }
    }
}

