/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.compat.curios;

import com.google.common.collect.Maps;
import com.lumintorious.tfcambiental.item.ClothesItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.NotNull;

public class CurioClothesLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public final A innerModel;
    public final A outerModel;
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();

    public CurioClothesLayer(RenderLayerParent<T, M> renderLayerParent, A innerModel, A outerModel) {
        super(renderLayerParent);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    public void render(ItemStack itemStack, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T player) {
        this.renderArmorPiece(itemStack, pMatrixStack, pBuffer, player, ArmorItem.Type.HELMET, pPackedLight, this.getArmorModel(ArmorItem.Type.HELMET));
        this.renderArmorPiece(itemStack, pMatrixStack, pBuffer, player, ArmorItem.Type.CHESTPLATE, pPackedLight, this.getArmorModel(ArmorItem.Type.CHESTPLATE));
        this.renderArmorPiece(itemStack, pMatrixStack, pBuffer, player, ArmorItem.Type.LEGGINGS, pPackedLight, this.getArmorModel(ArmorItem.Type.LEGGINGS));
        this.renderArmorPiece(itemStack, pMatrixStack, pBuffer, player, ArmorItem.Type.BOOTS, pPackedLight, this.getArmorModel(ArmorItem.Type.BOOTS));
    }

    private A getArmorModel(ArmorItem.Type slot) {
        return this.usesInnerModel(slot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(ArmorItem.Type pSlot) {
        return pSlot.equals((Object)ArmorItem.Type.LEGGINGS);
    }

    private void renderArmorPiece(ItemStack itemstack, PoseStack poseStack, MultiBufferSource bufferSource, T entity, ArmorItem.Type armorType, int light, A playerModel) {
        ClothesItem clothesItem;
        Item item = itemstack.getItem();
        if (item instanceof ClothesItem && (clothesItem = (ClothesItem)item).getType().equals((Object)armorType)) {
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(playerModel);
            this.setPartVisibility(playerModel, armorType.getSlot());
            Model model = ClientHooks.getArmorModel(entity, (ItemStack)itemstack, (EquipmentSlot)armorType.getSlot(), playerModel);
            this.renderModel(poseStack, bufferSource, light, itemstack.hasFoil(), model, this.getArmorTexture((Entity)entity, itemstack, armorType, null, playerModel));
        }
    }

    public ResourceLocation getArmorTexture(Entity entity, ItemStack stack, ArmorItem.Type slot, @Nullable String type, A playerModel) {
        ClothesItem item = (ClothesItem)stack.getItem();
        ResourceLocation texture = ResourceLocation.withDefaultNamespace((String)"hi");
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", texture.getNamespace(), texture.getPath(), this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1);
        ResourceLocation.read((String)s1).ifSuccess(resourceLocation -> ARMOR_LOCATION_CACHE.put(s1, (ResourceLocation)resourceLocation));
        return resourcelocation;
    }

    public void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, boolean hasFoil, Model model, ResourceLocation armorResource) {
        if (armorResource != null) {
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)armorResource), (boolean)hasFoil);
            model.renderToBuffer(poseStack, vertexconsumer, packedLight, 1, 1);
        }
    }

    protected void setPartVisibility(A pModel, EquipmentSlot pSlot) {
        pModel.setAllVisible(false);
        switch (pSlot) {
            case HEAD: {
                ((HumanoidModel)pModel).head.visible = true;
                ((HumanoidModel)pModel).hat.visible = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)pModel).body.visible = true;
                ((HumanoidModel)pModel).rightArm.visible = true;
                ((HumanoidModel)pModel).leftArm.visible = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)pModel).body.visible = true;
                ((HumanoidModel)pModel).rightLeg.visible = true;
                ((HumanoidModel)pModel).leftLeg.visible = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)pModel).rightLeg.visible = true;
                ((HumanoidModel)pModel).leftLeg.visible = true;
            }
        }
    }
}

