/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental;

import com.lumintorious.tfcambiental.TFCAmbiental;
import com.lumintorious.tfcambiental.data.PlayerTemperature;
import com.lumintorious.tfcambiental.data.PlayerTemperaturePacket;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import com.lumintorious.tfcambiental.item.ClothesItem;
import com.lumintorious.tfcambiental.item.TFCAmbientalItems;
import java.text.DecimalFormat;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import top.theillusivec4.curios.api.SlotTypeMessage;

public class TFCAmbientalEvents {
    public static final String CURIOS_ID = "curios";

    public static void initAll(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.addListener(TFCAmbientalEvents::onPlayerUpdate);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, TFCAmbientalEvents::addTooltips);
        modEventBus.addListener(TFCAmbientalEvents::onInterModComms);
        modEventBus.addListener(TFCAmbientalEvents::registerPayloadHandlers);
    }

    public static void onPlayerUpdate(PlayerTickEvent.Post event) {
        Level level = event.getEntity().level();
        if (event.getEntity() == null || event.getEntity().level() == null) {
            return;
        }
        if (!level.isClientSide()) {
            ((PlayerTemperature)event.getEntity().getData(TFCAmbiental.PLAYER_TEMPERATURE)).update(event.getEntity());
            if (event.getEntity().isHolding(Items.ACACIA_BOAT)) {
                event.getEntity().sendSystemMessage((Component)Component.literal((String)"===="));
                event.getEntity().sendSystemMessage((Component)Component.literal((String)("" + ((PlayerTemperature)event.getEntity().getData(TFCAmbiental.PLAYER_TEMPERATURE)).getTemperatureChange())));
                for (TemperatureModifier modifier : ((PlayerTemperature)event.getEntity().getData(TFCAmbiental.PLAYER_TEMPERATURE)).getModifiers()) {
                    event.getEntity().sendSystemMessage((Component)Component.literal((String)(modifier.getUnlocalizedName() + " - " + modifier.getChange())));
                }
            }
        }
    }

    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.COMBAT)) {
            // empty if block
        }
    }

    private static void onInterModComms(InterModEnqueueEvent event) {
        ResourceLocation HEAD_SLOT = ResourceLocation.fromNamespaceAndPath((String)CURIOS_ID, (String)"slot/clothes_hat");
        ResourceLocation CHEST_SLOT = ResourceLocation.fromNamespaceAndPath((String)CURIOS_ID, (String)"slot/clothes_torso");
        ResourceLocation LEGS_SLOT = ResourceLocation.fromNamespaceAndPath((String)CURIOS_ID, (String)"slot/clothes_pants");
        ResourceLocation FEET_SLOT = ResourceLocation.fromNamespaceAndPath((String)CURIOS_ID, (String)"slot/clothes_socks");
        InterModComms.sendTo((String)CURIOS_ID, (String)"register_type", () -> new SlotTypeMessage.Builder("clothes_hat").icon(HEAD_SLOT).priority(90).build());
        InterModComms.sendTo((String)CURIOS_ID, (String)"register_type", () -> new SlotTypeMessage.Builder("clothes_torso").icon(CHEST_SLOT).priority(91).build());
        InterModComms.sendTo((String)CURIOS_ID, (String)"register_type", () -> new SlotTypeMessage.Builder("clothes_pants").icon(LEGS_SLOT).priority(92).build());
        InterModComms.sendTo((String)CURIOS_ID, (String)"register_type", () -> new SlotTypeMessage.Builder("clothes_socks").icon(FEET_SLOT).priority(93).build());
        InterModComms.sendTo((String)CURIOS_ID, (String)"register_type", () -> new SlotTypeMessage.Builder("feet").icon(FEET_SLOT).priority(94).build());
    }

    private static String formatAttribute(float attribute) {
        DecimalFormat attributeD = new DecimalFormat("0.0");
        String attributeS = attributeD.format(attribute);
        if ((double)attribute > 0.001 || (double)attribute < -0.001) {
            if (attribute > 0.0f) {
                return "+" + attributeS;
            }
            return attributeS;
        }
        return "";
    }

    private static void addTooltips(ItemTooltipEvent event) {
        if (event.getEntity() != null && !event.getEntity().level().isClientSide()) {
            return;
        }
        float warmth = 0.0f;
        float insulation = 0.0f;
        warmth = (float)Math.floor(warmth / 0.25f) * 0.25f;
        insulation = (float)Math.floor(insulation / 0.25f) * -0.25f;
        Item item = event.getItemStack().getItem();
        if (item instanceof ClothesItem) {
            ClothesItem clothesItem = (ClothesItem)item;
            Optional<TemperatureModifier> modifier = clothesItem.getProvider().getModifier(event.getEntity(), event.getItemStack());
            if (modifier.isPresent()) {
                warmth = modifier.get().getChange();
                insulation = modifier.get().getPotency() * -100.0f;
                if (warmth != 0.0f) {
                    event.getToolTip().add(Component.translatable((String)"tfcambiental.tooltip.warmth", (Object[])new Object[]{TFCAmbientalEvents.formatAttribute(warmth)}).withStyle(ChatFormatting.BLUE));
                }
                if (clothesItem.getType().equals((Object)ArmorItem.Type.HELMET)) {
                    event.getToolTip().add(Component.translatable((String)"tfcambiental.tooltip.sun_protection").withStyle(ChatFormatting.BLUE));
                }
                if (insulation != 0.0f) {
                    event.getToolTip().add(Component.translatable((String)"tfcambiental.tooltip.insulation", (Object[])new Object[]{TFCAmbientalEvents.formatAttribute(insulation) + "%"}).withStyle(ChatFormatting.BLUE));
                }
            }
            if (event.getItemStack().is((Item)TFCAmbientalItems.LEATHER_APRON.get())) {
                event.getToolTip().add(Component.translatable((String)"tfcambiental.tooltip.apron").withStyle(ChatFormatting.BLUE));
            }
        } else {
            ArmorItem armorItem;
            Item item2 = event.getItemStack().getItem();
            if (item2 instanceof ArmorItem && (armorItem = (ArmorItem)item2).getType().equals((Object)ArmorItem.Type.HELMET)) {
                event.getToolTip().add(Component.translatable((String)"tfcambiental.tooltip.sun_protection").withStyle(ChatFormatting.BLUE));
            }
        }
    }

    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(PlayerTemperaturePacket.TYPE, PlayerTemperaturePacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(TFCAmbientalEvents::handleTemperatureUpdateOnClient, TFCAmbientalEvents::handleTemperatureUpdateOnServer));
    }

    public static void handleTemperatureUpdateOnClient(PlayerTemperaturePacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().player != null) {
                PlayerTemperature newData = data.create();
                Minecraft.getInstance().player.setData(TFCAmbiental.PLAYER_TEMPERATURE, (Object)newData);
            }
        });
    }

    public static void handleTemperatureUpdateOnServer(PlayerTemperaturePacket data, IPayloadContext context) {
    }
}

