/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.api.EnvironmentalTemperatureProvider;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import com.lumintorious.tfcambiental.item.TFCAmbientalItems;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.curios.api.CuriosApi;

@FunctionalInterface
public interface BlockEntityTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1, BlockEntity var2);

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
    }

    private static boolean hasProtection(Player player) {
        float AVERAGE;
        List item = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)TFCAmbientalItems.LEATHER_APRON.get());
        boolean hasItemInSlots = StreamSupport.stream(player.getArmorSlots().spliterator(), false).anyMatch(stack -> stack.is((Item)TFCAmbientalItems.LEATHER_APRON.get()));
        if (item.isEmpty() && !hasItemInSlots) {
            return false;
        }
        float environmentTemperature = EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player);
        return environmentTemperature > (AVERAGE = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue());
    }

    public static Optional<TemperatureModifier> handleCharcoalForge(Player player, BlockEntity entity) {
        if (entity instanceof CharcoalForgeBlockEntity) {
            CharcoalForgeBlockEntity forge = (CharcoalForgeBlockEntity)entity;
            float temp = forge.getTemperature();
            float change = temp / 80.0f;
            if (BlockEntityTemperatureProvider.hasProtection(player)) {
                change *= 0.2f;
            }
            return TemperatureModifier.defined("charcoal_forge", change, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleFirePit(Player player, BlockEntity entity) {
        if (entity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity pit = (AbstractFirepitBlockEntity)entity;
            float temp = pit.getTemperature();
            float change = temp / 80.0f;
            if (BlockEntityTemperatureProvider.hasProtection(player)) {
                change *= 0.2f;
            }
            return TemperatureModifier.defined("fire_pit", change, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleBloomery(Player player, BlockEntity entity) {
        if (entity instanceof BloomeryBlockEntity) {
            float change;
            BloomeryBlockEntity bloomery = (BloomeryBlockEntity)entity;
            float f = change = bloomery.getRemainingTicks() > 0L ? 8.0f : 0.0f;
            if (BlockEntityTemperatureProvider.hasProtection(player)) {
                change *= 0.2f;
            }
            return TemperatureModifier.defined("bloomery", change, 0.0f);
        }
        return TemperatureModifier.none();
    }

    public static Optional<TemperatureModifier> handleIHeatBlock(Player player, BlockEntity entity) {
        return Optional.empty();
    }
}

