/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.api;

import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.TFCAmbientalTags;
import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.Optional;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface ItemTemperatureProvider {
    public Optional<TemperatureModifier> getModifier(Player var1, ItemStack var2);

    public static void evaluateAll(Player player, TemperatureModifier.Cache cache) {
        for (ItemStack stack : player.getInventory().items) {
            for (ItemTemperatureProvider provider : AmbientalRegistry.ITEMS) {
                cache.add(provider.getModifier(player, stack));
            }
        }
    }

    public static Optional<TemperatureModifier> handleTemperatureCapability(Player player, ItemStack stack) {
        IHeat cap = HeatCapability.get((ItemStack)stack);
        if (cap == null) {
            return Optional.empty();
        }
        float temp = cap.getTemperature() / 800.0f;
        return Optional.of(new TemperatureModifier("heat_item", temp, 0.1f * (float)stack.getCount()));
    }

    public static Optional<TemperatureModifier> handleHotIngots(Player player, ItemStack stack) {
        return stack.is(TFCAmbientalTags.HOT_INGOTS) ? Optional.of(new TemperatureModifier("heat_item", ((Double)TFCAmbientalConfig.hotIngotTemperature.get()).floatValue(), 0.1f * (float)stack.getCount())) : TemperatureModifier.none();
    }
}

