/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.data;

import com.lumintorious.tfcambiental.TFCAmbiental;
import com.lumintorious.tfcambiental.TFCAmbientalConfig;
import com.lumintorious.tfcambiental.api.BlockEntityTemperatureProvider;
import com.lumintorious.tfcambiental.api.BlockTemperatureProvider;
import com.lumintorious.tfcambiental.api.EntityTemperatureProvider;
import com.lumintorious.tfcambiental.api.EnvironmentalTemperatureProvider;
import com.lumintorious.tfcambiental.api.EquipmentTemperatureProvider;
import com.lumintorious.tfcambiental.api.ItemTemperatureProvider;
import com.lumintorious.tfcambiental.data.PlayerTemperaturePacket;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import com.lumintorious.tfcambiental.item.ClothesItem;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.player.PlayerInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerTemperature {
    public boolean isDefault;
    private int tick = 0;
    private int damageTick = 0;
    private int durabilityTick = 0;
    public float temperature;
    public float wetness;
    private float target = 15.0f;
    private float targetWetness = 0.0f;
    private float potency = 0.0f;
    private boolean isInside = false;
    private boolean isUnderRoof = false;
    private TemperatureModifier.Cache modifiers = new TemperatureModifier.Cache();
    public static final float BAD_MULTIPLIER = 0.001f;
    public static final float GOOD_MULTIPLIER = 0.0025f;
    public static final float CHANGE_CAP = 8.0f;
    public static final float WET_CHANGE_CAP = 2.0f;
    public static final float HIGH_CHANGE = 0.004f;
    public static final IAttachmentSerializer<CompoundTag, PlayerTemperature> SERIALIZER = new IAttachmentSerializer<CompoundTag, PlayerTemperature>(){

        public PlayerTemperature read(IAttachmentHolder iAttachmentHolder, CompoundTag compoundTag, HolderLookup.Provider provider) {
            return PlayerTemperature.read(compoundTag);
        }

        @Nullable
        public CompoundTag write(PlayerTemperature temperature, HolderLookup.Provider provider) {
            return temperature.write();
        }
    };

    public PlayerTemperature() {
        this(false);
    }

    public PlayerTemperature(boolean isDefault) {
        this.temperature = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
        this.isDefault = isDefault;
    }

    public float getTemperatureChange() {
        float speed = this.getPotency() * 0.022f * ((Double)TFCAmbientalConfig.temperatureChangeSpeed.get()).floatValue();
        float change = Math.min(8.0f, Math.max(-8.0f, this.getTargetTemperature() - this.temperature));
        float AVERAGE = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
        float changeSign = Math.signum(change);
        float newTemp = this.temperature + (change += changeSign * 3.0f);
        speed = this.temperature < AVERAGE && newTemp > this.temperature || this.temperature > AVERAGE && newTemp < this.temperature ? (speed *= 0.0025f * ((Double)TFCAmbientalConfig.goodTemperatureChangeSpeed.get()).floatValue()) : (speed *= 0.001f * ((Double)TFCAmbientalConfig.badTemperatureChangeSpeed.get()).floatValue());
        return change * speed;
    }

    public float getWetnessChange() {
        float AVERAGE = ((Integer)TFCAmbientalConfig.averageTemperature.get()).floatValue();
        float speed = (this.getTemperature() > AVERAGE ? 0.001f : 5.0E-4f) * ((Double)TFCAmbientalConfig.wetnessChangeSpeed.get()).floatValue();
        if (this.getTargetWetness() > this.wetness) {
            speed *= 16.0f;
        }
        float change = Math.min(2.0f, Math.max(-2.0f, this.getTargetWetness() - this.wetness));
        return change * speed;
    }

    public void evaluateModifiers(Player player) {
        this.modifiers = new TemperatureModifier.Cache();
        ItemTemperatureProvider.evaluateAll(player, this.modifiers);
        EnvironmentalTemperatureProvider.evaluateAll(player, this.modifiers);
        BlockTemperatureProvider.evaluateAll(player, this.modifiers);
        BlockEntityTemperatureProvider.evaluateAll(player, this.modifiers);
        EquipmentTemperatureProvider.evaluateAll(player, this.modifiers);
        EntityTemperatureProvider.evaluateAll(player, this.modifiers);
        this.modifiers.keepOnlyNEach(4);
        this.target = this.modifiers.getTargetTemperature();
        this.potency = this.modifiers.getTotalPotency();
        this.targetWetness = this.modifiers.getTargetWetness();
        if (this.target > this.temperature && this.temperature > ((Double)TFCAmbientalConfig.hotThreshold.get()).floatValue()) {
            this.potency /= this.potency;
        }
        if (this.target < this.temperature && this.temperature < ((Double)TFCAmbientalConfig.coolThreshold.get()).floatValue()) {
            this.potency /= this.potency;
        }
        this.potency = Math.max(1.0f, this.potency);
    }

    public float getTargetTemperature() {
        return this.target;
    }

    public float getTargetWetness() {
        return this.targetWetness;
    }

    public float getPotency() {
        return this.potency;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getWetness() {
        return this.wetness;
    }

    public void setWetness(float wetness) {
        this.wetness = Math.max(0.0f, wetness);
    }

    public boolean isInside() {
        return this.isInside;
    }

    public void setInside(boolean isInside) {
        this.isInside = isInside;
    }

    public boolean isUnderRoof() {
        return this.isUnderRoof;
    }

    public void setUnderRoof(boolean isUnderRoof) {
        this.isUnderRoof = isUnderRoof;
    }

    public TemperatureModifier.Cache getModifiers() {
        return this.modifiers;
    }

    public void update(Player player) {
        if (player instanceof ServerPlayer) {
            IPlayerInfo iPlayerInfo;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.setTemperature(this.getTemperature() + this.getTemperatureChange());
            this.setWetness(this.getWetness() + this.getWetnessChange());
            float envTemp = EnvironmentalTemperatureProvider.getEnvironmentTemperatureWithTimeOfDay(player);
            float COLD = ((Double)TFCAmbientalConfig.coolThreshold.get()).floatValue();
            float HOT = ((Double)TFCAmbientalConfig.hotThreshold.get()).floatValue();
            if (envTemp > HOT || envTemp < COLD) {
                if (this.durabilityTick <= 600) {
                    ++this.durabilityTick;
                } else {
                    this.durabilityTick = 0;
                    CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(c -> {
                        for (int i = 0; i < c.getSlots(); ++i) {
                            ItemStack stack = c.getStackInSlot(i);
                            if (!(stack.getItem() instanceof ClothesItem)) continue;
                            stack.setDamageValue(stack.getDamageValue() + 1);
                            if (stack.getDamageValue() <= stack.getMaxDamage()) continue;
                            stack.setCount(0);
                        }
                    });
                    player.getArmorSlots().forEach(stack -> {
                        if (stack.getItem() instanceof ClothesItem) {
                            stack.setDamageValue(stack.getDamageValue() + 1);
                            if (stack.getDamageValue() > stack.getMaxDamage()) {
                                stack.setCount(0);
                            }
                        }
                    });
                }
            }
            if (this.tick <= 20) {
                ++this.tick;
                return;
            }
            this.tick = 0;
            ++this.damageTick;
            this.evaluateModifiers(player);
            if (this.damageTick % 15 == 0) {
                if (this.getTemperature() > ((Double)TFCAmbientalConfig.burnThreshold.get()).floatValue()) {
                    player.hurt(new DamageSource((Holder)player.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(TFCAmbiental.HOT)), 1.0f);
                } else if (this.getTemperature() < ((Double)TFCAmbientalConfig.freezeThreshold.get()).floatValue()) {
                    player.hurt(new DamageSource((Holder)player.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(TFCAmbiental.FREEZE)), 1.0f);
                }
            }
            if (this.damageTick % 90 == 0 && (iPlayerInfo = IPlayerInfo.get((Player)player)) instanceof PlayerInfo) {
                PlayerInfo stats = (PlayerInfo)iPlayerInfo;
                if (this.getTemperature() > ((Double)TFCAmbientalConfig.hotThreshold.get()).floatValue()) {
                    stats.addThirst(-7.0f);
                } else if (this.getTemperature() < ((Double)TFCAmbientalConfig.coolThreshold.get()).floatValue()) {
                    stats.setFoodLevel(stats.getFoodLevel() - 1);
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)PlayerTemperaturePacket.from(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static PlayerTemperature read(CompoundTag compoundTag) {
        PlayerTemperature temperature = new PlayerTemperature();
        temperature.temperature = compoundTag.getFloat("temperature");
        temperature.target = compoundTag.getFloat("target");
        temperature.potency = compoundTag.getFloat("potency");
        temperature.targetWetness = compoundTag.getFloat("targetWetness");
        temperature.wetness = compoundTag.getFloat("wetness");
        temperature.isUnderRoof = compoundTag.getBoolean("isUnderRoof");
        temperature.isInside = compoundTag.getBoolean("isInside");
        return temperature;
    }

    @Nullable
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("temperature", this.getTemperature());
        tag.putFloat("target", this.target);
        tag.putFloat("potency", this.potency);
        tag.putFloat("targetWetness", this.targetWetness);
        tag.putFloat("wetness", this.wetness);
        tag.putBoolean("isUnderRoof", this.isUnderRoof);
        tag.putBoolean("isInside", this.isInside);
        return tag;
    }
}

