/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.data;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TemperatureModifier
implements Comparable<TemperatureModifier> {
    private String unlocalizedName;
    private float change;
    private float potency;
    private float wetness;
    private int count = 1;
    private float multiplier = 1.0f;

    public float getChange() {
        return this.change * this.multiplier;
    }

    public void setChange(float change) {
        this.change = change;
    }

    public float getPotency() {
        return this.potency * this.multiplier;
    }

    public void setPotency(float potency) {
        this.potency = potency;
    }

    public float getWetness() {
        return this.wetness;
    }

    public void setWetness(float wetness) {
        this.wetness = wetness;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public TemperatureModifier(String unlocalizedName) {
        this(unlocalizedName, 0.0f, 0.0f, 0.0f);
    }

    public TemperatureModifier(String unlocalizedName, float change, float potency) {
        this(unlocalizedName, change, potency, 0.0f);
    }

    public TemperatureModifier(String unlocalizedName, float change, float potency, float wetness) {
        this.unlocalizedName = unlocalizedName;
        this.change = change;
        this.potency = potency;
        this.wetness = wetness;
    }

    public static Optional<TemperatureModifier> defined(String unlocalizedName, float change, float potency) {
        return Optional.of(new TemperatureModifier(unlocalizedName, change, potency, 0.0f));
    }

    public static Optional<TemperatureModifier> defined(String unlocalizedName, float change, float potency, float wetness) {
        return Optional.of(new TemperatureModifier(unlocalizedName, change, potency, wetness));
    }

    public static Optional<TemperatureModifier> none() {
        return Optional.empty();
    }

    @Override
    public int compareTo(@NotNull TemperatureModifier o) {
        return Float.compare(Math.abs(this.change), Math.abs(o.change));
    }

    public static class Cache
    implements Iterable<TemperatureModifier> {
        private List<TemperatureModifier> list = new LinkedList<TemperatureModifier>();

        public Cache keepOnlyNEach(int n) {
            Map<String, List<TemperatureModifier>> grouped = this.list.stream().collect(Collectors.groupingBy(TemperatureModifier::getUnlocalizedName));
            this.list = grouped.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().sorted(Comparator.reverseOrder()).limit(n)).toList();
            return this;
        }

        public void add(TemperatureModifier value) {
            if (value == null) {
                return;
            }
            this.list.add(value);
        }

        public void add(Optional<TemperatureModifier> TemperatureModifier2) {
            TemperatureModifier2.ifPresent(mod -> this.list.add((TemperatureModifier)mod));
        }

        public float getTargetTemperature() {
            float change = 1.0f;
            for (TemperatureModifier mod : this.list) {
                change += mod.getChange();
            }
            return change;
        }

        public float getTotalPotency() {
            float potency = 1.1f;
            for (TemperatureModifier mod : this.list) {
                potency += mod.getPotency();
            }
            return potency;
        }

        public float getTargetWetness() {
            float wetness = 0.0f;
            for (TemperatureModifier mod : this.list) {
                wetness += mod.getWetness();
            }
            return wetness;
        }

        @Override
        public void forEach(Consumer<? super TemperatureModifier> func) {
            this.list.forEach(func);
        }

        @Override
        public Iterator<TemperatureModifier> iterator() {
            return this.list.iterator();
        }
    }
}

