/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfcambiental.item;

import com.lumintorious.tfcambiental.api.EquipmentTemperatureProvider;
import com.lumintorious.tfcambiental.data.TemperatureModifier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClothesMaterial {
    public static final DeferredRegister<ArmorMaterial> CLOTHES_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"tfcambiental");
    public static final Holder<ArmorMaterial> STRAW_MATERIAL = CLOTHES_MATERIALS.register("straw", () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.HELMET, 1);
        map.put(ArmorItem.Type.BODY, 4);
    }), 0, Holder.direct((Object)SoundEvents.CROP_BREAK), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"straw"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"straw"), "", false)), 1.0f, 0.0f));
    public static final Holder<ArmorMaterial> BURLAP_MATERIAL = CLOTHES_MATERIALS.register("burlap_cloth", () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.HELMET, 1);
        map.put(ArmorItem.Type.BODY, 4);
    }), 0, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"burlap_cloth"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"burlap_cloth"), "", false)), 1.0f, 0.0f));
    public static final Holder<ArmorMaterial> WOOL_MATERIAL = CLOTHES_MATERIALS.register("wool_cloth", () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.HELMET, 1);
        map.put(ArmorItem.Type.BODY, 4);
    }), 0, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"wool_cloth"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"wool_cloth"), "", false)), 1.0f, 0.0f));
    public static final Holder<ArmorMaterial> INSULATED_LEATHER = CLOTHES_MATERIALS.register("insulated_leather", () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.HELMET, 1);
        map.put(ArmorItem.Type.BODY, 4);
    }), 0, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"insulated_leather"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"insulated_leather"), "", false)), 1.0f, 0.0f));
    public static final Holder<ArmorMaterial> LEATHER_APRON_MATERIAL = CLOTHES_MATERIALS.register("leather_apron", () -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.HELMET, 1);
        map.put(ArmorItem.Type.BODY, 4);
    }), 0, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"leather_apron"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"tfcambiental", (String)"leather_apron"), "", false)), 1.0f, 0.0f));

    public static EquipmentTemperatureProvider temperatureOf(ArmorMaterial material) {
        Map<ArmorMaterial, EquipmentTemperatureProvider> mappings = Map.of((ArmorMaterial)BURLAP_MATERIAL.value(), (player, stack) -> Optional.of(new TemperatureModifier("clothes", -1.0f, -0.15f)), (ArmorMaterial)WOOL_MATERIAL.value(), (player, stack) -> Optional.of(new TemperatureModifier("clothes", 2.0f, -0.15f)), (ArmorMaterial)INSULATED_LEATHER.value(), (player, stack) -> Optional.of(new TemperatureModifier("clothes", 0.5f, -0.2f)), (ArmorMaterial)STRAW_MATERIAL.value(), (player, stack) -> Optional.of(new TemperatureModifier("clothes", -0.5f, -0.15f)), (ArmorMaterial)LEATHER_APRON_MATERIAL.value(), (player, stack) -> Optional.of(new TemperatureModifier("clothes", 0.0f, -0.1f)));
        return mappings.get(material);
    }
}

