/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.GUI.EscapeSettings;

import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CustomButton;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.EscapeSettings.EscapeMenu;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiRender;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.OnScreen.OnScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Model.ModelLoader;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Player.RenderPlayerCustom;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.InfoHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class SetInstance
extends GuiScreen {
    String message = null;
    long lastMessage = 0L;
    float displayScaleX = 1.0f;
    float displayScaleUpX = 1.0f;
    float displayScaleY = 1.0f;
    float displayScaleUpY = 1.0f;
    double guiX;
    double guiY;
    int guiWidth = 214;
    int guiHeight = 254;
    double barHeight = 13.0;
    double heightGap = this.barHeight + 2.0;
    double barWidth1 = this.barHeight;
    double barWidth2 = 150.0;
    double barWidth3 = 43.0;
    boolean isOnTestServer = false;
    boolean isTeleporting = false;
    int serverCount = 9;
    int serverCountReal = this.serverCount - 3;
    int serverSelected = -1;
    int lowestPingServer = -1;
    int lowestPingRegion = -1;
    long[] serverPing = new long[this.serverCount];
    long lowestPing = 999L;
    String[] defaultServerTag = new String[]{"us1", "us2", "us3", "eu1", "eu2", "au1"};
    String[] serverCategories = new String[]{"United States", "Europe", "Oceanic", "Other"};
    int[][] serverRegionInstance = new int[][]{{0, 3, 5, 6}, {2, 4, 5, this.serverCount - 1}};
    public static IModelCustom globe = ModelLoader.loadModel(new ResourceLocation("dbapollo:models/globe.obj"));
    double[][] instanceGlobe = new double[][]{{2.0, 27.0}, {27.0, 21.0}, {45.0, 30.0}, {257.0, 35.0}, {280.0, 40.0}, {112.0, -40.0}};
    double globeYaw = 0.0;
    double globePitch = 0.0;
    double beforeYaw = -1.0;
    double beforePitch = -1.0;
    double instanceZoom = 0.0;
    double teleportGlow = 0.0;
    boolean teleportGlowDirection = false;

    public void func_73866_w_() {
        super.func_73866_w_();
        float scaleFactor = 2.0f;
        this.displayScaleX = OnScreen.getScreenScaleWidth(scaleFactor);
        this.displayScaleUpX = (float)Math.pow(this.displayScaleX, -1.0);
        this.displayScaleY = OnScreen.getScreenScaleHeight(scaleFactor);
        this.displayScaleUpY = (float)Math.pow(this.displayScaleY, -1.0);
        this.guiX = ((float)this.field_146294_l * this.displayScaleUpX - (float)this.guiWidth) / 2.0f;
        this.guiY = ((float)this.field_146295_m * this.displayScaleUpY - (float)this.guiHeight) / 2.0f;
        if (ClientUtils.checkOnTestServer()) {
            this.isOnTestServer = true;
        }
        double width = this.guiWidth;
        double height = 24.0 + (double)(this.serverCount - (!this.isOnTestServer ? 1 : 0) + this.serverCategories.length) * this.heightGap + 21.0;
        double buttonWidth = 35.0;
        double buttonHeight = 12.0;
        this.field_146292_n.add(new CustomButton(-3, this.guiX, this.guiY - buttonHeight - 2.0, 0, 0, buttonWidth, buttonHeight, "dbapollo:textures/misc/blank.png", this, 1.0f));
        if (!ClientUtils.checkInHub()) {
            buttonWidth = 55.0;
            this.field_146292_n.add(new CustomButton(-2, this.guiX + (double)this.guiWidth - buttonWidth, this.guiY - buttonHeight - 2.0, 0, 0, buttonWidth, buttonHeight, "dbapollo:textures/misc/blank.png", this, 1.0f));
        }
        buttonWidth = 80.0;
        buttonHeight = 12.0;
        this.field_146292_n.add(new CustomButton(-1, this.guiX + width / 2.0 - buttonWidth / 2.0, this.guiY + height - buttonHeight - 5.0, 0, 0, buttonWidth, buttonHeight, "dbapollo:textures/misc/blank.png", this, 1.0f));
        for (int server = 0; server < this.serverCount && (server != this.serverCount - 1 || this.isOnTestServer); ++server) {
            int region = this.getInstanceRegion(server);
            double posX = this.guiX + 3.0;
            double posY = this.guiY + 24.0 + (double)(server + (region + 1)) * (this.barHeight + 2.0);
            this.field_146292_n.add(new CustomButton(server, posX + 1.0, posY + 1.0, 0, 0, this.barHeight + this.barWidth2, this.barHeight - 2.0, "dbapollo:textures/misc/blank.png", this, 1.0f));
        }
        BridgePD.tellServer((String)"stat:setInstance");
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -3) {
            Main.mc.func_147108_a((GuiScreen)new EscapeMenu(true));
        } else if (button.field_146127_k == -2 && !ClientUtils.checkInHub()) {
            BridgePD.tellServer((int)998);
        } else if (button.field_146127_k == -1) {
            this.teleportToServer();
        } else {
            this.selectServer(button.field_146127_k);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        String hoverText;
        this.func_146276_q_();
        GL11.glPushMatrix();
        GL11.glScalef((float)this.displayScaleX, (float)this.displayScaleY, (float)1.0f);
        this.drawGlobe(this.guiX + (double)(this.guiWidth / 2), this.guiY + 10.0, 150.0, 60.0, this.globeYaw, this.globePitch);
        double width = this.guiWidth;
        double height = 25.0 + (double)(this.serverCount - (!this.isOnTestServer ? 1 : 0) + this.serverCategories.length) * this.heightGap + 21.0;
        RenderUtils.drawRectangleDouble(this.guiX, this.guiY, width, height, 0, 0.25);
        String text = EnumChatFormatting.YELLOW + "Select Your Server Instance";
        RenderUtils.drawBasicText(Main.mc, text, this.guiX + (double)(this.guiWidth / 2), this.guiY + 11.0, false, 1);
        double buttonWidth = 35.0;
        double buttonHeight = 12.0;
        RenderUtils.drawRectangleDouble(this.guiX, this.guiY - buttonHeight - 2.0, buttonWidth, buttonHeight, 0, 0.25);
        text = EnumChatFormatting.GRAY + "Return";
        RenderUtils.drawScaledText(Main.mc, text, 0.8, this.guiX + 4.0, this.guiY - buttonHeight + 2.0, false, 0);
        if (!ClientUtils.checkInHub()) {
            buttonWidth = 55.0;
            RenderUtils.drawRectangleDouble(this.guiX + (double)this.guiWidth - buttonWidth, this.guiY - buttonHeight - 2.0, buttonWidth, buttonHeight, 0, 0.25);
            text = EnumChatFormatting.GRAY + "Global Chest";
            RenderUtils.drawScaledText(Main.mc, text, 0.8, this.guiX + (double)this.guiWidth - buttonWidth + 4.0, this.guiY - buttonHeight + 2.0, false, 0);
        }
        for (int server = 0; server < this.serverCount && (server != this.serverCount - 1 || this.isOnTestServer); ++server) {
            long ping;
            int region = this.getInstanceRegion(server);
            double posX = this.guiX + 3.0;
            double posY = this.guiY + 24.0 + (double)(server + (region + 1)) * this.heightGap;
            boolean isSelected = server == this.serverSelected;
            boolean isLowestPing = this.lowestPingServer == server;
            boolean isWild = server == this.serverCount - 3;
            boolean isHub = server == this.serverCount - 2;
            boolean isTest = server == this.serverCount - 1;
            EnumChatFormatting serverColor = isSelected ? EnumChatFormatting.YELLOW : EnumChatFormatting.GRAY;
            String serverName = serverColor + (isWild ? (this.isOnTestServer ? "Test " : "") + "Wild / Factions (New York, US)" : (isHub ? (this.isOnTestServer ? "Test " : "") + "Hub (New York, US)" : (isTest ? "Test Server (New York, US)" : (server < 6 && InfoHandler.servers.size() >= server + 3 ? (String)InfoHandler.servers.get(server + 3)[0] : "Instance #" + (server + 1)))));
            if (server == 4 || server == 5) {
                serverName = serverName + EnumChatFormatting.GREEN + " (New, 2024)";
            }
            this.serverPing[server] = ping = ClientUtils.getPing(isWild || isHub || isTest ? 0 : server);
            int pingColorInt = ClientUtils.colorPingInt(ping);
            int color = 0;
            int pingColor = this.pingColor(ping, pingColorInt, isLowestPing);
            double alpha = 0.4;
            double pingAlpha = 0.6;
            if (server == this.serverRegionInstance[0][region]) {
                text = EnumChatFormatting.WHITE + "" + EnumChatFormatting.UNDERLINE + this.serverCategories[region];
                double offset = (double)this.field_146289_q.func_78256_a(text) * 0.8;
                RenderUtils.drawRectangleDouble(posX, posY - 11.0, offset + 4.0, this.barHeight - 3.0, color, alpha);
                RenderUtils.drawScaledText(Main.mc, text, 0.8, posX + 3.0, posY - 9.0, false, 0);
                if (this.lowestPingRegion == region) {
                    text = EnumChatFormatting.GRAY + "Recommended Region";
                    RenderUtils.drawScaledText(Main.mc, text, 0.6, posX + offset + 8.0, posY - 7.0, true, 0);
                }
            }
            RenderUtils.drawRectangleDouble(posX, posY, this.barHeight, this.barHeight, color, alpha);
            RenderUtils.drawRectangle(posX + 1.0, posY + 1.0, this.barHeight - 2.0, this.barHeight - 2.0, isSelected ? 0xFFFF00 : 0xFFFFFF, isSelected ? 0.8 : 0.3);
            if (isSelected) {
                RenderUtils.drawRectangle(posX + 4.0, posY + 4.0, this.barHeight - 8.0, this.barHeight - 8.0, color, 0.85);
            }
            hoverText = (isSelected ? EnumChatFormatting.YELLOW + "Click to Teleport to " : "Click to Select ") + serverName;
            RenderUtils.drawDetails(this.field_146297_k.field_71466_p, "", hoverText, posX + 4.0, posY + 4.0, mouseX, mouseY, this.barHeight + this.barWidth2, this.barHeight - 2.0, this.displayScaleX);
            RenderUtils.drawRectangle(posX += this.barHeight + 1.0, posY, this.barWidth2, this.barHeight, color, alpha);
            RenderUtils.drawGradient(posX, posY + this.barHeight - 1.0, this.barWidth2, 1.0, pingColor, 0x404040, pingAlpha);
            text = (GuiRender.serverName.equals(serverName) ? EnumChatFormatting.YELLOW : EnumChatFormatting.AQUA) + serverName;
            RenderUtils.drawScaledText(Main.mc, text, 0.7, posX + 3.0, posY + 4.0, false, 0);
            RenderUtils.drawRectangleDouble(posX += this.barWidth2 + 1.0, posY, this.barWidth3, this.barHeight, color, alpha);
            RenderUtils.drawGradient(posX, posY + this.barHeight - 1.0, this.barWidth3, 1.0, pingColor, 0x404040, pingAlpha, false, true);
            text = EnumChatFormatting.GRAY + "Ping: " + (ping != -1L ? ClientUtils.colorPing(ping, isLowestPing ? 0 : pingColorInt) : EnumChatFormatting.DARK_GRAY + "N/A");
            RenderUtils.drawScaledText(Main.mc, text, 0.7, posX + 3.0, posY + 4.0, false, 0);
            hoverText = "Ping is your connection latency to a given Server Instance";
            RenderUtils.drawDetails(this.field_146297_k.field_71466_p, "", hoverText, posX + 3.0, posY + 3.0, mouseX, mouseY, this.barWidth3, this.barHeight, this.displayScaleX);
            if (!isLowestPing) continue;
            text = EnumChatFormatting.GRAY + "Recommended Instance";
            RenderUtils.drawScaledText(Main.mc, text, 0.6, posX += this.barWidth3 + 7.0, posY + 5.0, true, 0);
        }
        hoverText = this.serverSelected != -1 ? EnumChatFormatting.GREEN + "Click to Teleport to your Selected Server!" : "Select a Server above to Teleport";
        buttonWidth = 80.0;
        buttonHeight = 12.0;
        RenderUtils.drawRectangleDouble(this.guiX + width / 2.0 - buttonWidth / 2.0, this.guiY + height - buttonHeight - 6.0, buttonWidth, buttonHeight, 0, 0.4);
        RenderUtils.drawDetails(this.field_146297_k.field_71466_p, "", hoverText, this.guiX + width / 2.0 - buttonWidth / 2.0 + 3.0, this.guiY + height - buttonHeight - 3.0, mouseX, mouseY, buttonWidth, buttonHeight, this.displayScaleX);
        text = this.serverSelected != -1 ? EnumChatFormatting.GREEN + "Teleport" : EnumChatFormatting.GRAY + "Teleport";
        RenderUtils.drawScaledText(Main.mc, text, 0.8, this.guiX + width / 2.0, this.guiY + height - buttonHeight - 2.0, false, 1);
        float timeSince = ClientUtils.getTimeSince(this.lastMessage);
        float duration = 5000.0f;
        if (this.message != null && timeSince <= duration) {
            text = EnumChatFormatting.RED + "Error: " + EnumChatFormatting.GRAY + this.message;
            RenderUtils.drawDurationMessage(this.field_146297_k, text, 0.7f, this.guiX + width / 2.0, this.guiY + height + 5.0, duration, timeSince, 70);
        }
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, ticks);
        ClientUtils.drawInfoDisplay(Main.mc.field_71466_p, "inMenu");
        RenderUtils.renderDetails(mouseX, mouseY, this.field_146289_q);
    }

    public void func_73876_c() {
        boolean debug = false;
        for (int server = 0; server < this.serverCountReal; ++server) {
            int region = this.getInstanceRegion(server);
            long ping = ClientUtils.getPing(server);
            if (ping == -1L || ping >= this.lowestPing && this.lowestPing != 0L) continue;
            this.lowestPing = ping;
            this.lowestPingServer = server;
            this.lowestPingRegion = region;
        }
        if (this.serverSelected != -1) {
            int selected = this.serverSelected >= this.serverCountReal ? 0 : this.serverSelected;
            double targetYaw = this.instanceGlobe[selected][0];
            double targetPitch = this.instanceGlobe[selected][1];
            if (this.teleportGlow >= 1.0 || this.teleportGlow <= 0.0) {
                boolean bl = this.teleportGlowDirection = !this.teleportGlowDirection;
            }
            if (!this.teleportGlowDirection) {
                this.teleportGlow += 0.15;
                this.teleportGlow = Math.min(1.0, this.teleportGlow);
            } else {
                this.teleportGlow -= 0.15;
                this.teleportGlow = Math.max(0.0, this.teleportGlow);
            }
            if (debug) {
                System.out.println("teleportGlow: " + this.teleportGlow + " (" + this.teleportGlowDirection + ")");
            }
            if (this.globeYaw != targetYaw || this.globePitch != targetPitch) {
                if (debug) {
                    System.out.println("target: " + targetYaw + "_" + targetPitch);
                }
                this.globeYaw = SetInstance.doGlobeRotation(this.globeYaw, targetYaw, 0, false);
                this.globePitch = SetInstance.doGlobeRotation(this.globePitch, targetPitch, 1, false);
                if (debug) {
                    System.out.println("globe: " + this.globeYaw + "_" + this.globePitch);
                }
            }
            if (this.instanceZoom < 1.0) {
                this.instanceZoom += 0.05;
                this.instanceZoom = Math.min(1.0, this.instanceZoom);
                if (debug) {
                    System.out.println("zoomIn: " + this.instanceZoom);
                }
            } else {
                this.instanceZoom = 1.0;
            }
        } else {
            if (this.beforeYaw != -1.0 || this.beforePitch != -1.0) {
                if (debug) {
                    System.out.println("before: " + this.beforeYaw + "_" + this.beforePitch);
                }
                if (this.beforeYaw != -1.0) {
                    this.globeYaw = SetInstance.doGlobeRotation(this.globeYaw, this.beforeYaw, 0, true);
                }
                if (this.beforePitch != -1.0) {
                    this.globePitch = SetInstance.doGlobeRotation(this.globePitch, this.beforePitch, 1, true);
                }
                if (debug) {
                    System.out.println("globe: " + this.globeYaw + "_" + this.globePitch);
                }
                if (this.beforeYaw == this.globeYaw) {
                    this.beforeYaw = -1.0;
                }
                if (this.beforePitch == this.globePitch) {
                    this.beforePitch = -1.0;
                }
            }
            this.globeYaw -= 0.75;
            if (this.instanceZoom > 0.0) {
                this.instanceZoom -= 0.08;
                this.instanceZoom = Math.max(0.0, this.instanceZoom);
                if (debug) {
                    System.out.println("zoomOut: " + this.instanceZoom);
                }
            } else {
                this.instanceZoom = 0.0;
            }
        }
        if (this.globeYaw < 0.0) {
            this.globeYaw += 360.0;
        }
        if (this.globeYaw > 360.0) {
            this.globeYaw -= 360.0;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    void setMessage(String message) {
        this.message = message;
        this.lastMessage = System.currentTimeMillis();
    }

    void selectServer(int selected) {
        boolean doubleClick = this.serverSelected == selected;
        this.serverSelected = selected;
        if (doubleClick) {
            this.teleportToServer();
            this.isTeleporting = true;
        } else {
            this.isTeleporting = false;
            this.beforePitch = 0.0;
        }
        if (!this.isTeleporting) {
            this.cancelTeleport();
        }
    }

    void teleportToServer() {
        if (this.serverSelected != -1) {
            String serverTag;
            boolean isTest;
            int server = this.serverSelected;
            boolean isWild = server == this.serverCount - 3;
            boolean isHub = server == this.serverCount - 2;
            boolean bl = isTest = server == this.serverCount - 1;
            String string = isWild ? (this.isOnTestServer ? "wildtest" : "wild") : (isHub ? (this.isOnTestServer ? "hubtest" : "hub") : (isTest ? "testserver" : (serverTag = server < 6 && InfoHandler.servers.size() >= server + 3 ? (String)InfoHandler.servers.get(server + 3)[1] : this.defaultServerTag[server])));
            if (isWild) {
                this.setMessage("The Migrated Wild Instance will be added in an upcoming Patch!");
                return;
            }
            if (GuiRender.serverName.contains("#" + (server + 1)) || server < 6 && this.isOnTestServer) {
                this.setMessage(this.isOnTestServer ? "This server \"" + serverTag + "\" doesn't exist" : "You are already on " + serverTag.toUpperCase());
                return;
            }
            SetInstance.teleportToServer(serverTag);
            Main.mc.func_147108_a(null);
        } else {
            this.setMessage("You must select a Server from the list first!");
        }
    }

    public static void teleportToServer(String serverTag) {
        Main.mc.field_71439_g.func_71165_d("/server " + serverTag);
    }

    void cancelTeleport() {
        this.teleportGlow = 0.0;
    }

    int getInstanceRegion(int instance) {
        return instance <= this.serverRegionInstance[1][0] ? 0 : (instance <= this.serverRegionInstance[1][1] ? 1 : (instance <= this.serverRegionInstance[1][2] ? 2 : 3));
    }

    void drawGlobe(double posX, double posY, double posZ, double scale, double yaw, double pitch) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)posZ);
        GL11.glTranslated((double)0.0, (double)(30.0 * this.instanceZoom), (double)0.0);
        GL11.glScaled((double)(-(scale *= 1.0 + this.instanceZoom / 2.0)), (double)scale, (double)scale);
        RenderPlayerCustom.OBJRender((EntityLivingBase)Main.mc.field_71439_g, globe, "Globe", "dbapollo:models/globe.png", 0xFFFFFF, 1.0f, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, (float)pitch, (float)yaw, 0.0);
        int selected = this.serverSelected >= this.serverCountReal ? 0 : this.serverSelected;
        for (int server = 0; server < this.serverCount; ++server) {
            boolean isSelected = server == this.serverSelected;
            boolean isLowestPing = this.lowestPingServer == server;
            long ping = this.serverPing[server];
            int pingColorInt = ClientUtils.colorPingInt(ping);
            int pingColor = this.pingColor(ping, pingColorInt, isLowestPing);
            RenderPlayerCustom.OBJRender((EntityLivingBase)Main.mc.field_71439_g, globe, "Instance" + (server + 1), "dbapollo:textures/character/02_00_hair/allw.png", isSelected ? 0xFFFF00 : pingColor, 1.0f, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, (float)pitch, (float)yaw, 0.0);
            if (!isSelected) continue;
            RenderPlayerCustom.OBJRender((EntityLivingBase)Main.mc.field_71439_g, globe, "Instance" + (server + 1), "dbapollo:textures/character/02_00_hair/allw.png", 0xFFFFFF, (float)this.teleportGlow, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, (float)pitch, (float)yaw, 0.0);
        }
        GL11.glPopMatrix();
    }

    static double doGlobeRotation(double current, double target, int type, boolean returning) {
        double minMove;
        double currentRotation = current;
        double slowFactor = type == 0 ? 13.0 : 15.0;
        double d = minMove = type == 0 ? 1.2 : 1.0;
        if (returning) {
            slowFactor /= 2.0;
            minMove *= 2.0;
        }
        if (current != target) {
            double difference = current - target;
            if (difference > 180.0) {
                difference -= 360.0;
            }
            if (difference < -180.0) {
                difference += 360.0;
            }
            boolean direction = difference < 0.0;
            double change = direction ? Math.min(-minMove, difference / slowFactor) : Math.max(minMove, difference / slowFactor);
            currentRotation = direction && difference >= change || !direction && difference < change ? target : current - change;
        }
        return currentRotation;
    }

    int pingColor(long ping, int pingColorInt, boolean isLowestPing) {
        return ping == -1L ? 0xAAAAAA : ClientUtils.pingColorCodes[isLowestPing ? 0 : pingColorInt];
    }
}

