/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Render.Sky;

import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiRender;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Sky.CustomSkyLayer;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Sky.SkyRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class CustomSky {
    private final Minecraft mc = Minecraft.func_71410_x();
    public CustomSkyLayer dawnLayer = null;
    public CustomSkyLayer dayLayer = null;
    public CustomSkyLayer duskLayer = null;
    public CustomSkyLayer nightLayer = null;
    private long worldTime;
    private int skyboxSize;
    public static CustomSky currentSky = null;
    public static String skyName = null;
    public static boolean debugSky = false;
    public static boolean forceSky = false;
    static IRenderHandler defaultSky = null;
    static IRenderHandler customSky = null;
    static String[] skyNames = new String[]{"htc"};
    static int[][][] skyCords = new int[][][]{new int[][]{{8000, 5000}, {8000, 4500}, {8000, 4000}, {8000, 3500}, {12500, 12000}, {14000, 12000}, {14000, 12500}, {14000, 13000}, {14000, 12500}}};
    public static long time = 0L;
    public static long timeFactor = 0L;

    public void renderSky() {
        if (skyName != null) {
            if (debugSky) {
                System.out.println("renderSky: " + skyName);
            }
            this.worldTime = this.mc.field_71441_e.func_72820_D() % 24000L;
            this.skyboxSize = this.mc.field_71474_y.field_151451_c * 16;
            if (skyName.equalsIgnoreCase("default")) {
                this.renderLayersOfTime(this.dawnLayer, 0L, 1000L);
                this.renderLayersOfTime(this.dayLayer, 1000L, 12000L);
                this.renderLayersOfTime(this.duskLayer, 12000L, 13000L);
                this.renderLayersOfTime(this.nightLayer, 13000L, 24000L);
            } else {
                this.renderLayersOfTime(this.dayLayer, 0L, 1000L);
                this.renderLayersOfTime(this.dayLayer, 1000L, 12000L);
                this.renderLayersOfTime(this.dayLayer, 12000L, 13000L);
                this.renderLayersOfTime(this.dayLayer, 13000L, 24000L);
            }
        }
    }

    private void renderLayersOfTime(CustomSkyLayer layer, long thisTime, long nextTime) {
        float alpha = 0.0f;
        if (this.ticksUntil(this.worldTime, thisTime) > 12000L) {
            if (this.ticksUntil(this.worldTime, nextTime) < 12000L) {
                alpha = 1.0f;
            } else if (this.ticksSince(this.worldTime, nextTime) < 200L) {
                alpha = 1.0f - (float)this.ticksSince(this.worldTime, nextTime) / 200.0f;
            }
        } else if (this.ticksUntil(this.worldTime, thisTime) < 200L) {
            alpha = 1.0f - (float)this.ticksUntil(this.worldTime, thisTime) / 200.0f;
        }
        if (alpha != 0.0f) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            layer.renderLayer(this.skyboxSize);
        }
    }

    private long ticksUntil(long now, long next) {
        if (now > next) {
            return next + 24000L - now;
        }
        return next - now;
    }

    private long ticksSince(long now, long last) {
        if (now > last) {
            return now - last;
        }
        return 24000L + now - last;
    }

    public static void setCustomSky() {
        if (GuiRender.worldName.equals("Conton") && currentSky != null && Main.mc.field_71441_e.field_73011_w.getSkyRenderer() == null) {
            if (debugSky) {
                System.out.println("Setting Sky to Custom");
            }
            customSky = new SkyRenderer();
            defaultSky = Main.mc.field_71441_e.field_73011_w.getSkyRenderer();
            Main.mc.field_71441_e.field_73011_w.setSkyRenderer(customSky);
        }
        if (!(GuiRender.worldName.equals("Conton") && currentSky != null || customSky == null)) {
            if (debugSky) {
                System.out.println("Setting Sky back to default");
            }
            customSky = null;
            skyName = null;
            Main.mc.field_71441_e.field_73011_w.setSkyRenderer(defaultSky);
        }
    }

    public static void checkCustomSky(EntityPlayer player) {
        if (player.func_70005_c_().equalsIgnoreCase("XeroZon") && timeFactor > 0L) {
            Main.mc.field_71441_e.func_72877_b(time += timeFactor);
        }
        if (forceSky) {
            CustomSkyLayer.loadSky("example");
            return;
        }
        for (int i = 0; i < skyCords.length; ++i) {
            String skyName = skyNames[i];
            for (int j = 0; j < skyCords[i].length; ++j) {
                int x = skyCords[i][j][0];
                int z = skyCords[i][j][1];
                int x1 = x - 250;
                int x2 = x + 250;
                int z1 = z - 250;
                int z2 = z + 250;
                if (!(player.field_70165_t >= (double)x1) || !(player.field_70165_t <= (double)x2) || !(player.field_70161_v >= (double)z1) || !(player.field_70161_v <= (double)z2)) continue;
                CustomSkyLayer.loadSky(skyName);
                return;
            }
        }
        CustomSkyLayer.loadSky(null);
    }
}

