/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Render.Sky;

import net.MCApolloNetwork.ApolloCrux.Client.Render.Sky.CustomSky;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CustomSkyLayer {
    public final ResourceLocation resourceLocation;

    public CustomSkyLayer(String layerName) {
        this.resourceLocation = new ResourceLocation("dbapollo:textures/sky/" + layerName + ".jpg");
    }

    public void renderLayer(int size) {
        if (CustomSky.debugSky) {
            System.out.println("renderLayer: " + this.resourceLocation.func_110623_a());
        }
        RenderUtils.bindTexture(this.resourceLocation);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 4, size);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderSide(tess, 1, size);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderSide(tess, 0, size);
        GL11.glPopMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 5, size);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 2, size);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 3, size);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void renderSide(Tessellator tess, int side, int size) {
        double u = (double)(side % 3) / 3.0;
        double v = (double)(side / 3) / 2.0;
        tess.func_78382_b();
        tess.func_78374_a((double)(-size), (double)(-size), (double)(-size), u, v);
        tess.func_78374_a((double)(-size), (double)(-size), (double)size, u, v + 0.5);
        tess.func_78374_a((double)size, (double)(-size), (double)size, u + 0.3333333333333333, v + 0.5);
        tess.func_78374_a((double)size, (double)(-size), (double)(-size), u + 0.3333333333333333, v);
        tess.func_78381_a();
    }

    public static void loadDefaultSky() {
        CustomSky customSky = new CustomSky();
        customSky.dawnLayer = new CustomSkyLayer("dawn");
        customSky.dayLayer = new CustomSkyLayer("day");
        customSky.duskLayer = new CustomSkyLayer("dusk");
        customSky.nightLayer = new CustomSkyLayer("night");
        CustomSky.currentSky = customSky;
        CustomSky.skyName = "default";
    }

    public static void loadSky(String skyName) {
        if (CustomSky.skyName == null || !CustomSky.skyName.equalsIgnoreCase(skyName)) {
            if (CustomSky.debugSky) {
                System.out.println("Attempting to loadSky: \"" + skyName + "\"");
            }
            if (skyName != null) {
                if (CustomSky.debugSky) {
                    System.out.println("set LoadSky: " + skyName);
                }
                CustomSky customSky = new CustomSky();
                customSky.dayLayer = new CustomSkyLayer(skyName);
                CustomSky.currentSky = customSky;
                CustomSky.skyName = skyName;
            } else {
                CustomSky.currentSky = null;
                CustomSky.skyName = null;
            }
            CustomSky.setCustomSky();
        }
    }
}

