/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Events.ClientHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Body;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class AnimationUtils {
    public static String[] animationIdentifiers = new String[]{"player", "tail"};
    public static HashMap<String, Object[]> currentAnimations = new HashMap();
    static String nuanceAnimation = null;
    static boolean doRotations = true;
    static boolean doPositions = true;
    static boolean doScale = true;
    public static boolean cancelAnimation;
    static String animationPath;
    static String animationInputPath;
    static String currentPart;
    static String currentType;
    static ArrayList<double[]> animationRotation;
    static ArrayList<double[]> animationPositions;
    static ArrayList<double[]> animationScaling;
    public static HashMap<String, HashMap<String, ArrayList<double[]>>> keyFrameRotations;
    public static HashMap<String, HashMap<String, ArrayList<double[]>>> keyFramePositions;
    public static HashMap<String, HashMap<String, ArrayList<double[]>>> keyFrameScaling;
    public static HashMap<String, HashMap<String, ArrayList<int[]>>> keyFrameList;

    static void initializeAnimations() {
        if (currentAnimations.isEmpty()) {
            for (String identifier : animationIdentifiers) {
                Object[] defaultEntry = new Object[]{true, null, 0.0, 2.0, 1.0, true, 0, 0.0};
                currentAnimations.put(identifier, defaultEntry);
            }
        }
    }

    static void setAnimationPlaying(String identifier, boolean input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[0] = input;
    }

    public static boolean getAnimationPlaying(String identifier) {
        return (Boolean)currentAnimations.get(identifier)[0];
    }

    static void setAnimationName(String identifier, String input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[1] = input;
    }

    public static String getAnimationName(String identifier) {
        return (String)currentAnimations.get(identifier)[1];
    }

    static void setAnimationLength(String identifier, double input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[2] = input;
    }

    public static double getAnimationLength(String identifier) {
        return (Double)currentAnimations.get(identifier)[2];
    }

    static void setAnimationSpeed(String identifier, double input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[3] = input;
    }

    public static double getAnimationSpeed(String identifier) {
        return (Double)currentAnimations.get(identifier)[3];
    }

    static void setAnimationSpeedPretty(String identifier, double input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[4] = input;
    }

    public static double getAnimationSpeedPretty(String identifier) {
        return (Double)currentAnimations.get(identifier)[4];
    }

    static void setAnimationDoesLoop(String identifier, boolean input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[5] = input;
    }

    public static boolean getAnimationDoesLoop(String identifier) {
        return (Boolean)currentAnimations.get(identifier)[5];
    }

    static void setAnimationProgress(String identifier, int input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[6] = input;
    }

    public static int getAnimationProgress(String identifier) {
        return (Integer)currentAnimations.get(identifier)[6];
    }

    static void setAnimationTimeLimit(String identifier, double input) {
        AnimationUtils.currentAnimations.get((Object)identifier)[7] = input;
    }

    public static double getAnimationTimeLimit(String identifier) {
        return (Double)currentAnimations.get(identifier)[7];
    }

    public static void animationTick(EntityPlayer player) {
        if (!Body.isEnabled) {
            return;
        }
        boolean debug = false;
        AnimationUtils.initializeAnimations();
        double speedForward = player.field_70701_bs;
        double speedSideways = player.field_70702_br;
        double speedVertical = player.field_70181_x;
        if (speedForward < 0.0) {
            speedForward *= -1.0;
        }
        boolean isMoving = speedForward > 0.0;
        boolean isStrafing = ClientUtils.getTimeSince(ClientHandler.dodge_recently) <= 150L;
        boolean isInAir = !player.field_70122_E;
        boolean isIdle = false;
        boolean isAscending = speedVertical > 0.1;
        boolean isDescending = speedVertical < -0.1;
        boolean dynamicFlight = ClientHandler.dodge_forwDash_STE;
        boolean isJumping = isAscending && !dynamicFlight;
        boolean isFalling = isDescending && !dynamicFlight;
        boolean isFloating = isInAir && ClientHandler.floating && !isFalling && !isJumping;
        boolean isFlying = isFloating && isMoving;
        boolean isWalking = isMoving && !isInAir;
        boolean isRunning = isMoving && player.func_70051_ag() && !isFlying && !isFalling;
        boolean isCrouching = player.func_70093_af();
        String playerAnimation = null;
        String tailAnimation = null;
        double playerSpeed = 1.0;
        double tailSpeed = 1.0;
        if (isMoving) {
            playerAnimation = "walking";
            double runningSpeed = BridgeUtils.getMovementSpeedClient((int)0)[0].floatValue();
            playerSpeed = speedForward;
            playerSpeed *= runningSpeed * 1.0;
            tailAnimation = "tail_walking";
            tailSpeed = 1.0;
            if (isRunning) {
                playerAnimation = "running";
                playerSpeed *= 0.9;
            }
        }
        if (isJumping) {
            playerAnimation = "jumping";
            playerSpeed = speedVertical;
        }
        if (isFalling) {
            playerAnimation = isMoving ? (AnimationUtils.isCloseToGround(player) ? "jumping" : "falling_death") : "falling_style";
            playerSpeed = speedVertical * -1.0;
        }
        if (isFloating) {
            playerAnimation = "floating";
            playerSpeed = 1.0;
            if (speedSideways > 0.0 || isStrafing) {
                playerAnimation = "strafe_sideways";
            }
        }
        if (isFlying) {
            playerAnimation = "flying";
            playerSpeed = speedForward;
            playerSpeed = 1.0;
        }
        if (isStrafing) {
            playerAnimation = ClientHandler.dodge_last == 3 ? "strafe_back" : "strafe_sideways";
            playerSpeed = 1.0;
        }
        if (playerAnimation == null) {
            playerAnimation = "idle";
            playerSpeed = 1.0;
            tailAnimation = "tail_idle";
            tailSpeed = 1.0;
            isIdle = true;
        }
        nuanceAnimation = "idle: " + isIdle + " | walk: " + isWalking + " | run: " + isRunning + " | float: " + isFloating + " | fly: " + isFlying + " | strafe: " + isStrafing + " | jump: " + isJumping + " | fall: " + isFalling + " | crouch: " + isCrouching;
        AnimationUtils.loadAnimation("player", playerAnimation, playerSpeed);
        AnimationUtils.loadAnimation("tail", tailAnimation, tailSpeed);
        AnimationUtils.animationProgress();
        AnimationUtils.animationProgress();
    }

    static boolean isCloseToGround(EntityPlayer player) {
        int distanceLimit = 4;
        boolean closeToGround = false;
        for (int l = 0; l <= distanceLimit; ++l) {
            WorldClient world = Main.mc.field_71441_e;
            int blockY = (int)(player.field_70163_u - (double)l);
            Block block = world.func_147439_a((int)player.field_70165_t, blockY, (int)player.field_70161_v);
            if (block == null || block.func_149739_a().equalsIgnoreCase("tile.air")) continue;
            closeToGround = true;
            break;
        }
        return closeToGround;
    }

    public static void animationProgress() {
        for (String identifier : animationIdentifiers) {
            boolean animationPlaying = AnimationUtils.getAnimationPlaying(identifier);
            double animationLength = AnimationUtils.getAnimationLength(identifier);
            double animationSpeed = AnimationUtils.getAnimationSpeed(identifier);
            if (!animationPlaying || animationLength == 0.0) {
                return;
            }
            AnimationUtils.setAnimationTimeLimit(identifier, animationLength * animationSpeed);
            int animationProgress = AnimationUtils.getAnimationProgress(identifier);
            double animationTimeLimit = AnimationUtils.getAnimationTimeLimit(identifier);
            AnimationUtils.setAnimationProgress(identifier, ++animationProgress);
            if (!((double)animationProgress > animationTimeLimit)) continue;
            AnimationUtils.setAnimationProgress(identifier, 0);
            for (int limbNum = 0; limbNum < keyFrameList.get(identifier).size(); ++limbNum) {
                Object[][] modelParts = AnimationUtils.getIdentifierParts(identifier);
                String modelPart = (String)modelParts[limbNum][0];
                ArrayList<int[]> keyFrameArray = new ArrayList<int[]>((Collection)keyFrameList.get(identifier).get(modelPart));
                for (int type = 0; type < keyFrameArray.size(); ++type) {
                    int keyFrame = ((int[])keyFrameArray.get(type))[0];
                    int keyFrameLimit = keyFrameArray.get(type)[1];
                    if (++keyFrame >= keyFrameLimit) {
                        keyFrame = 0;
                    }
                    keyFrameArray.set(type, new int[]{keyFrame, keyFrameLimit});
                }
                keyFrameList.put(identifier, AnimationUtils.parseHashHashHash2(identifier, modelPart, 3, keyFrameArray));
            }
        }
    }

    public static void drawAnimationDetails(Minecraft mc) {
        if (currentAnimations.get("player") == null || !Body.isEnabled) {
            return;
        }
        for (int num = 0; num < animationIdentifiers.length; ++num) {
            String identifier = animationIdentifiers[num];
            String animationName = AnimationUtils.getAnimationName(identifier);
            double animationSpeedPretty = AnimationUtils.getAnimationSpeedPretty(identifier);
            String text = EnumChatFormatting.GREEN + "Animation Details (" + identifier + ")";
            String model = "Model: " + EnumChatFormatting.RED + "Bryahn";
            String anim = "Anim: " + EnumChatFormatting.YELLOW + animationName;
            String speed = "Speed: " + EnumChatFormatting.AQUA + BridgeUtils.round((double)1000.0, (double)animationSpeedPretty);
            String nuance = nuanceAnimation;
            double textScale = 0.7;
            double width = (double)mc.field_71466_p.func_78256_a(text) * textScale;
            double posX = 500.0 + (double)num * (width + 20.0);
            double posY = 320.0;
            RenderUtils.drawRectangleDouble(posX, posY, width + 3.0, 48.0, 0, 0.5);
            RenderUtils.drawScaledText(mc, text, textScale, posX += 2.0, posY += 2.0, false, 0);
            RenderUtils.drawScaledText(mc, model, textScale, posX, posY + 8.0, false, 0);
            RenderUtils.drawScaledText(mc, anim, textScale, posX, posY + 16.0, false, 0);
            RenderUtils.drawScaledText(mc, speed, textScale, posX, posY + 24.0, false, 0);
            double speedBar = animationSpeedPretty / 2.0;
            speedBar = Math.min(1.0, speedBar);
            RenderUtils.drawRectangle(posX, posY + 30.0, width * speedBar, 1.0, 65535, 0.55f);
            RenderUtils.drawScaledText(mc, nuance, 0.35, posX, posY + 32.0, false, 0, 35);
        }
    }

    public static void loadAnimation(String animationName) {
        AnimationUtils.loadAnimation("player", animationName, 1.0);
    }

    public static void loadAnimation(String identifier, String animationName, double inputSpeed) {
        boolean animationPlaying;
        String curAnimation = AnimationUtils.getAnimationName(identifier);
        if (animationName != null && (curAnimation == null || curAnimation != null && !curAnimation.equals(animationName))) {
            boolean inputMode = false;
            String fileName = (inputMode ? System.getProperty("user.dir") + animationInputPath : animationPath) + animationName + ".json";
            InputStream is = AnimationUtils.getFileFromResourceAsStream(fileName);
            AnimationUtils.interpretInputStream(identifier, is);
            AnimationUtils.setAnimationName(identifier, animationName);
        }
        if (animationPlaying = AnimationUtils.getAnimationPlaying(identifier)) {
            AnimationUtils.setAnimationSpeed(identifier, AnimationUtils.animationSpeed(inputSpeed));
            AnimationUtils.setAnimationSpeedPretty(identifier, inputSpeed);
        }
    }

    static double animationSpeed(double inputSpeed) {
        return inputSpeed <= 1.0 ? 2.0 / inputSpeed : 1.0 / inputSpeed;
    }

    private static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = AnimationUtils.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }

    private static void interpretInputStream(String identifier, InputStream is) {
        try (InputStreamReader streamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            AnimationUtils.initializeAnimationHashMap(identifier);
            while ((line = reader.readLine()) != null) {
                AnimationUtils.animationParser(identifier, line);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    private static void animationParser(String identifier, String line) {
        boolean debug = false;
        try {
            if (line.contains("loop")) {
                String toSplit = ": ";
                String splitString = line.split(toSplit)[1].replaceAll(",", "");
                AnimationUtils.setAnimationDoesLoop(identifier, Boolean.parseBoolean(splitString));
                if (debug) {
                    System.out.println("animationLoop: " + AnimationUtils.getAnimationDoesLoop(identifier));
                }
                return;
            }
            if (line.contains("animation_length")) {
                String toSplit = ": ";
                String splitString = line.split(toSplit)[1].replaceAll(",", "");
                AnimationUtils.setAnimationLength(identifier, Double.parseDouble(splitString));
                if (debug) {
                    System.out.println("animationLength: " + AnimationUtils.getAnimationLength(identifier));
                }
                return;
            }
            Object[][] modelParts = AnimationUtils.getIdentifierParts(identifier);
            for (int limbNum = 0; limbNum < modelParts.length; ++limbNum) {
                String modelPart = (String)modelParts[limbNum][0];
                if (!line.contains("\"" + modelPart + "\"")) continue;
                currentPart = modelPart;
                animationRotation.clear();
                animationPositions.clear();
                animationScaling.clear();
                if (debug) {
                    System.out.println(" - ");
                }
                if (debug) {
                    System.out.println("setting... currentPart: \"" + currentPart + "\"");
                }
                return;
            }
            if (currentPart != null) {
                if (line.contains("rotation")) {
                    currentType = "rotation";
                }
                if (line.contains("position")) {
                    currentType = "position";
                }
                if (line.contains("scale")) {
                    currentType = "scale";
                }
                AnimationUtils.frameParser(identifier, line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void frameParser(String identifier, String line) {
        boolean debug = false;
        if (currentType.equals("rotation")) {
            AnimationUtils.frameParseType(identifier, line, 0, debug);
        }
        if (currentType.equals("position")) {
            AnimationUtils.frameParseType(identifier, line, 1, debug);
        }
        if (currentType.equals("scale")) {
            AnimationUtils.frameParseType(identifier, line, 2, debug);
        }
    }

    static void frameParseType(String identifier, String line, int type, boolean debug) {
        double frameTime = 0.0;
        double axisX = 0.0;
        double axisY = 0.0;
        double axisZ = 0.0;
        boolean canParse = false;
        boolean containsType = line.contains(type == 0 ? "rotation" : (type == 1 ? "position" : (type == 2 ? "scale" : null)));
        if (!containsType) {
            if (line.contains("}")) {
                AnimationUtils.frameParserEnd(1, debug);
                return;
            }
            canParse = true;
        } else if (!line.contains("{")) {
            canParse = true;
        }
        if (canParse) {
            if (!containsType) {
                frameTime = Double.parseDouble(line.split("\"")[1].split("\"")[0]);
            }
            String[] values = line.split(": ")[1].split(",");
            for (int axis = 0; axis < values.length; ++axis) {
                double position = Double.parseDouble(values[axis].replaceAll("\\[", "").replaceAll("]", ""));
                if (axis == 0) {
                    axisX = position;
                }
                if (axis == 1) {
                    axisY = position;
                }
                if (axis != 2) continue;
                axisZ = position;
            }
            if (debug) {
                System.out.println("#" + animationPositions.size() + " frameTime: " + frameTime + " | axisX: " + axisX + " | axisY: " + axisY + " | axisZ: " + axisZ);
            }
            double[] keyFrameArray = new double[]{frameTime, axisX, axisY, axisZ};
            AnimationUtils.frameParserInput(identifier, keyFrameArray, type);
            if (debug) {
                System.out.println("keyFramePositions for: " + currentPart + " | new size: " + keyFramePositions.size() + " | keyFrames: " + animationPositions.size());
            }
        }
    }

    static void frameParserInput(String identifier, double[] input, int type) {
        ArrayList<double[]> newInput;
        int keyFrame = 0;
        int keyFrameLimit = 0;
        ArrayList<int[]> keyFrameArray = keyFrameList.get(identifier).get(currentPart);
        if (type == 0) {
            animationRotation.add(input);
            newInput = new ArrayList<double[]>(animationRotation);
            keyFrameRotations.put(identifier, AnimationUtils.parseHashHashHash(identifier, currentPart, 0, newInput));
            keyFrameLimit = keyFrameRotations.get(identifier).get(currentPart).size();
        }
        if (type == 1) {
            animationPositions.add(input);
            newInput = new ArrayList<double[]>(animationPositions);
            keyFramePositions.put(identifier, AnimationUtils.parseHashHashHash(identifier, currentPart, 1, newInput));
            keyFrameLimit = keyFramePositions.get(identifier).get(currentPart).size();
        }
        if (type == 2) {
            animationScaling.add(input);
            newInput = new ArrayList<double[]>(animationScaling);
            keyFrameScaling.put(identifier, AnimationUtils.parseHashHashHash(identifier, currentPart, 2, newInput));
            keyFrameLimit = keyFrameScaling.get(identifier).get(currentPart).size();
        }
        int[] keyFrameEntry = new int[]{keyFrame, keyFrameLimit};
        keyFrameArray.set(type, new int[]{keyFrame, keyFrameLimit});
        keyFrameList.put(identifier, AnimationUtils.parseHashHashHash2(identifier, currentPart, 3, keyFrameArray));
    }

    static void frameParserEnd(int type, boolean debug) {
        if (debug) {
            System.out.println("-  ");
            if (type == 0) {
                System.out.println("- FINISH - keyFrameRotations for: \"" + currentPart + "\" | newSize: " + keyFrameRotations.size() + " | keyFrames: " + animationRotation.size());
            }
            if (type == 1) {
                System.out.println("- FINISH - keyFramePositions for: \"" + currentPart + "\" | newSize: " + keyFramePositions.size() + " | keyFrames: " + animationPositions.size());
            }
            if (type == 2) {
                System.out.println("- FINISH - keyFrameScale for: \"" + currentPart + "\" | newSize: " + keyFrameScaling.size() + " | keyFrames: " + animationScaling.size());
            }
            System.out.println("-  ");
        }
        currentPart = null;
    }

    public static Object[][] getIdentifierParts(String identifier) {
        return identifier.equalsIgnoreCase("player") ? Body.newBodyParts : (identifier.equalsIgnoreCase("tail") ? Body.newTailParts : (Object[][])null);
    }

    static void initializeAnimationHashMap(String identifier) {
        keyFrameRotations.putIfAbsent(identifier, new HashMap());
        keyFramePositions.putIfAbsent(identifier, new HashMap());
        keyFrameScaling.putIfAbsent(identifier, new HashMap());
        keyFrameList.putIfAbsent(identifier, new HashMap());
        ArrayList<double[]> defaultFrameList = new ArrayList<double[]>();
        double[] defaultArray = new double[]{0.0, 0.0, 0.0, 0.0};
        defaultFrameList.add(defaultArray);
        ArrayList<double[]> defaultFrameList2 = new ArrayList<double[]>();
        double[] defaultArray2 = new double[]{0.0, 1.0, 1.0, 1.0};
        defaultFrameList2.add(defaultArray2);
        ArrayList<int[]> defaultFrameList3 = new ArrayList<int[]>();
        int[] defaultArray3 = new int[]{0, 0};
        defaultFrameList3.add(defaultArray3);
        defaultFrameList3.add(defaultArray3);
        defaultFrameList3.add(defaultArray3);
        Object[][] modelParts = AnimationUtils.getIdentifierParts(identifier);
        for (int partNum = 0; partNum < modelParts.length; ++partNum) {
            String modelPart = (String)modelParts[partNum][0];
            keyFrameRotations.put(identifier, AnimationUtils.parseHashHashHash(identifier, modelPart, 0, defaultFrameList));
            keyFramePositions.put(identifier, AnimationUtils.parseHashHashHash(identifier, modelPart, 1, defaultFrameList));
            keyFrameScaling.put(identifier, AnimationUtils.parseHashHashHash(identifier, modelPart, 2, defaultFrameList2));
            keyFrameList.put(identifier, AnimationUtils.parseHashHashHash2(identifier, modelPart, 3, defaultFrameList3));
        }
    }

    static HashMap<String, ArrayList<double[]>> parseHashHashHash(String identifier, String modelPart, int type, ArrayList<double[]> dataInput) {
        HashMap<String, ArrayList<double[]>> input = type == 0 ? keyFrameRotations.get(identifier) : (type == 1 ? keyFramePositions.get(identifier) : (type == 2 ? keyFrameScaling.get(identifier) : null));
        input.put(modelPart, dataInput);
        return input;
    }

    static HashMap<String, ArrayList<int[]>> parseHashHashHash2(String identifier, String modelPart, int type, ArrayList<int[]> dataInput) {
        HashMap<String, ArrayList<int[]>> input = type == 3 ? keyFrameList.get(identifier) : null;
        input.put(modelPart, dataInput);
        return input;
    }

    public static void animateModel() {
        for (String identifier : animationIdentifiers) {
            boolean animationPlaying = AnimationUtils.getAnimationPlaying(identifier);
            if (!animationPlaying) {
                return;
            }
            Object[][] modelParts = AnimationUtils.getIdentifierParts(identifier);
            for (int partNum = 0; partNum < modelParts.length; ++partNum) {
                String modelPart = (String)modelParts[partNum][0];
                AnimationUtils.animateModelPart(identifier, modelPart, partNum);
            }
        }
    }

    public static void animateModelPart(String identifier, String modelPart, int limbNum) {
        boolean debug = false;
        String debugPart = "tail1";
        if (!modelPart.equals(debugPart) && debug) {
            debug = false;
        }
        if (cancelAnimation) {
            int animationProgress = AnimationUtils.getAnimationProgress(identifier);
            if (animationProgress > 0) {
                AnimationUtils.setAnimationProgress(identifier, 0);
            }
            return;
        }
        int frameRotation = AnimationUtils.getKeyFrame(identifier, modelPart, 0, false);
        int framePosition = AnimationUtils.getKeyFrame(identifier, modelPart, 1, false);
        int frameScaling = AnimationUtils.getKeyFrame(identifier, modelPart, 2, false);
        if (debug) {
            System.out.println("keyFrames: rotate: " + frameRotation + " | position: " + framePosition + " | scale: " + frameScaling);
        }
        ArrayList<double[]> rotationList = keyFrameRotations.get(identifier).get(modelPart);
        AnimationUtils.animationModelParse(identifier, modelPart, rotationList, frameRotation, 0, debug);
        ArrayList<double[]> positionList = keyFramePositions.get(identifier).get(modelPart);
        AnimationUtils.animationModelParse(identifier, modelPart, positionList, framePosition, 1, debug);
        ArrayList<double[]> scaleList = keyFrameScaling.get(identifier).get(modelPart);
        AnimationUtils.animationModelParse(identifier, modelPart, scaleList, frameScaling, 2, debug);
    }

    static void animationModelParse(String identifier, String modelPart, ArrayList<double[]> dataInput, int frame, int type, boolean debug) {
        boolean doType;
        boolean bl = doType = type == 0 && doRotations || type == 1 && doPositions || type == 2 && doScale;
        if (doType && dataInput.size() - 1 >= frame) {
            double axisX = AnimationUtils.getNextFrame(identifier, modelPart, dataInput, 0, type);
            double axisY = AnimationUtils.getNextFrame(identifier, modelPart, dataInput, 1, type);
            double axisZ = AnimationUtils.getNextFrame(identifier, modelPart, dataInput, 2, type);
            double[] newEntry = new double[]{axisX, axisY, axisZ};
            if (type == 0) {
                Body.currentRotations.get(identifier).put(modelPart, newEntry);
            }
            if (type == 1) {
                Body.currentPositions.get(identifier).put(modelPart, newEntry);
            }
            if (type == 2) {
                Body.currentScaling.get(identifier).put(modelPart, newEntry);
            }
            if (debug) {
                System.out.println("- animateModelPart: \"" + modelPart + "\" | type: " + type + " | frame #" + frame + " | " + Arrays.toString(newEntry));
            }
        }
    }

    static int getKeyFrame(String identifier, String modelPart, int type, boolean limit) {
        boolean debug = false;
        if (debug) {
            System.out.println("getKeyFrame: " + modelPart + " | type: " + type + " | limit: " + limit);
        }
        ArrayList<int[]> keyFrameArray = keyFrameList.get(identifier).get(modelPart);
        int[] keyFrame0 = keyFrameArray.get(type);
        return keyFrame0[limit ? 1 : 0];
    }

    static double getNextFrame(String identifier, String modelPart, ArrayList<double[]> keyList, int axis, int type) {
        int keyFrame = AnimationUtils.getKeyFrame(identifier, modelPart, type, false);
        double[] keyFramesStart = keyList.get(keyFrame);
        double[] keyFramesNext = keyList.get(keyList.size() - 1 >= keyFrame + 1 ? keyFrame + 1 : 0);
        double start = keyFramesStart[axis + 1];
        if (keyFrame == 0) {
            start = type == 0 ? Body.currentRotations.get(identifier).get(modelPart)[axis] : (type == 1 ? Body.currentPositions.get(identifier).get(modelPart)[axis] : (type == 2 ? Body.currentScaling.get(identifier).get(modelPart)[axis] : 0.0));
        }
        double next = keyFramesNext[axis + 1];
        int animationProgress = AnimationUtils.getAnimationProgress(identifier);
        double animationTimeLimit = AnimationUtils.getAnimationTimeLimit(identifier);
        double keyFrameProgress = (double)animationProgress / animationTimeLimit;
        double increase = (next - start) * keyFrameProgress;
        double result = start + increase;
        return result;
    }

    public static double parseBBOffset(double input) {
        return input / 16.0;
    }

    public static float degToRad(float degrees) {
        return degrees * (float)Math.PI / 180.0f;
    }

    public static double rotationMCtoReal(double input) {
        return input * 57.295776;
    }

    static {
        animationPath = "assets/dbapollo/models/animations/";
        animationInputPath = "/config/Apollo/Animations/";
        currentPart = null;
        currentType = null;
        animationRotation = new ArrayList();
        animationPositions = new ArrayList();
        animationScaling = new ArrayList();
        keyFrameRotations = new HashMap();
        keyFramePositions = new HashMap();
        keyFrameScaling = new HashMap();
        keyFrameList = new HashMap();
    }
}

