/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils.Config;

import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;

public class ConfigHandler {
    private String name = "";
    private String value = "";
    private String default_value;

    static int validateInteger(int value, int valueLimit, int i) {
        return ConfigHandler.validateInteger(value, 0, valueLimit, 0, i);
    }

    static boolean validateBoolean(int i) {
        ConfigHandler config = ApolloConfig.configs.get(i);
        return Boolean.parseBoolean(config.getValue());
    }

    static int validateInteger(int value, int valueLimit, int valueLimit2, int valueDefault, int i) {
        value = Integer.parseInt(ApolloConfig.configs.get(i).getValue());
        if (value != -1 && (value < valueLimit || value > valueLimit2)) {
            value = valueDefault;
        }
        return value;
    }

    static float validateFloat(float value, float valueMin, float valueMax, float valueDefault, int i) {
        value = Float.parseFloat(ApolloConfig.configs.get(i).getValue());
        if (value != -1.0f && (value < valueMin || value > valueMax)) {
            value = valueDefault;
        }
        return value;
    }

    static float validateOffGlobal(float value) {
        return value == -1.0f ? 1.0f : value;
    }

    public static int getConfigOption(int configOption, int globalOption) {
        return configOption == -1 ? globalOption : configOption;
    }

    public static float getConfigOption(float configOption, float globalOption) {
        return configOption == -1.0f ? globalOption : configOption;
    }

    void set_all(String s, String s2, String s3) {
        this.name = s;
        this.value = s2;
        this.default_value = s3;
    }

    String getName() {
        return this.name;
    }

    void setName(String s) {
        this.name = s;
    }

    String getDefaultValue() {
        return this.default_value;
    }

    void setDefaultValue(String s) {
        this.default_value = s;
    }

    String getValue() {
        return this.value != null && !this.value.isEmpty() ? this.value : this.default_value;
    }

    void setValue(String s) {
        this.value = s;
    }
}

