/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import java.util.ArrayList;
import java.util.Arrays;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ApolloItems;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CrateScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.SoundUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CrateUtilClient {
    public static String[] crateNames = new String[]{"Low", "Mid", "High", "God", "Vote", "Golden", "Event", "Spook", "Jolly"};
    public static int[] crateColors = new int[]{174080, 11048960, 11010054, 7078056, 22696, 43137, 16711900, 16738816, 0xFF0000};
    public static ItemStack[] crateKeyItems = new ItemStack[]{new ItemStack(ApolloItems.itemLowTierKey), new ItemStack(ApolloItems.itemMidTierKey), new ItemStack(ApolloItems.itemHighTierKey), new ItemStack(ApolloItems.itemGodTierKey), new ItemStack(ApolloItems.itemEventKey), new ItemStack(ApolloItems.itemGoldenKey), new ItemStack(ApolloItems.item500EventKey), new ItemStack(ApolloItems.itemSpookyKey), new ItemStack(ApolloItems.itemChristmasKey)};
    public static ItemStack[] crateTokenItems = new ItemStack[]{new ItemStack(ApolloItems.ltt), new ItemStack(ApolloItems.mtt), new ItemStack(ApolloItems.htt), new ItemStack(ApolloItems.gtt)};
    public static TileEntity crateEntity = null;
    public static float crateAnim;
    public static float crateAnimBroken;
    public static float crateAnimFly;
    public static float crateAnimSpin;
    public static float crateAnimShake;
    public static float keyAnim;
    public static float keyAnim2;
    public static float crateIntensity;
    public static float crateRandom;
    public static long crateAnimTime;
    public static long crateAnimTime2;
    public static boolean crateOpening;
    public static boolean crateClosing;
    public static boolean crateBroken;
    public static boolean crateAnimDirection2;
    public static boolean openingStarted;
    public static boolean rewardRolling;
    public static boolean keyTurned;
    public static boolean lidOpened;
    public static boolean animationSkipped;
    static boolean keyTurnSound;
    static boolean latchSound;
    static boolean openSound;
    static boolean flySound;
    static boolean landSound;
    static boolean breakSound;
    static boolean testForceBreak;
    static boolean testNoClose;
    public static int crateAnimType;
    public static int crateKeys;
    public static int crateType;
    public static int crateZone;
    public static int tpAmount;
    public static double cratePosX;
    public static double cratePosY;
    public static double cratePosZ;
    public static float crateKeyMax;
    public static float crateKey2Max;
    public static float crateAnimMax;
    public static float crateAnimMin;
    public static float crateAnimMaxBreak;
    public static float crateAnimMaxFly;
    public static float crateAnimMinFly;
    public static float crateAnimMaxSpin;
    public static float crateAnimMaxShake;
    public static float crateAnimMinShake;
    static boolean debugCrateAnim;
    static boolean debugCrateContents;

    public static void startAnimation(String crateData) {
        String dataSplit = crateData.split("crateOpening:")[1];
        String[] dataArray = dataSplit.split(",");
        CrateUtilClient.startAnimation(Integer.parseInt(dataArray[0]), Double.parseDouble(dataArray[1]), Double.parseDouble(dataArray[2]), Double.parseDouble(dataArray[3]));
        CrateUtilClient.startAnimation(crateAnimType, false);
    }

    public static void startAnimation(int animType, double crateXPos, double crateYPos, double crateZPos) {
        crateAnimType = animType;
        cratePosX = crateXPos;
        cratePosY = crateYPos;
        cratePosZ = crateZPos;
        CrateUtilClient.startAnimation(crateAnimType, false);
    }

    public static void startAnimation(int animType, boolean special) {
        crateAnimTime = System.currentTimeMillis();
        crateAnimType = animType;
        float f = crateAnimType == 0 ? (special ? 6.0f : 2.0f) : (crateIntensity = crateAnimType == 1 ? 6.0f : 1.0f);
        if (crateAnimType == 0 || crateAnimType == 1) {
            crateOpening = true;
            crateClosing = false;
            crateRandom = (float)Math.random();
            if (crateAnimType == 0) {
                crateBroken = (double)crateRandom <= (testForceBreak ? 1.0 : 0.15);
            }
        }
        CrateUtilClient.clearAnimation();
    }

    public static void clearAnimation() {
        crateAnim = 0.0f;
        crateAnimBroken = 0.0f;
        crateAnimFly = 0.0f;
        crateAnimSpin = 0.0f;
        crateAnimShake = 0.0f;
        keyAnim = 0.0f;
        keyAnim2 = 0.0f;
    }

    public static void clearAnimationScreen() {
        crateOpening = false;
        crateClosing = false;
        crateBroken = false;
        crateAnimDirection2 = false;
        openingStarted = false;
        rewardRolling = false;
        keyTurned = false;
        lidOpened = false;
        animationSkipped = false;
        keyTurnSound = false;
        latchSound = false;
        openSound = false;
        flySound = false;
        landSound = false;
        breakSound = false;
    }

    public static boolean isCrateActive(TileEntity tileEntity) {
        boolean active;
        boolean bl = active = tileEntity.func_145835_a(cratePosX, cratePosY, cratePosZ) <= 1.0;
        if (active) {
            crateEntity = tileEntity;
        }
        return active;
    }

    public static void crateAnim() {
        if (!openingStarted) {
            return;
        }
        if (!keyTurned) {
            if (keyAnim < crateKeyMax) {
                keyAnim += 0.02f;
            } else {
                if (!keyTurnSound) {
                    keyTurnSound = true;
                    SoundUtils.playSound("dbapollo:crates.keyTurn", false);
                }
                if ((keyAnim2 += 3.0f) >= crateKey2Max) {
                    keyTurned = true;
                    CrateScreen.openGui();
                }
            }
        }
        if (crateAnimType == 0 && !animationSkipped) {
            if (!rewardRolling && (float)ClientUtils.getTimeSince(crateAnimTime) >= 5000.0f / crateIntensity) {
                crateOpening = false;
                if (!testNoClose) {
                    boolean bl = crateClosing = !crateBroken;
                }
            }
            if (!crateBroken || crateOpening || (float)ClientUtils.getTimeSince(crateAnimTime) >= 9000.0f / crateIntensity) {
                // empty if block
            }
            if (crateOpening || crateClosing) {
                if (crateOpening && !openSound) {
                    openSound = true;
                    SoundUtils.playSound("dbapollo:crates.crateOpen", false);
                }
                if ((crateAnim += (crateOpening ? 2.5f : -1.5f) * crateIntensity) > crateAnimMax) {
                    crateOpening = false;
                    crateAnim = crateAnimMax;
                    lidOpened = true;
                    CrateScreen.openGui();
                    CrateScreen.startRoll();
                }
                if (crateAnim <= crateAnimMin) {
                    crateClosing = false;
                    crateAnim = 0.0f;
                    crateAnimType = -1;
                }
            }
            if (crateBroken && !crateOpening && crateAnimBroken < crateAnimMaxBreak) {
                if (!breakSound) {
                    breakSound = true;
                }
                if ((crateAnimBroken += 2.5f * crateIntensity) >= crateAnimMaxBreak) {
                    crateAnimBroken = crateAnimMaxBreak;
                }
                if (debugCrateAnim) {
                    System.out.println("crateBreaking: " + crateAnimBroken);
                }
            }
            if (debugCrateAnim) {
                System.out.println("crateOpening: " + crateAnim + " | open: " + crateOpening + " | close: " + crateClosing + " | break: " + crateBroken + " | " + ClientUtils.getTimeSince(crateAnimTime));
            }
        } else if (crateAnimType == 1) {
            if (crateOpening || crateClosing && (float)ClientUtils.getTimeSince(crateAnimTime2) >= 1500.0f / crateIntensity) {
                if (!flySound) {
                    flySound = true;
                    SoundUtils.playSound("dbapollo:crates.crateFly", false);
                }
                float animGravity = -0.09f * ((crateAnimMaxFly - crateAnimFly) / crateAnimMaxFly);
                crateAnimFly += (crateOpening ? 0.01f : -0.02f + animGravity) * crateIntensity;
                if (debugCrateAnim) {
                    System.out.println("animGravity: " + animGravity + " | " + crateAnimFly);
                }
                if (crateAnimFly > crateAnimMaxFly) {
                    crateAnimTime2 = System.currentTimeMillis();
                    crateOpening = false;
                    crateClosing = true;
                    crateAnimSpin = 0.0f;
                }
                if (crateAnimFly <= crateAnimMinFly) {
                    if (!landSound) {
                        landSound = true;
                        SoundUtils.playSound("dbapollo:crates.crateLand", true);
                    }
                    crateAnimFly = 0.0f;
                    crateClosing = false;
                    CrateUtilClient.startAnimation(0, true);
                    return;
                }
            }
            if (crateOpening && (crateAnimSpin += 1.84f * crateIntensity) > crateAnimMaxSpin) {
                crateAnimSpin = 0.0f;
            }
            if (debugCrateAnim) {
                System.out.println("crateAnimFly: " + crateAnimFly + " | crateAnimSpin: " + crateAnimSpin + " | open: " + crateOpening + " | close: " + crateClosing);
            }
        } else if (crateAnimType == 2) {
            if (ClientUtils.getTimeSince(crateAnimTime) >= 1500L) {
                crateAnimType = -1;
            }
            if ((crateAnimShake += !crateAnimDirection2 ? 0.002f : -0.002f) > crateAnimMaxShake) {
                crateAnimDirection2 = true;
            }
            if (crateAnimShake < crateAnimMinShake) {
                crateAnimDirection2 = false;
            }
            if (debugCrateAnim) {
                System.out.println("crateScared: " + crateAnimShake + " | " + ClientUtils.getTimeSince(crateAnimTime));
            }
        }
    }

    public static void addItemToCrateContents(ArrayList<Object[]> crateContents, ItemStack itemStack, double chance) {
        Object[] entry = new Object[]{itemStack, chance};
        if (debugCrateContents) {
            System.out.println("addItemToCrateContents #" + crateContents.size() + " = " + Arrays.toString(entry));
        }
        crateContents.add(entry);
    }

    public static void sortCrateContents(ArrayList<Object[]> crateContents, boolean reverseOrder) {
        crateContents.sort((o1, o2) -> {
            double chance1 = (Double)o1[1];
            double chance2 = (Double)o2[1];
            return (int)(chance1 - chance2);
        });
        if (reverseOrder) {
            ArrayList<Object[]> sortedContents = new ArrayList<Object[]>();
            for (int i = crateContents.size() - 1; i >= 0; --i) {
                sortedContents.add(crateContents.get(i));
            }
            crateContents.clear();
            crateContents.addAll(sortedContents);
        }
    }

    static {
        crateIntensity = 1.0f;
        crateRandom = 0.0f;
        crateAnimTime = 0L;
        crateAnimTime2 = 0L;
        crateOpening = false;
        crateClosing = false;
        crateBroken = false;
        crateAnimDirection2 = false;
        openingStarted = false;
        rewardRolling = false;
        keyTurned = false;
        lidOpened = false;
        animationSkipped = false;
        keyTurnSound = false;
        latchSound = false;
        openSound = false;
        flySound = false;
        landSound = false;
        breakSound = false;
        testForceBreak = false;
        testNoClose = false;
        crateAnimType = -1;
        crateKeys = -1;
        crateKeyMax = 0.35f;
        crateKey2Max = 90.0f;
        crateAnimMax = 135.0f;
        crateAnimMin = 0.0f;
        crateAnimMaxBreak = 45.0f;
        crateAnimMaxFly = 2.0f;
        crateAnimMinFly = 0.0f;
        crateAnimMaxSpin = 359.0f;
        crateAnimMaxShake = 0.03f;
        crateAnimMinShake = -0.03f;
        debugCrateAnim = false;
        debugCrateContents = false;
    }
}

