/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import java.awt.Color;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import org.lwjgl.opengl.GL11;

public class GLUtils {
    public static int[] blenderArray = new int[]{0, 1, 768, 769, 770, 771, 772, 773, 774, 775, 776};
    public static String[] blenderNames = new String[]{"GL_ZERO", "GL_ONE", "GL_SRC_COLOR", "GL_ONE_MINUS_SRC_COLOR", "GL_SRC_ALPHA", "GL_ONE_MINUS_SRC_ALPHA", "GL_DST_ALPHA", "GL_ONE_MINUS_DST_ALPHA", "GL_DST_COLOR", "GL_ONE_MINUS_DST_COLOR", "GL_SRC_ALPHA_SATURATE"};
    public static float rotateX = 0.5f;
    public static float rotateY = 0.5f;
    public static float rotateZ = 0.5f;
    public static float translateX = 0.5f;
    public static float translateY = 0.5f;
    public static float translateZ = 0.5f;
    public static float translateAmount = 2.5f;
    public static float scaleX = 0.5f;
    public static float scaleY = 0.5f;
    public static float scaleZ = 0.5f;
    public static float scaleAmount = 2.0f;
    public static int blendSrcFactor = 0;
    public static int blendDstFactor = 0;

    public static void flipFlopLobster() {
        GL11.glRotatef((float)GLUtils.flipFlopRotate(rotateZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)GLUtils.flipFlopRotate(rotateX), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)GLUtils.flipFlopRotate(rotateY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)GLUtils.flipFlopTranslate(translateX), (float)GLUtils.flipFlopTranslate(translateY), (float)GLUtils.flipFlopTranslate(translateZ));
        GL11.glScalef((float)GLUtils.flipFlopScale(scaleX), (float)GLUtils.flipFlopScale(scaleY), (float)GLUtils.flipFlopScale(scaleZ));
    }

    public static void blendBoilLobster() {
        GLUtils.blendSourceDestination(blendSrcFactor, blendDstFactor);
    }

    public static void blendSourceDestination() {
        GLUtils.blendSourceDestination(SUBEvents.getTV(0).intValue(), SUBEvents.getTV(1).intValue());
    }

    public static void blendSourceDestination(int source, int destination) {
        if (source >= blenderArray.length || source < 0 || destination >= blenderArray.length || destination < 0) {
            return;
        }
        GL11.glBlendFunc((int)blenderArray[source], (int)blenderArray[destination]);
    }

    public static float flipFlopRotate(float value) {
        return BridgeUtils.round((float)100.0f, (float)(value * 360.0f - 180.0f));
    }

    public static float flipFlopTranslate(float value) {
        return BridgeUtils.round((float)1000.0f, (float)(value * (translateAmount * 2.0f) - translateAmount));
    }

    public static float flipFlopScale(float value) {
        return BridgeUtils.round((float)1000.0f, (float)(value * scaleAmount));
    }

    public static void glColor3f(int c) {
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void glColor4f(int c, float a) {
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static int colorFromRGB(float r, float g, float b) {
        return (int)(r * 65536.0f + g * 256.0f + b);
    }

    public static float[] rgbFromColor(int colorCode) {
        float r = (float)(colorCode >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorCode >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorCode & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int hexDecimalFromColor(Color color) {
        return color.getRed() * 65536 + color.getGreen() * 256 + color.getBlue();
    }

    public static float[] hsbFromColor(int colorCode) {
        int r = colorCode >> 16 & 0xFF;
        int g = colorCode >> 8 & 0xFF;
        int b = colorCode & 0xFF;
        return Color.RGBtoHSB(r, g, b, null);
    }

    public static int hsbShift(int color) {
        return GLUtils.hsbShift(color, SUBEvents.getTV(0).floatValue(), SUBEvents.getTV(1).floatValue(), SUBEvents.getTV(2).floatValue());
    }

    public static int hsbShift(int color, float hue, float saturation, float brightness) {
        float[] hsb = GLUtils.hsbFromColor(color);
        float newHue = Math.min(1.0f, hsb[0] * hue);
        float newSaturation = Math.min(1.0f, hsb[1] * saturation);
        float newBrightness = Math.min(1.0f, hsb[2] * brightness);
        Color colSet = Color.getHSBColor(newHue, newSaturation, newBrightness);
        return GLUtils.hexDecimalFromColor(colSet);
    }

    public static int mixColorInt(int color1, int color2, double ratio) {
        Color colorStart = new Color(color1);
        Color colorEnd = new Color(color2);
        return GLUtils.mixColor(colorEnd, colorStart, ratio).hashCode();
    }

    public static Color mixColor(Color c, Color d, double weightOfColorC) {
        float[] cc = c.getComponents(null);
        float[] dd = d.getComponents(null);
        float[] result = new float[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = (float)(weightOfColorC * (double)cc[i] + (1.0 - weightOfColorC) * (double)dd[i]);
        }
        return new Color(result[0], result[1], result[2], result[3]);
    }

    public static void glResetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void glBlendAlpha() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
    }

    public static void glBlendAlphaPop() {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void glBlendExtra() {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GLUtils.glBlendAlpha();
    }

    public static void glBlendExtraPop() {
        GLUtils.glBlendAlphaPop();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }
}

