/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.MainMenu;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.DisplayUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.FileWalker;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.Display;

public class SoundUtils {
    static boolean debug = false;
    static final SoundHandler soundHandler = Main.mc.func_147118_V();
    static String currentSound;
    static long soundStartTime;
    static long soundEndTime;
    static final int soundDelayTime = 160;
    static boolean hasPlayedIntro;
    static ArrayList<Object[]> soundList;
    static final String[] soundIdentifier;
    static final String[] soundNames;
    static float soundLevelB4;
    static final boolean debugSoundMute = false;

    public static void checkActiveSound() {
        boolean menuNotActive;
        GuiScreen currentScreen = Main.mc.field_71462_r;
        long timeSinceLastSound = ClientUtils.getTimeSince(soundStartTime);
        boolean bl = menuNotActive = currentSound != null && !currentSound.contains("menu") && !currentSound.contains("random.hover");
        if (currentScreen != null && (timeSinceLastSound >= 160000L || menuNotActive)) {
            String guiString = currentScreen.toString();
            int timeOnModpack = ClientUtils.getTimeSince(Main.loginTime);
            if (debug) {
                System.out.println("checkActiveSound on screen: " + guiString + " timeOnModpack: " + timeOnModpack + " | " + timeSinceLastSound + " >= " + 160000 + " | " + menuNotActive);
            }
            if (guiString.toLowerCase().contains("mainmenu") && timeOnModpack > 3) {
                if (!hasPlayedIntro) {
                    hasPlayedIntro = true;
                    SoundUtils.playSound("intro");
                } else if (timeOnModpack > 15 && !MainMenu.splashScreen) {
                    SoundUtils.playSound("menu");
                }
            }
        }
    }

    public static void playSound(String soundType) {
        SoundUtils.playSound(soundType, true);
    }

    public static void playSound(String soundType, boolean stopOthers) {
        String soundToPlay;
        if (stopOthers) {
            soundHandler.func_147690_c();
        }
        if ((soundToPlay = SoundUtils.convertSound(soundType)) != null) {
            if (!SoundUtils.isSoundPlaying(soundToPlay, false)) {
                if (debug) {
                    System.out.println("Attempting to play " + soundToPlay);
                }
                ResourceLocation resourceLocation = new ResourceLocation(soundToPlay);
                PositionedSoundRecord iSound = PositionedSoundRecord.func_147673_a((ResourceLocation)resourceLocation);
                if (soundType.equals("random.hover")) {
                    soundHandler.func_147683_b((ISound)iSound);
                }
                soundHandler.func_147682_a((ISound)iSound);
                currentSound = soundToPlay;
                soundStartTime = System.currentTimeMillis();
                Object[] soundEntry = new Object[]{currentSound, soundStartTime, soundEndTime};
                soundList.add(soundEntry);
            }
        } else if (debug) {
            System.out.println("Sound invalid! \"" + soundType + "\"");
        }
    }

    static double getSoundDuration(ResourceLocation resourceLocation) {
        System.out.println("#1 " + resourceLocation.func_110623_a());
        System.out.println("#2 " + resourceLocation.func_110624_b());
        String soundName = resourceLocation.func_110623_a().replace(".", "/");
        String fileLocation = "dbapollo:sounds/" + soundName + ".ogg";
        System.out.println("soundName: " + soundName);
        System.out.println("fileLocation: " + fileLocation);
        double durationInSeconds = 0.0;
        try {
            ResourceLocation soundResource = new ResourceLocation(fileLocation);
            BufferedInputStream audioStream = new BufferedInputStream(Main.mc.func_110442_L().func_110536_a(soundResource).func_110527_b());
            InputStreamReader inputStreamReader = new InputStreamReader(audioStream);
            System.out.println("input: " + inputStreamReader);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioStream);
            AudioFormat format = audioInputStream.getFormat();
            int frameSize = format.getFrameSize();
            float frameRate = format.getFrameRate();
            System.out.println("frame: " + frameSize + " | " + frameRate);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            throw new RuntimeException(e);
        }
        return durationInSeconds;
    }

    private static InputStream getFileFromResourceAsStream(String fileLocation) {
        ClassLoader classLoader = SoundUtils.class.getClassLoader();
        BufferedInputStream inputStream = new BufferedInputStream(classLoader.getResourceAsStream(fileLocation));
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileLocation);
        }
        return inputStream;
    }

    private static File getFileFromResource(String fileName) throws URISyntaxException {
        ClassLoader classLoader = SoundUtils.class.getClassLoader();
        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return new File(resource.toURI());
    }

    public static boolean isSoundPlaying(String soundToPlay, boolean stopSound) {
        boolean debug = false;
        PositionedSoundRecord iSound = PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(soundToPlay));
        if (debug) {
            System.out.println("checking if sound is playing: " + soundToPlay);
        }
        if (soundHandler.func_147692_c((ISound)iSound)) {
            if (debug) {
                System.out.println("sound is playing: " + soundToPlay);
            }
            if (stopSound) {
                soundHandler.func_147683_b((ISound)iSound);
            }
            return true;
        }
        return false;
    }

    public static String convertSound(String soundType) {
        int random;
        String soundToPlay = null;
        if (soundType.equalsIgnoreCase("intro")) {
            soundToPlay = "dbapollo:music.intro";
        }
        if (soundType.equalsIgnoreCase("menu")) {
            random = new Random().nextInt(3) + 1;
            soundToPlay = "dbapollo:music.menu_" + random;
        }
        if (soundType.equalsIgnoreCase("wild")) {
            random = new Random().nextInt(2) + 1;
            soundToPlay = "dbapollo:music.wild_" + random;
        }
        if (soundType.equalsIgnoreCase("conton")) {
            random = new Random().nextInt(1) + 1;
            soundToPlay = "dbapollo:music.conton_" + random;
        }
        if (soundType.contains("quests") || soundType.contains("random") || soundType.contains("gameplay") || soundType.contains("crates")) {
            soundToPlay = soundType;
        }
        if (soundToPlay == null) {
            soundToPlay = "minecraft:" + soundType;
        }
        return soundToPlay;
    }

    public static String getCurrentPlaying() {
        String convertedSound = currentSound;
        for (int i = 0; i < soundIdentifier.length; ++i) {
            String compareSound = soundIdentifier[i];
            if (!currentSound.contains(compareSound)) continue;
            convertedSound = soundNames[i];
        }
        return convertedSound;
    }

    public static void disableMCSounds() {
        String[] toCheck = new String[]{"music.menu", "music.game", "music.game.creative"};
        if (debug) {
            System.out.println("disableMCSounds: " + soundHandler + " (" + (soundHandler != null) + ")");
        }
        if (soundHandler != null) {
            for (String checking : toCheck) {
                PositionedSoundRecord iSound;
                String checkSound = "minecraft:" + checking;
                if (debug) {
                    System.out.println("Attempting to check: " + checkSound);
                }
                if (!soundHandler.func_147692_c((ISound)(iSound = PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(checkSound))))) continue;
                soundHandler.func_147683_b((ISound)iSound);
                if (!debug) continue;
                System.out.println("Attempting to stop: " + checkSound + " from playing");
            }
        }
    }

    public static void soundMute() {
        if (!DisplayUtils.canfpsLimit) {
            return;
        }
        float soundLevel = Main.mc.field_71474_y.func_151438_a(SoundCategory.MASTER);
        if (!ApolloConfig.soundWhileMinimized && !Display.isVisible() || !ApolloConfig.soundWhileUnfocused && !Display.isActive()) {
            float soundLevelNew = 0.0f;
            if (soundLevel > soundLevelNew) {
                soundLevelB4 = soundLevel;
                FileWalker.handleSpecialOptions(1, true);
                Main.mc.field_71474_y.func_151439_a(SoundCategory.MASTER, soundLevelNew);
            }
        } else if (Display.isVisible() && Display.isActive()) {
            SoundUtils.soundRevert();
        }
        if (Display.isCloseRequested()) {
            SoundUtils.soundRevert();
        }
    }

    public static void soundRevert() {
        if (soundLevelB4 != 0.0f) {
            Main.mc.field_71474_y.func_151439_a(SoundCategory.MASTER, soundLevelB4);
            soundLevelB4 = 0.0f;
        }
    }

    public static void drawSoundList(double posX, double posY) {
        double scale = 0.5;
        double yOffset = 0.0;
        for (Object[] soundEntry : soundList) {
            String soundName = (String)soundEntry[0];
            long soundStartTime = (Long)soundEntry[1];
            long soundEndTime = (Long)soundEntry[2];
            double posXOffset = posX;
            double posYOffset = posY + yOffset * 25.0;
            String text = "Sound: " + soundName;
            RenderUtils.drawScaledText(Main.mc, text, scale, posXOffset, posYOffset, true, 1);
            float duration = RenderUtils.getDuration(soundEndTime - soundStartTime, ClientUtils.getTimeSince(soundStartTime));
            double barWidth = 80.0;
            double durationWidth = barWidth * (double)duration;
            double durationHeight = 2.0;
            RenderUtils.drawRectangle(posXOffset - barWidth / 2.0, posYOffset + 6.0, durationWidth, durationHeight, 255.0, 255.0, 255.0, 0.25);
            yOffset += 1.0;
        }
    }

    static {
        hasPlayedIntro = false;
        soundList = new ArrayList();
        soundIdentifier = new String[]{"conton_1", "menu_1", "menu_2", "menu_3", "wild_1", "wild_2"};
        soundNames = new String[]{"Kakarot OST - Its a Big World", "Kakarot OST - A Moment of Peace", "Kakarot OST - The Adventure Begins!", "Kakarot OST - Solid State Scouter", "Adventure Music", "Kakarot OST - Country Living"};
    }
}

