/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.DRPC;

import JinRyuu.JRMCore.JRMCoreH;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.DRPC.DiscordRPC;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.ChallengerSelection;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.ChallengerStage;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiCustomDeath;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiRender;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.HairEditor;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Util;

public class DiscordRichPresence
extends Structure {
    private static final List<String> FIELD_ORDER = Collections.unmodifiableList(Arrays.asList("state", "details", "startTimestamp", "endTimestamp", "largeImageKey", "largeImageText", "smallImageKey", "smallImageText", "partyId", "partySize", "partyMax", "matchSecret", "joinSecret", "spectateSecret", "instance"));
    public String state;
    public String details;
    public long startTimestamp;
    public long endTimestamp;
    public String largeImageKey;
    public String largeImageText;
    public String smallImageKey;
    public String smallImageText;
    public String partyId;
    public int partySize;
    public int partyMax;
    public String matchSecret;
    public String joinSecret;
    public String spectateSecret;
    public byte instance;

    public DiscordRichPresence(String encoding) {
        this.setStringEncoding(encoding);
    }

    public DiscordRichPresence() {
        this("UTF-8");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscordRichPresence)) {
            return false;
        }
        DiscordRichPresence presence = (DiscordRichPresence)o;
        return this.startTimestamp == presence.startTimestamp && this.endTimestamp == presence.endTimestamp && this.partySize == presence.partySize && this.partyMax == presence.partyMax && this.instance == presence.instance && Objects.equals(this.state, presence.state) && Objects.equals(this.details, presence.details) && Objects.equals(this.largeImageKey, presence.largeImageKey) && Objects.equals(this.largeImageText, presence.largeImageText) && Objects.equals(this.smallImageKey, presence.smallImageKey) && Objects.equals(this.smallImageText, presence.smallImageText) && Objects.equals(this.partyId, presence.partyId) && Objects.equals(this.matchSecret, presence.matchSecret) && Objects.equals(this.joinSecret, presence.joinSecret) && Objects.equals(this.spectateSecret, presence.spectateSecret);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.state, this.details, this.startTimestamp, this.endTimestamp, this.largeImageKey, this.largeImageText, this.smallImageKey, this.smallImageText, this.partyId, this.partySize, this.partyMax, this.matchSecret, this.joinSecret, this.spectateSecret, this.instance);
    }

    @Override
    protected List<String> getFieldOrder() {
        return FIELD_ORDER;
    }

    public static void updateStatus() {
        if (Main.presence == null) {
            return;
        }
        if (Main.enumos == Util.EnumOS.WINDOWS) {
            String topLine;
            boolean inHub = ClientUtils.checkInHub();
            long time = System.currentTimeMillis() / 1000L - Main.presence.startTimestamp;
            int level = BridgeUtils.getLevel();
            if (!GuiRender.serverName.equals("N/A")) {
                if (GuiRender.questName != null && !GuiRender.questName.equalsIgnoreCase("Removed")) {
                    topLine = "Quest: " + GuiRender.questName;
                } else if (GuiRender.chalStatus != null && !GuiRender.chalStatus.contains("inActive") && GuiRender.chalName != null) {
                    topLine = "Challengers: " + GuiRender.chalName + " " + GuiRender.chalCount;
                } else if (Main.mc.field_71462_r instanceof ChallengerStage) {
                    topLine = "Challengers: Stage Selection";
                } else if (Main.mc.field_71462_r instanceof ChallengerSelection) {
                    topLine = "Challengers: Enemy Selection";
                } else if (JRMCoreH.Accepted == 0) {
                    topLine = "Creating a Character";
                } else if (Main.mc.field_71462_r instanceof HairEditor) {
                    topLine = "In the Hair Editor";
                } else if (Main.mc.field_71462_r instanceof GuiCustomDeath) {
                    topLine = "On the Death Screen...";
                } else if (GuiRender.worldName.equalsIgnoreCase("Wild")) {
                    topLine = "In the Wild World (Factions / Survival)";
                } else if (time % 30L <= 10L && !inHub && level > 0) {
                    topLine = EnumChatFormatting.func_110646_a((String)BridgeUtils.getRaceName((int)JRMCoreH.Race, (boolean)false)) + ", " + EnumChatFormatting.func_110646_a((String)BridgeUtils.getClassName((int)JRMCoreH.Class, (boolean)true)) + " | Level: " + Methods.numSep((int)level);
                } else if (time % 30L <= 20L) {
                    String newServer = !GuiRender.serverName.contains("Instance") ? GuiRender.serverName + " Server" : GuiRender.serverName;
                    topLine = "Logged onto " + (inHub ? "Hub" : newServer);
                } else {
                    topLine = ClientUtils.buildVersionString(Main.version, Main.build) + (Main.devBuild ? " | Development Build" : "");
                }
            } else {
                topLine = "On the Main Menu | " + ClientUtils.buildVersionString(Main.version, Main.build);
            }
            String bottomLine = GuiRender.characterSlot != -1 && !inHub ? "User: " + Main.mc.func_110432_I().func_111285_a() + " | Slot #" + GuiRender.characterSlot : "User: " + Main.mc.func_110432_I().func_111285_a();
            if (topLine != null && !Main.presence.details.equals(topLine)) {
                Main.presence.details = topLine;
                DiscordRPC.INSTANCE.Discord_UpdatePresence(Main.presence);
            }
            if (bottomLine != null && !Main.presence.state.equals(bottomLine)) {
                Main.presence.state = bottomLine;
                DiscordRPC.INSTANCE.Discord_UpdatePresence(Main.presence);
            }
        }
    }
}

