/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.GUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiColor;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.FileWalker;

public class EditorInterface
extends JFrame
implements ActionListener {
    private JFrame frame;
    private JPanel panel;
    private ArrayList<JLabel> testVariablePanels = new ArrayList();
    private ArrayList<JLabel> colorCodePanels = new ArrayList();
    JLabel addMore;
    private int increaseFactor = 0;
    public static boolean openOnLaunch = false;
    static boolean hasOpened = false;

    public EditorInterface() {
        int i;
        this.frame = new JFrame();
        this.frame.setSize(500, 800);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle("Editor Interface");
        this.panel = new JPanel();
        this.frame.add(this.panel);
        this.panel.setLayout(null);
        if (this.testVariablePanels.size() < 12) {
            for (i = 0; i <= 12; ++i) {
                double value = SUBEvents.testVariables.get(i);
                this.testVariablePanels.add(i, new JLabel("Variable #" + i + ": " + value));
            }
        }
        for (i = 0; i <= 12; ++i) {
            final int finalI = i;
            JButton button1 = new JButton("-");
            button1.setText("tv-" + i);
            button1.addActionListener(this);
            button1.setBounds(165, 55 + i * 40, 50, 30);
            this.panel.add(button1);
            JButton button2 = new JButton("+");
            button2.setText("tv+" + i);
            button2.addActionListener(this);
            button2.setBounds(220, 55 + i * 40, 50, 30);
            this.panel.add(button2);
            double value = SUBEvents.testVariables.get(i);
            this.testVariablePanels.set(i, new JLabel("Variable #" + i + ": " + value));
            this.testVariablePanels.get(i).setBounds(10, 55 + i * 40, 200, 30);
            this.panel.add(this.testVariablePanels.get(i));
            final JTextField textField = new JTextField(20);
            textField.setFont(textField.getFont().deriveFont(12.0f));
            textField.setToolTipText("Directly set Test Variable #" + i);
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    String content = textField.getText();
                    if (Methods.isFloateric((String)content)) {
                        SUBEvents.testVariables.set(finalI, Double.valueOf(content));
                        ((JLabel)EditorInterface.this.testVariablePanels.get(finalI)).setText("Variable #" + finalI + ": " + Double.valueOf(content));
                    }
                }
            });
            textField.setBounds(275, 55 + i * 40, 50, 30);
            this.panel.add(textField);
        }
        JButton buttonMore1 = new JButton("-");
        buttonMore1.setText("buttonMore1");
        buttonMore1.addActionListener(this);
        buttonMore1.setBounds(165, 575, 50, 30);
        this.panel.add(buttonMore1);
        JButton buttonMore2 = new JButton("+");
        buttonMore2.setText("buttonMore2");
        buttonMore2.addActionListener(this);
        buttonMore2.setBounds(220, 575, 50, 30);
        this.panel.add(buttonMore2);
        this.addMore = new JLabel("Add More Factor: " + this.getIncreaseFactor());
        this.addMore.setBounds(10, 575, 200, 30);
        this.panel.add(this.addMore);
        if (this.colorCodePanels.size() < GuiColor.colorCodes.size()) {
            for (int i2 = 0; i2 < GuiColor.colorCodes.size(); ++i2) {
                double value = GuiColor.colorCodes.get(i2).intValue();
                this.colorCodePanels.add(i2, new JLabel("Color Code #" + i2 + ": 0x" + value));
            }
        }
        for (int i3 = 0; i3 < GuiColor.colorCodes.size(); ++i3) {
            final int finalI = i3;
            int value = GuiColor.colorCodes.get(i3);
            this.colorCodePanels.set(i3, new JLabel("Color Code #" + i3 + ": 0x" + value));
            this.colorCodePanels.get(i3).setBounds(10, 635 + i3 * 40, 200, 30);
            this.panel.add(this.colorCodePanels.get(i3));
            final JTextField textField = new JTextField(20);
            textField.setFont(textField.getFont().deriveFont(12.0f));
            textField.setToolTipText("Directly set Color Code #" + i3);
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    String content = textField.getText();
                    GuiColor.setColor(finalI, content);
                    ((JLabel)EditorInterface.this.colorCodePanels.get(finalI)).setText("Color Code #" + finalI + ": 0x" + content);
                }
            });
            textField.setBounds(275, 635 + i3 * 40, 100, 30);
            this.panel.add(textField);
        }
        this.frame.setVisible(true);
    }

    double getIncreaseFactor() {
        return this.increaseFactor == -3 ? 0.01 : (this.increaseFactor == -2 ? 0.05 : (this.increaseFactor == -1 ? 0.1 : (this.increaseFactor == -1 ? 0.5 : (this.increaseFactor == 0 ? 1.0 : (this.increaseFactor == 1 ? 5.0 : (this.increaseFactor == 2 ? 10.0 : (this.increaseFactor == 3 ? 50.0 : (this.increaseFactor == 4 ? 100.0 : 1.0))))))));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double value;
        int finalI;
        JButton button = (JButton)e.getSource();
        if (button.getText().contains("tv-")) {
            finalI = Integer.parseInt(button.getText().split("tv-")[1]);
            value = SUBEvents.testVariables.get(finalI) - this.getIncreaseFactor();
            SUBEvents.testVariables.set(finalI, value);
            FileWalker.generateTestVariables(12);
            this.testVariablePanels.get(finalI).setText("Variable #" + finalI + ": " + value);
        }
        if (button.getText().contains("tv+")) {
            finalI = Integer.parseInt(button.getText().split("tv+")[1]);
            value = SUBEvents.testVariables.get(finalI) + this.getIncreaseFactor();
            SUBEvents.testVariables.set(finalI, value);
            FileWalker.generateTestVariables(12);
            this.testVariablePanels.get(finalI).setText("Variable #" + finalI + ": " + value);
        }
        if (button.getText().equals("buttonMore1")) {
            --this.increaseFactor;
            if (this.increaseFactor < -3) {
                this.increaseFactor = 4;
            }
            this.addMore.setText("Add More Factor: " + this.getIncreaseFactor());
        }
        if (button.getText().equals("buttonMore2")) {
            ++this.increaseFactor;
            if (this.increaseFactor > 4) {
                this.increaseFactor = 0;
            }
            this.addMore.setText("Add More Factor: " + this.getIncreaseFactor());
        }
    }

    public static void loadEditor() {
        if (openOnLaunch && hasOpened) {
            return;
        }
        new EditorInterface();
        hasOpened = true;
    }

    public static void main(String[] args) {
        EditorInterface.loadEditor();
    }
}

