/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.GUI;

import java.util.ArrayList;
import java.util.stream.IntStream;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ExtendedPlayer;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CustomButton;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CustomGuiButton;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CustomSlider;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.OnScreen.OnScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.CharacterUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.FileWalker;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class HairEditor
extends GuiScreen {
    public static int curPage = 0;
    public static int piecePage = 0;
    public static int pageCount = 4;
    public static String hairCode;
    public static String hairCodeBefore;
    public static String hairCodeSaved;
    public static String lastHairTexture;
    public static int curPiece;
    public static int lastPiece;
    public static boolean repeatChanges;
    public static boolean mirrorChanges;
    public static ArrayList<Integer> selectedPieces;
    public static ArrayList<Integer> preMirrorPieces;
    public static ArrayList<Integer> selectedMirrorPieces;
    static boolean isDraggingCharacter;
    static float characterYaw;
    static float startCharacterYaw;
    static float finishCharacterYaw;
    static float characterPitch;
    static float startCharacterPitch;
    static float finishCharacterPitch;
    public static int[] hairSideCount;
    String[] hairSideName = new String[]{"Front Side", "Right Side", "Left Side", "Back Side", "Top Side"};
    CustomSlider sliderLength;
    CustomSlider sliderPosX;
    CustomSlider sliderPosY;
    CustomSlider sliderPosZ;
    float sliderLengthValue;
    float sliderPosXValue;
    float sliderPosYValue;
    float sliderPosZValue;
    static int lastLength;
    CustomSlider sliderBend;
    CustomSlider sliderBendPoint;
    CustomSlider sliderShapeChange;
    float sliderBendValue;
    float sliderBendPointValue;
    float sliderShapeChangeValue;
    CustomButton presetButton = null;
    public static boolean isOpen;
    public static boolean reOpen;
    public static boolean fromCharacterCreation;
    public static float displayScaleX;
    public static float displayScaleUpX;
    public static float displayScaleY;
    public static float displayScaleUpY;
    static int mouseX;
    static int mouseY;
    public static double windowWidth;
    public static double windowHeight;
    double posX = 100.0;
    double posY = 100.0;
    double posXPiece = 187.0;
    double posXLeft = 100.0;
    double posXRight = 600.0;
    double posXEditor = 342.0;
    double posYEditor = 220.0;
    boolean debug = false;
    String texturePath = "dbapollo:textures/gui/menus/characterCreation/";
    static String message;
    static long messageTime;

    public void func_73866_w_() {
        super.func_73866_w_();
        if (mouseX != 0 && mouseY != 0) {
            Mouse.setCursorPosition((int)mouseX, (int)mouseY);
        }
        displayScaleX = OnScreen.getScreenScaleWidth();
        displayScaleUpX = (float)Math.pow(displayScaleX, -1.0);
        displayScaleY = OnScreen.getScreenScaleHeight();
        displayScaleUpY = (float)Math.pow(displayScaleY, -1.0);
        OnScreen.getScreenSize(this.field_146294_l, this.field_146295_m, 1);
        CharacterCreation.realWidth = OnScreen.realWidth;
        CharacterCreation.offsetWidth = OnScreen.offsetWidth;
        windowWidth = (float)CharacterCreation.realWidth * displayScaleUpX;
        windowHeight = (float)this.field_146295_m * displayScaleUpY;
        this.posXPiece = windowWidth * 0.219;
        this.posXLeft = windowWidth * 0.2;
        this.posXRight = windowWidth * 0.706;
        this.posXEditor = windowWidth * 0.412;
        this.posYEditor = windowHeight * 0.481;
        isOpen = true;
        CharacterCreation.isOpen = true;
        if (hairCode == null) {
            ExtendedPlayer extendedPlayer = ExtendedPlayer.get((EntityPlayer)Main.mc.field_71439_g);
            hairCode = extendedPlayer.getHairCode();
        }
        if (!reOpen) {
            hairCodeSaved = hairCode;
            repeatChanges = false;
            mirrorChanges = false;
            if (CharacterUtils.raceHasHair(CharacterUtils.getRace())) {
                this.refreshSelectedPieces(true);
                FileWalker.saveHairPreset(true, false);
            }
            CharacterCreation.formToggle = false;
            CharacterCreation.defaultFormPreview();
        }
        if (reOpen) {
            reOpen = false;
        }
        this.addButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            Main.mc.field_71439_g.func_71053_j();
            if (fromCharacterCreation) {
                fromCharacterCreation = false;
                CharacterCreation.page = 2;
                CharacterUtils.setToFirstColPage();
                CharacterCreation.forceReopen = true;
                CharacterCreation.reopen();
            }
            return;
        }
        if (button.field_146127_k == -1 && curPage > 0 || button.field_146127_k == 1 && curPage < pageCount) {
            curPage += button.field_146127_k == 1 ? 1 : -1;
            this.pageChange();
        }
        if (button.field_146127_k == 2) {
            int n = piecePage = piecePage == 0 ? 1 : 0;
        }
        if (button.field_146127_k == 3) {
            boolean bl = repeatChanges = !repeatChanges;
            if (repeatChanges) {
                lastPiece = curPiece;
            } else {
                curPiece = lastPiece;
                this.refreshSelectedPieces(false);
            }
            selectedPieces.set(curPiece, 1);
        }
        if (button.field_146127_k == 4) {
            boolean bl = mirrorChanges = !mirrorChanges;
            if (mirrorChanges) {
                for (int face2 = 0; face2 < selectedPieces.size(); ++face2) {
                    int faceToggle = selectedPieces.get(face2);
                    if (faceToggle != 1) continue;
                    int mirrorFace = HairEditor.getMirroredPiece(face2, true);
                    HairEditor.copyPiece(face2, mirrorFace);
                    selectedMirrorPieces.set(mirrorFace, faceToggle);
                }
            }
        }
        if (button.field_146127_k == 5 || button.field_146127_k == 6) {
            if (button.field_146127_k == 5) {
                repeatChanges = true;
            }
            IntStream.range(hairSideCount[button.field_146127_k == 6 ? 0 : curPage], hairSideCount[button.field_146127_k == 6 ? 5 : curPage + 1]).forEach(face -> selectedPieces.set(face, button.field_146127_k == 5 ? 1 : 0));
            if (button.field_146127_k == 6) {
                IntStream.range(hairSideCount[0], hairSideCount[5]).forEach(face -> selectedMirrorPieces.set(face, 0));
                selectedPieces.set(curPiece, 1);
            }
            mirrorChanges = false;
        }
        if (button.field_146127_k == 7) {
            FileWalker.setClipboardContents(hairCode);
        }
        if (button.field_146127_k == 8) {
            hairCode = FileWalker.getClipboardContents();
            hairCode = HairEditor.dnsHairG1toG2(hairCode);
            HairEditor.validateHairCode();
        }
        if (button.field_146127_k == 9) {
            hairCode = hairCodeSaved;
        }
        if (button.field_146127_k == 14) {
            boolean bl = CharacterCreation.formToggle = !CharacterCreation.formToggle;
            if (!CharacterCreation.formToggle) {
                CharacterCreation.defaultFormPreview();
            }
        }
        if (button.field_146127_k == 15 && CharacterCreation.formPage > 0 || button.field_146127_k == 16 && CharacterCreation.formPage < CharacterCreation.formPageLimit) {
            CharacterCreation.formPage += button.field_146127_k == 16 ? 1 : -1;
        }
        if (button.field_146127_k == 17 || button.field_146127_k == 18) {
            CharacterCreation.walkThroughOpen = false;
            CharacterCreation.showingWalkThrough = false;
            if (button.field_146127_k == 17) {
                CharacterCreation.fromHairEditor = true;
                CharacterCreation.page = 2;
                CharacterUtils.setToFirstColPage();
                CharacterUtils.setCharacterCreationData();
            } else {
                HairEditor.setMessage("The Hair User Presets have been disabled, these will return once we get a chance to resolve some bugs!", true);
            }
            if (button.field_146127_k == 17) {
                Main.mc.field_71439_g.func_71053_j();
                CharacterCreation.reopen();
            }
            return;
        }
        if (button.field_146127_k >= 20 && button.field_146127_k < 30) {
            int result = button.field_146127_k - 20;
            CharacterCreation.formPreviewSelected(result);
        }
        if (button.field_146127_k >= 100 && button.field_146127_k < 200) {
            curPiece = button.field_146127_k - 100;
            if (!repeatChanges) {
                this.refreshSelectedPieces(false);
            }
            selectedPieces.set(curPiece, !repeatChanges || selectedPieces.get(curPiece) == 0 ? 1 : 0);
            mirrorChanges = false;
            lastLength = 1;
        }
        if (button.field_146127_k >= 200 && button.field_146127_k < 1100 && hairCode.length() > 3) {
            this.changeHairValues(button.field_146127_k);
        }
        if (button.field_146127_k < 200 || button.field_146127_k >= 900) {
            mouseX = Mouse.getX();
            mouseY = Mouse.getY();
            reOpen = true;
            Main.mc.func_147108_a((GuiScreen)new HairEditor());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-900.0f);
        RenderUtils.bindTexture(this.texturePath + "background.jpg");
        RenderUtils.drawCompleteImage(0.0, 0.0, this.field_146294_l, this.field_146295_m);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)displayScaleX, (float)displayScaleY, (float)1.0f);
        this.drawHairEditor(mouseX, mouseY);
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, f);
        RenderUtils.renderDetails(mouseX, mouseY, this.field_146289_q);
    }

    void addButtons() {
        this.field_146292_n.clear();
        if (this.debug) {
            System.out.println("drawHairEditor: curPage: " + curPage);
        }
        if (this.debug) {
            System.out.println("width: " + windowWidth + " | " + windowHeight);
        }
        float scale = 1.775f;
        float scale2 = 1.25f;
        float scaleUp = (float)Math.pow(scale, -1.0);
        float scaleUp2 = (float)Math.pow(scale2, -1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i8 = 0;
        String text = null;
        int textLength = 0;
        int[][] posH = new int[][]{{0, 1, 2, 3, 0, 1, 2, 0, 1, 0}, {0, 1, 2, 3, 1, 2, 3, 2, 3, 3}, {3, 2, 1, 0, 3, 2, 1, 0, 3, 2, 1, 0, 3, 2, 1, 0}, {0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3}};
        int[][] posV = new int[][]{{0, 0, 0, 0, 1, 1, 1, 2, 2, 3}, {0, 0, 0, 0, 1, 1, 1, 2, 2, 3}, {0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3}, {3, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0}};
        if (CharacterUtils.raceHasHair(CharacterUtils.getRace())) {
            if (hairCode == null) {
                HairEditor.setMessage("Please try to reopen the Hair Editor to load your Hair", false);
            }
        } else {
            HairEditor.setMessage("This race cannot edit their Head Piece, you can however change your Selection below.", false);
        }
        if (hairCode != null && hairCode.length() == 786 && CharacterUtils.raceHasHair(CharacterUtils.getRace())) {
            int hid = hairSideCount[curPage] * 10;
            int row = 0;
            int column = 0;
            int entry = 0;
            if (curPiece != -1) {
                text = EnumChatFormatting.YELLOW + "Select All";
                this.field_146292_n.add(new CustomGuiButton(5, this.posXLeft, this.posY, 80.0, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.GRAY + "Unselect All";
                this.field_146292_n.add(new CustomGuiButton(6, this.posXLeft, this.posY + 25.0, 80.0, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.GOLD + (piecePage == 0 ? "Advanced" : "Basic");
                this.field_146292_n.add(new CustomGuiButton(2, this.posXEditor - 20.0, this.posYEditor + 15.0, 60.0, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.BLUE + "Hide";
                this.field_146292_n.add(new CustomGuiButton(900 + curPiece, this.posXEditor - 20.0 + 65.0, this.posYEditor + 15.0, 60.0, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.RED + "Reset";
                this.field_146292_n.add(new CustomGuiButton(1000 + curPiece, this.posXEditor - 20.0 + 130.0, this.posYEditor + 15.0, 60.0, 20.0, text, this, displayScaleX, displayScaleY));
                if (piecePage == 0) {
                    int hairX = HairEditor.dnsHair2(hairCode, curPiece * 14 + 2);
                    int hairY = HairEditor.dnsHair2(hairCode, curPiece * 14 + 4);
                    int hairZ = HairEditor.dnsHair2(hairCode, curPiece * 14 + 6);
                    int hairLength = HairEditor.dnsHair2(hairCode, curPiece * 14);
                    hairX = HairEditor.validateHairPos(hairX);
                    hairY = HairEditor.validateHairPos(hairY);
                    hairZ = HairEditor.validateHairPos(hairZ);
                    float pieceLength = (float)hairLength / 2.8f / 36.0f;
                    float pieceX = this.getHairPosDecimal(hairX - 50);
                    float pieceY = this.getHairPosDecimal(hairY - 50);
                    float pieceZ = this.getHairPosDecimal(hairZ - 50);
                    double posXSlider = this.posXEditor + 2.0;
                    double posYSlider = this.posYEditor;
                    this.sliderLength = new CustomSlider(200 + curPiece, posXSlider, posYSlider + 45.0, "Length", pieceLength, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderLength);
                    this.sliderPosX = new CustomSlider(300 + curPiece, posXSlider, posYSlider + 70.0, "Rotation hair X", pieceX, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderPosX);
                    this.sliderPosY = new CustomSlider(400 + curPiece, posXSlider, posYSlider + 95.0, "Rotation hair Y", pieceY, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderPosY);
                    this.sliderPosZ = new CustomSlider(500 + curPiece, posXSlider, posYSlider + 120.0, "Rotation hair Z", pieceZ, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderPosZ);
                } else if (piecePage == 1) {
                    int hairBend = HairEditor.dnsHair2(hairCode, curPiece * 14 + 8);
                    int hairBendPoint = HairEditor.dnsHair2(hairCode, curPiece * 14 + 10);
                    int hairShape = HairEditor.dnsHair2(hairCode, curPiece * 14 + 12);
                    hairBend = HairEditor.validateHairPos(hairBend);
                    hairBendPoint = HairEditor.validateHairPos(hairBendPoint);
                    hairShape = HairEditor.validateHairPos(hairShape);
                    float pieceBend = this.getHairPosDecimal(hairBend - 50);
                    float pieceBendPoint = this.getHairPosDecimal(hairBendPoint - 50);
                    float pieceShapeChange = this.getHairPosDecimal(hairShape - 50);
                    this.sliderBend = new CustomSlider(600 + curPiece, this.posXEditor, this.posYEditor + 45.0, "Bend", pieceBend, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderBend);
                    this.sliderBendPoint = new CustomSlider(700 + curPiece, this.posXEditor, this.posYEditor + 70.0, "Bend Point", pieceBendPoint, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderBendPoint);
                    this.sliderShapeChange = new CustomSlider(800 + curPiece, this.posXEditor, this.posYEditor + 95.0, "Shape Change", pieceShapeChange, 0.0f, 1.0f, this);
                    this.field_146292_n.add(this.sliderShapeChange);
                }
                text = !repeatChanges ? EnumChatFormatting.DARK_GREEN + "Repeat Changes" : EnumChatFormatting.YELLOW + "Repeat Changes";
                this.field_146292_n.add(new CustomGuiButton(3, this.posXEditor - 17.0, this.posYEditor + (double)(piecePage == 0 ? 140 : 115), 90.0, 20.0, text, this, displayScaleX, displayScaleY));
                text = !mirrorChanges ? EnumChatFormatting.BLUE + "Mirror Changes" : EnumChatFormatting.AQUA + "Mirror Changes";
                this.field_146292_n.add(new CustomGuiButton(4, this.posXEditor - 17.0 + 95.0, this.posYEditor + (double)(piecePage == 0 ? 140 : 115), 90.0, 20.0, text, this, displayScaleX, displayScaleY));
            }
            for (int face = hairSideCount[curPage]; face < hairSideCount[curPage + 1]; ++face) {
                int l6 = HairEditor.dnsHair2(hairCode, face * 14);
                int X = HairEditor.dnsHair2(hairCode, face * 14 + 2);
                int Y = HairEditor.dnsHair2(hairCode, face * 14 + 4);
                int Z = HairEditor.dnsHair2(hairCode, face * 14 + 6);
                int B = HairEditor.dnsHair2(hairCode, face * 14 + 8);
                int P = HairEditor.dnsHair2(hairCode, face * 14 + 10);
                int T = HairEditor.dnsHair2(hairCode, face * 14 + 12);
                X = HairEditor.validateHairPos(X);
                Y = HairEditor.validateHairPos(Y);
                Z = HairEditor.validateHairPos(Z);
                B = HairEditor.validateHairPos(B);
                P = HairEditor.validateHairPos(P);
                T = HairEditor.validateHairPos(T);
                int x2 = X - 50;
                int y2 = Y - 50;
                int z2 = Z - 50;
                int b2 = B - 50;
                int p3 = P - 50;
                int t2 = T - 50;
                int L2 = (int)((float)l6 / 2.8f) + 1;
                X = (int)((float)(X - 18) * 1.56f);
                Y = (int)((float)(Y - 18) * 1.56f);
                Z = (int)((float)(Z - 18) * 1.56f);
                B = (int)((float)(B - 18) * 1.56f);
                P = (int)((float)(P - 18) * 1.56f);
                T = (int)((float)(T - 18) * 1.56f);
                int offsetX = curPage == 0 ? row : posH[curPage - 1][entry];
                int offsetY = curPage == 0 ? column : posV[curPage - 1][entry];
                text = EnumChatFormatting.GRAY + "Piece #" + (face + 1);
                this.field_146292_n.add(new CustomGuiButton(100 + face, this.posXPiece + 92.0 + (double)(offsetX * 75), this.posY + (double)(offsetY * 25), 70.0, 20.0, text, this, !repeatChanges && curPiece == face || HairEditor.isSelected(face), displayScaleX, displayScaleY));
                ++entry;
                if (++row > 3) {
                    ++column;
                }
                row = row > 3 ? 0 : row;
            }
            ++hid;
            this.field_146292_n.add(new CustomButton(-1, this.posXPiece - 7.0, this.posY - 62.5, 84, 0, 16.0, 13.0, this.texturePath + "arrows.png", scale));
            this.field_146292_n.add(new CustomButton(1, this.posXPiece + 97.0, this.posY - 62.5, 100, 0, 16.0, 13.0, this.texturePath + "arrows.png", scale));
            i8 = 0;
            if (!CharacterCreation.formToggle) {
                text = EnumChatFormatting.YELLOW + "Copy Hair Code";
                textLength = this.field_146289_q.func_78256_a(text) + 8;
                this.field_146292_n.add(new CustomGuiButton(7, this.posXRight, this.posY + (double)(i8 * 25), textLength, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.GREEN + "Paste Hair Code";
                textLength = this.field_146289_q.func_78256_a(text) + 8;
                this.field_146292_n.add(new CustomGuiButton(8, this.posXRight, this.posY + (double)(++i8 * 25), textLength, 20.0, text, this, displayScaleX, displayScaleY));
                text = EnumChatFormatting.RED + "Revert Changes";
                textLength = this.field_146289_q.func_78256_a(text) + 8;
                this.field_146292_n.add(new CustomGuiButton(9, this.posXRight, this.posY + (double)(++i8 * 25), textLength, 20.0, text, this, displayScaleX, displayScaleY));
                ++i8;
                ++i8;
                ++i8;
            }
        }
        if (!fromCharacterCreation) {
            text = EnumChatFormatting.BLUE + "Change Hair Selection";
            textLength = this.field_146289_q.func_78256_a(text) + 8;
            this.field_146292_n.add(new CustomGuiButton(17, this.posXRight, this.posY + 235.0, textLength, 20.0, text, this, displayScaleX, displayScaleY));
        }
        text = fromCharacterCreation ? EnumChatFormatting.DARK_GREEN + "Back to Character Creation" : EnumChatFormatting.GREEN + "Done Editing Hair";
        textLength = this.field_146289_q.func_78256_a(text) + 8;
        this.field_146292_n.add(new CustomGuiButton(0, this.posXRight, this.posY + 260.0, textLength, 20.0, text, this, displayScaleX, displayScaleY));
        this.presetButton = new CustomButton(18, windowWidth * 0.101, windowHeight * 0.005, 142, 0, 10.0, 10.0, this.texturePath + "arrows.png", scale);
        this.field_146292_n.add(this.presetButton);
    }

    void drawHairEditor(int mouseX, int mouseY) {
        if (this.debug) {
            System.out.println("drawHairEditor: curPage: " + curPage);
        }
        if (this.debug) {
            System.out.println("width: " + windowWidth + " | " + windowHeight);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scale = (int)(125.0f * displayScaleUpY);
        RenderUtils.drawCharacterHeadHair(windowWidth * 0.247, windowHeight * 1.3, scale, CharacterCreation.realWidth, characterYaw, characterPitch, (EntityLivingBase)Main.mc.field_71439_g, curPage);
        int i8 = 0;
        String text = null;
        String textDesc = null;
        if (!CharacterUtils.raceHasHair(CharacterUtils.getRace())) {
            HairEditor.setMessage("This race cannot edit their Head Piece, you can however change your Selection, with the button below.", true);
        }
        if (hairCode != null && hairCode.length() == 786 && CharacterUtils.raceHasHair(CharacterUtils.getRace())) {
            text = EnumChatFormatting.GREEN + "Viewing " + this.hairSideName[curPage] + " of Head";
            RenderUtils.drawBasicText(Main.mc, text, windowWidth * 0.5, windowHeight * 0.165, true, 1);
            text = repeatChanges ? EnumChatFormatting.AQUA + "Editing Pieces on " + this.hairSideName[curPage] + " of Head" : EnumChatFormatting.AQUA + "Editing Piece #" + (curPiece + 1) + (mirrorChanges ? " & Mirrored" : "");
            RenderUtils.drawBasicText(Main.mc, text, windowWidth * 0.5, windowHeight * (repeatChanges || mirrorChanges ? 0.451 : 0.48), true, 1);
            if (repeatChanges || mirrorChanges) {
                text = EnumChatFormatting.GRAY + "You can select more than one Hair Piece above";
                RenderUtils.drawBasicText(Main.mc, text, windowWidth * 0.5, windowHeight * 0.48, true, 1);
            }
            text = EnumChatFormatting.GRAY + "The Yellow indicates selected Hair Pieces";
            RenderUtils.drawScaledText(Main.mc, text, 0.7f, windowWidth * 0.247, windowHeight * 0.75, true, 1);
            if (piecePage == 0) {
                if (this.sliderLength != null) {
                    this.sliderLengthValue = this.sliderLength.sliderValue;
                }
                if (this.sliderLength.dragging) {
                    this.changeHairValues(200);
                }
                if (this.sliderPosX != null) {
                    this.sliderPosXValue = this.sliderPosX.sliderValue;
                }
                if (this.sliderPosX.dragging) {
                    this.changeHairValues(300);
                }
                if (this.sliderPosY != null) {
                    this.sliderPosYValue = this.sliderPosY.sliderValue;
                }
                if (this.sliderPosY.dragging) {
                    this.changeHairValues(400);
                }
                if (this.sliderPosZ != null) {
                    this.sliderPosZValue = this.sliderPosZ.sliderValue;
                }
                if (this.sliderPosZ.dragging) {
                    this.changeHairValues(500);
                }
            } else if (piecePage == 1) {
                if (this.sliderBend != null) {
                    this.sliderBendValue = this.sliderBend.sliderValue;
                }
                if (this.sliderBend.dragging) {
                    this.changeHairValues(600);
                }
                if (this.sliderBendPoint != null) {
                    this.sliderBendPointValue = this.sliderBendPoint.sliderValue;
                }
                if (this.sliderBendPoint.dragging) {
                    this.changeHairValues(700);
                }
                if (this.sliderShapeChange != null) {
                    this.sliderShapeChangeValue = this.sliderShapeChange.sliderValue;
                }
                if (this.sliderShapeChange.dragging) {
                    this.changeHairValues(800);
                }
            }
            i8 = 0;
            if (!CharacterCreation.formToggle) {
                text = "Copy Hair Code";
                textDesc = "Copy the current Hair into a code format, helpful for sharing";
                int textLength = this.field_146289_q.func_78256_a(text) + 9;
                RenderUtils.drawDetails(this.field_146289_q, "", textDesc, this.posXRight + 2.0, this.posY + (double)(i8 * 25) + 2.0, mouseX, mouseY, textLength, 22.0, 0.0);
                text = "Paste Hair Code";
                textDesc = "Paste a Hair Code from your clipboard";
                textLength = this.field_146289_q.func_78256_a(text) + 9;
                RenderUtils.drawDetails(this.field_146289_q, "", textDesc, this.posXRight + 2.0, this.posY + (double)(++i8 * 25) + 2.0, mouseX, mouseY, textLength, 22.0, 0.0);
                text = "Revert Changes";
                textDesc = "Revert changes made since you started";
                textLength = this.field_146289_q.func_78256_a(text) + 9;
                RenderUtils.drawDetails(this.field_146289_q, "", textDesc, this.posXRight + 2.0, this.posY + (double)(++i8 * 25) + 2.0, mouseX, mouseY, textLength, 22.0, 0.0);
                ++i8;
            }
        }
        if (this.presetButton != null) {
            text = (this.presetButton.buttonState == 1 ? EnumChatFormatting.YELLOW : EnumChatFormatting.GRAY) + "Save or Load a Created Hair";
            RenderUtils.drawScaledText(this.field_146297_k, text, 0.6 * (double)displayScaleY, windowWidth * 0.19, windowHeight * 0.052, false, 1);
        }
        float timeSince = ClientUtils.getTimeSince(messageTime);
        float duration = 5000.0f;
        if (message != null && timeSince <= duration) {
            RenderUtils.drawDurationMessage(Main.mc, message, 0.6, windowWidth / 2.0, this.posY + 65.0, duration, timeSince);
        }
    }

    void changeHairValues(int buttonID) {
        int otherFace;
        int otherFace2;
        int dataFactor;
        hairCodeBefore = hairCode;
        int face = curPiece;
        int length = HairEditor.dnsHair2(hairCode, face * 14);
        int sliderID = (buttonID -= 200) / 100;
        if (this.debug) {
            System.out.println("face: " + face + " | l: " + length + " | sliderID " + sliderID);
        }
        if (sliderID == 0) {
            String valueString;
            int valueSet = HairEditor.validateHairLength(this.getHairLengthValue(this.sliderLengthValue));
            String string = valueString = valueSet < 10 ? "0" + valueSet : "" + valueSet;
            if (this.debug) {
                System.out.println("valueString: " + valueString + " | valueSet: " + valueSet);
            }
            for (int otherFace3 = hairSideCount[0]; otherFace3 < hairSideCount[5]; ++otherFace3) {
                if (HairEditor.isSelected(otherFace3)) {
                    face = otherFace3;
                }
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14, valueString);
                HairEditor.validateHairCode();
                if (!repeatChanges && !mirrorChanges) break;
            }
        }
        if (sliderID >= 1 && sliderID <= 3) {
            float valueFactor = sliderID == 1 ? this.sliderPosXValue : (sliderID == 2 ? this.sliderPosYValue : (sliderID == 3 ? this.sliderPosZValue : 0.0f));
            int valueSet = HairEditor.validateHairPos(this.getHairPosValue(valueFactor) + 18);
            if (this.debug) {
                System.out.println("valueFactor: " + valueFactor + " | before: " + this.getHairPosValue(valueFactor) + " | valueSet: " + valueSet);
            }
            dataFactor = sliderID == 1 ? 2 : (sliderID == 2 ? 4 : (sliderID == 3 ? 6 : 0));
            for (otherFace2 = hairSideCount[0]; otherFace2 < hairSideCount[5]; ++otherFace2) {
                boolean mirrorFace;
                if (HairEditor.isSelected(otherFace2)) {
                    face = otherFace2;
                }
                boolean bl = mirrorFace = selectedMirrorPieces.get(otherFace2) == 1;
                if (mirrorFace && (sliderID == 2 || sliderID == 3)) {
                    valueSet = HairEditor.validateHairPosInverted(valueSet);
                }
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + dataFactor, valueSet + "");
                HairEditor.validateHairCode();
                if (!repeatChanges && !mirrorChanges) break;
            }
        }
        if (sliderID >= 4 && sliderID <= 6) {
            float valueFactor = sliderID == 4 ? this.sliderBendValue : (sliderID == 5 ? this.sliderBendPointValue : (sliderID == 6 ? this.sliderShapeChangeValue : 0.0f));
            int valueSet = HairEditor.validateHairPos(this.getHairPosValue(valueFactor) + 18);
            if (this.debug) {
                System.out.println("valueFactor: " + valueFactor + " | before: " + this.getHairPosValue(valueFactor) + " | valueSet: " + valueSet);
            }
            dataFactor = sliderID == 4 ? 8 : (sliderID == 5 ? 10 : (sliderID == 6 ? 12 : 0));
            for (otherFace2 = hairSideCount[0]; otherFace2 < hairSideCount[5]; ++otherFace2) {
                if (HairEditor.isSelected(otherFace2)) {
                    face = otherFace2;
                }
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + dataFactor, valueSet + "");
                HairEditor.validateHairCode();
                if (!repeatChanges && !mirrorChanges) break;
            }
        }
        if (sliderID == 7) {
            for (otherFace = hairSideCount[0]; otherFace < hairSideCount[5]; ++otherFace) {
                if (HairEditor.isSelected(otherFace)) {
                    face = otherFace;
                }
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14, length != 0 ? "00" : "" + lastLength);
                HairEditor.validateHairCode();
                if (!repeatChanges && !mirrorChanges) break;
            }
            if (length != 0) {
                lastLength = length;
            }
        }
        if (sliderID == 8) {
            for (otherFace = hairSideCount[0]; otherFace < hairSideCount[5]; ++otherFace) {
                if (HairEditor.isSelected(otherFace)) {
                    face = otherFace;
                }
                int L = HairEditor.dnsHair2(hairCodeSaved, face * 14);
                int X = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 2);
                int Y = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 4);
                int Z = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 6);
                int B = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 8);
                int P = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 10);
                int T = HairEditor.dnsHair2(hairCodeSaved, face * 14 + 12);
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14, L + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 2, X + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 4, Y + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 6, Z + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 8, B + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 10, P + "");
                hairCode = HairEditor.dnsHair2Set(hairCode, face * 14 + 12, T + "");
                HairEditor.validateHairCode();
                if (!repeatChanges && !mirrorChanges) break;
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int p_146273_3_, long howLong) {
        boolean advancedSliders;
        CharacterUtils.setMouseColorSelection(mouseX, mouseY, CharacterCreation.realWidth, this.field_146295_m);
        int posXMin = (int)(CharacterCreation.offsetWidth + (double)CharacterCreation.realWidth * 0.15);
        int posXMax = (int)(CharacterCreation.offsetWidth + (double)CharacterCreation.realWidth * 0.35);
        int posYMin = (int)((double)this.field_146295_m * 0.35);
        int posYMax = (int)((double)this.field_146295_m * 0.8);
        boolean inBounds = mouseX >= posXMin && mouseY >= posYMin && mouseX <= posXMax && mouseY <= posYMax;
        boolean basicSliders = !(this.sliderLength != null && this.sliderLength.dragging || this.sliderPosX != null && this.sliderPosX.dragging || this.sliderPosY != null && this.sliderPosY.dragging || this.sliderPosZ != null && this.sliderPosZ.dragging);
        boolean bl = advancedSliders = !(this.sliderBend != null && this.sliderBend.dragging || this.sliderBendPoint != null && this.sliderBendPoint.dragging || this.sliderShapeChange != null && this.sliderShapeChange.dragging);
        if ((inBounds || isDraggingCharacter) && basicSliders && advancedSliders) {
            if (mouseX < posXMin - 2) {
                mouseX = posXMin - 2;
            }
            if (mouseY < posYMin - 2) {
                mouseY = posYMin - 2;
            }
            if (mouseX > posXMax + 2) {
                mouseX = posXMax + 2;
            }
            if (mouseY > posYMax + 2) {
                mouseY = posYMax + 2;
            }
            if (mouseX < posXMin - 2 || mouseX > posXMax + 2 || mouseY < posYMin - 2 || mouseY > posYMax + 2) {
                return;
            }
            if (!isDraggingCharacter) {
                isDraggingCharacter = true;
                ClientUtils.setCursor(77);
            }
            float compareXMin = mouseX - posXMin;
            float compareXMax = posXMax - posXMin;
            float compareYMin = mouseY - posYMin;
            float compareYMax = posYMax - posYMin;
            float ratioX = compareXMin / compareXMax;
            float ratioY = compareYMin / compareYMax;
            if (startCharacterYaw == -1.0f) {
                startCharacterYaw = ratioX;
            }
            if (startCharacterPitch == -1.0f) {
                startCharacterPitch = ratioY;
            }
            float resultX = finishCharacterYaw + (ratioX - startCharacterYaw);
            float resultY = finishCharacterPitch + (ratioY - startCharacterPitch);
            float f = resultX < 0.0f ? 0.0f : (resultX = resultX > 1.0f ? 1.0f : resultX);
            resultY = resultY < 0.0f ? 0.0f : (resultY > 1.0f ? 1.0f : resultY);
            characterYaw = resultX * -360.0f + 180.0f;
            characterPitch = resultY * -360.0f + 180.0f;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int p_146286_3_) {
        super.func_146286_b(mouseX, mouseY, p_146286_3_);
        if (isDraggingCharacter) {
            startCharacterYaw = -1.0f;
            startCharacterPitch = -1.0f;
            finishCharacterYaw = characterYaw / -360.0f + 0.5f;
            finishCharacterPitch = characterPitch / -360.0f + 0.5f;
        }
        if (isDraggingCharacter) {
            ClientUtils.setCursor(ApolloConfig.cursorStyle);
            isDraggingCharacter = false;
        }
    }

    void pageChange() {
        this.refreshSelectedPieces(false);
        curPiece = hairSideCount[curPage];
        selectedPieces.set(curPiece, 1);
        lastLength = 1;
        repeatChanges = false;
        mirrorChanges = false;
        characterYaw = curPage == 1 ? -90.0f : (curPage == 2 ? 90.0f : (curPage == 3 ? 180.0f : 0.0f));
        characterPitch = curPage == 4 ? -180.0f : 0.0f;
        finishCharacterYaw = characterYaw / -360.0f + 0.5f;
        finishCharacterPitch = characterPitch / -360.0f + 0.5f;
    }

    void refreshSelectedPieces(boolean firstOpen) {
        selectedPieces.clear();
        IntStream.range(hairSideCount[0], hairSideCount[5]).forEach(face -> selectedPieces.add(face == 0 && firstOpen ? 1 : 0));
        selectedMirrorPieces.clear();
        IntStream.range(hairSideCount[0], hairSideCount[5]).forEach(face -> selectedMirrorPieces.add(0));
    }

    public static boolean isSelected(int face) {
        return CharacterUtils.raceHasHair(CharacterUtils.getRace()) && (repeatChanges && selectedPieces.get(face) != 0 || mirrorChanges && selectedMirrorPieces.get(face) != 0);
    }

    public static int getMirroredPiece(int face, boolean ignorePage) {
        int otherFace = -1;
        if (ignorePage || curPage == 0) {
            int n = face == 0 ? 3 : (face == 1 ? 2 : (face == 2 ? 1 : (otherFace = face == 3 ? 0 : otherFace)));
        }
        if (ignorePage || curPage == 1) {
            int n = face == 4 ? 17 : (face == 5 ? 16 : (face == 6 ? 15 : (face == 7 ? 14 : (face == 8 ? 20 : (face == 9 ? 19 : (face == 10 ? 18 : (face == 11 ? 22 : (face == 12 ? 21 : (otherFace = face == 13 ? 23 : otherFace)))))))));
        }
        if (ignorePage || curPage == 2) {
            int n = face == 17 ? 4 : (face == 16 ? 5 : (face == 15 ? 6 : (face == 14 ? 7 : (face == 20 ? 8 : (face == 19 ? 9 : (face == 18 ? 10 : (face == 22 ? 11 : (face == 21 ? 12 : (otherFace = face == 23 ? 13 : otherFace)))))))));
        }
        if (ignorePage || curPage == 3) {
            int n = face == 27 ? 24 : (face == 26 ? 25 : (face == 25 ? 26 : (face == 24 ? 27 : (face == 31 ? 28 : (face == 30 ? 29 : (face == 29 ? 30 : (face == 28 ? 31 : (face == 35 ? 32 : (face == 34 ? 33 : (face == 33 ? 34 : (face == 32 ? 35 : (face == 39 ? 36 : (face == 38 ? 37 : (face == 37 ? 38 : (otherFace = face == 36 ? 39 : otherFace)))))))))))))));
        }
        if (ignorePage || curPage == 4) {
            otherFace = face == 52 ? 55 : (face == 53 ? 54 : (face == 54 ? 53 : (face == 55 ? 52 : (face == 48 ? 51 : (face == 49 ? 50 : (face == 50 ? 49 : (face == 51 ? 48 : (face == 44 ? 47 : (face == 45 ? 46 : (face == 46 ? 45 : (face == 47 ? 44 : (face == 40 ? 43 : (face == 41 ? 42 : (face == 42 ? 41 : (face == 43 ? 40 : otherFace)))))))))))))));
        }
        return otherFace;
    }

    static void copyPiece(int source, int target) {
        boolean debug = false;
        int sourcePiece = source * 14;
        String sourceData = HairEditor.dnsHair(hairCode, source);
        String targetData = HairEditor.dnsHair(hairCode, target);
        StringBuilder invertedData = new StringBuilder();
        for (int i = 0; i < 7; ++i) {
            if (debug) {
                System.out.println("sourcePiece: " + sourcePiece + " + " + i * 2);
            }
            int value = HairEditor.dnsHair2(hairCode, sourcePiece + i * 2);
            if (debug) {
                System.out.println("#" + i + " start: " + value);
            }
            if (i == 2 || i == 3) {
                value = HairEditor.validateHairPosInverted(value);
                if (debug) {
                    System.out.println("inverted is now: " + value);
                }
            }
            invertedData.append(value < 10 ? "0" + value : "" + value);
            if (!debug) continue;
            System.out.println("#" + i + " added: " + value);
        }
        if (debug) {
            System.out.println("copyPiece: " + source + " _ " + target);
        }
        if (debug) {
            System.out.println("data: " + sourceData + " _ " + targetData + " _ " + invertedData);
        }
        hairCode = HairEditor.dnsHairSet(hairCode, target, invertedData.toString());
    }

    float getHairPosDecimal(float value) {
        return value / 64.0f + 0.5f;
    }

    int getHairPosValue(float value) {
        return (int)(value * 100.0f / 1.56f);
    }

    int getHairLengthValue(float value) {
        return (int)(value * 100.0f);
    }

    public static void validateHairCode() {
        if (hairCode.length() != 786 || hairCode.contains("##")) {
            hairCode = hairCodeBefore;
            HairEditor.setMessage("Hair Code is invalid, reverting changes!", true);
        }
    }

    public static int validateHairPos(int value) {
        return value > 82 ? 82 : Math.max(value, 18);
    }

    static int validateHairPosInverted(int value) {
        return 82 - value + 18;
    }

    public static int validateHairLength(int value) {
        return value > 99 ? 99 : Math.max(value, 1);
    }

    public static String stringAt(String string, int entry) {
        return string.charAt(entry) + "";
    }

    public static String dnsHair(String hairCode, int hairEntry) {
        int hairPiece = hairEntry * 14;
        return hairCode != null ? hairCode.substring(hairPiece, hairPiece + 14) : null;
    }

    public static int dnsHair1(String hairCode, int hairEntry) {
        return hairCode != null && hairCode.length() > hairEntry - 1 ? Integer.parseInt(HairEditor.stringAt(hairCode, hairEntry)) : 0;
    }

    public static int dnsHair2(String hairCode, int hairEntry) {
        return hairCode != null && hairCode.length() > hairEntry ? Integer.parseInt(HairEditor.stringAt(hairCode, hairEntry) + HairEditor.stringAt(hairCode, hairEntry + 1)) : 0;
    }

    public static String dnsHairSet(String hairCode, int hairEntry, String newValue) {
        int hairPiece = hairEntry * 14;
        return hairCode != null ? hairCode.substring(0, hairPiece) + newValue + hairCode.substring(hairPiece + 14) : "0";
    }

    public static String dnsHair2Set(String hairCode, int hairEntry, String newValue) {
        boolean debug = false;
        if (newValue.length() == 1) {
            newValue = "0" + newValue;
        }
        if (debug) {
            System.out.println("hairEntry: " + hairEntry + " | newValue: " + newValue);
        }
        return hairCode != null && hairCode.length() > hairEntry ? hairCode.substring(0, hairEntry) + newValue + hairCode.substring(hairEntry + 2) : "0";
    }

    public static String dnsHairG1toG2(String hairCode) {
        String g2 = "";
        if (hairCode.length() == 392) {
            for (int face = 0; face < 56; ++face) {
                int l = HairEditor.dnsHair1(hairCode, face * 7) * 11 - 10;
                l = Math.max(l, 0);
                int X = HairEditor.dnsHair2(hairCode, face * 7 + 1);
                int Y = HairEditor.dnsHair2(hairCode, face * 7 + 3);
                int Z = HairEditor.dnsHair2(hairCode, face * 7 + 5);
                String L = "" + (l < 10 ? "0" + l : Integer.valueOf(l));
                g2 = g2 + L + "" + X + "" + Y + "" + Z + "505000";
            }
            g2 = g2 + "20";
        } else {
            g2 = hairCode.length() == 784 ? hairCode + "20" : hairCode;
        }
        return g2;
    }

    public static void saveHairCodeServer() {
        HairEditor.saveHairCodeServer(hairCode);
    }

    public static void saveHairCodeServer(String hairCode) {
        BridgePD.tellServer((String)("hairCode:" + hairCode));
        HairEditor.saveHairCodeClient(hairCode);
    }

    public static void saveHairCodeClient(String hairCode) {
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get((EntityPlayer)Main.mc.field_71439_g);
        extendedPlayer.setHairCode(hairCode);
    }

    public static String fusionHairMix(String hairCode, String hairCodePartner, int onlyPart) {
        boolean debug = false;
        if (debug) {
            System.out.println("hairCode: \"" + hairCode + "\"");
        }
        if (debug) {
            System.out.println("hairCodePartner: \"" + hairCodePartner + "\"");
        }
        String hairCodeBlank = "";
        for (int i = 0; i < 56; ++i) {
            hairCodeBlank = hairCodeBlank + "00000000000000";
        }
        int startSplit = hairSideCount[1] * 14;
        int endSplit = hairSideCount[3] * 14;
        String hairFront = onlyPart == 0 || onlyPart == 1 ? hairCode.substring(0, startSplit) : hairCodeBlank.substring(0, startSplit);
        String hairSides = onlyPart == 0 || onlyPart == 2 ? hairCodePartner.substring(startSplit, endSplit) : hairCodeBlank.substring(startSplit, endSplit);
        String hairTop = onlyPart == 0 || onlyPart == 1 ? hairCode.substring(endSplit) : hairCodeBlank.substring(endSplit);
        String hairCodeFusion = hairFront + hairSides + hairTop;
        if (debug) {
            System.out.println("sub #1: \"" + hairCode.substring(0, startSplit) + "\"");
        }
        if (debug) {
            System.out.println("sub #2: \"" + hairCodePartner.substring(startSplit, endSplit) + "\"");
        }
        if (debug) {
            System.out.println("sub #3: \"" + hairCode.substring(endSplit) + "\"");
        }
        if (debug) {
            System.out.println("hairCodeFusion: \"" + hairCodeFusion + "\"");
        }
        return hairCodeFusion;
    }

    public static void setMessage(String message, boolean error) {
        HairEditor.message = (error ? EnumChatFormatting.RED + "Error: " : "") + EnumChatFormatting.YELLOW + message;
        messageTime = System.currentTimeMillis();
    }

    static {
        lastHairTexture = null;
        curPiece = 0;
        lastPiece = 0;
        selectedPieces = new ArrayList();
        preMirrorPieces = new ArrayList();
        selectedMirrorPieces = new ArrayList();
        characterYaw = 0.0f;
        startCharacterYaw = -1.0f;
        finishCharacterYaw = 0.5f;
        characterPitch = 0.0f;
        startCharacterPitch = -1.0f;
        finishCharacterPitch = 0.5f;
        hairSideCount = new int[]{0, 4, 14, 24, 40, 56};
        lastLength = 1;
        displayScaleX = 1.0f;
        displayScaleUpX = 1.0f;
        displayScaleY = 1.0f;
        displayScaleUpY = 1.0f;
        windowWidth = 0.0;
        windowHeight = 0.0;
        message = null;
        messageTime = 0L;
    }
}

