/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.GUI;

import java.util.ArrayList;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CrateScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class RewardGet {
    static ArrayList<Object[]> rewardList = new ArrayList();
    static int rewardLimit = 8;
    static long timeLimit = 10000L;

    public static void rewardGetTick() {
        for (int i = 0; i < rewardList.size(); ++i) {
            Object[] rewardEntry = rewardList.get(i);
            ItemStack itemStack = (ItemStack)rewardEntry[0];
            long timeAdded = (Long)rewardEntry[2];
            if (timeAdded == -1L || ClientUtils.getTimeSince(timeAdded) < RewardGet.getTimeLimit()) continue;
            rewardList.remove(i);
            break;
        }
    }

    public static void renderRewardPrompt(double posX, double posY) {
        long curTime = System.currentTimeMillis();
        double width = 20.0;
        double height = 20.0;
        double gapPer = height + 5.0;
        int color = 0;
        int color2 = 0xFFFFFF;
        GL11.glPushMatrix();
        double titleAlpha = 0.0;
        for (int i = 0; i < rewardLimit; ++i) {
            long timeLimit;
            double duration;
            if (rewardList.size() <= i) continue;
            Object[] rewardEntry = rewardList.get(i);
            ItemStack itemStack = (ItemStack)rewardEntry[0];
            int tpAmount = (Integer)rewardEntry[1];
            long timeAdded = (Long)rewardEntry[2];
            if (timeAdded == -1L) {
                RewardGet.setRewardTime(i, curTime);
            }
            double durationFactor = (duration = ((double)(timeLimit = RewardGet.getTimeLimit()) - (double)ClientUtils.getTimeSince(timeAdded)) / (double)timeLimit) <= 0.5 ? duration * 2.0 : 1.0;
            double alpha = 0.45 * durationFactor;
            double entryPosX = posX;
            double entryPosY = posY + (double)i * gapPer;
            String text = tpAmount != -1 ? EnumChatFormatting.GREEN + "TP: " + EnumChatFormatting.YELLOW + Methods.numSep((int)tpAmount) + EnumChatFormatting.GRAY + (CrateScreen.tpCapStay ? " (Discarded)" : " (Stat Sheet)") : itemStack.func_82833_r();
            double textScale = 0.7;
            double textWidth = (double)Main.mc.field_71466_p.func_78256_a(text) * textScale + 5.0;
            double durationBar = duration * textWidth;
            RenderUtils.drawRectangle(entryPosX + width, entryPosY + height - 3.0, durationBar, 2.0, color2, alpha * 0.25);
            RewardGet.drawItem(itemStack, true, entryPosX, entryPosY, alpha, durationFactor);
            durationFactor = Math.max((double)0.2f, durationFactor);
            titleAlpha = Math.max(durationFactor, titleAlpha);
            RenderUtils.drawRectangle(entryPosX + width, entryPosY + 4.0, textWidth, 12.0, color, alpha);
            RenderUtils.drawScaledOpaqueText(Main.mc, text, textScale, durationFactor, entryPosX + 22.0, entryPosY + 8.0, false, 0);
        }
        if (!rewardList.isEmpty()) {
            String text = EnumChatFormatting.GRAY + "Rewards " + EnumChatFormatting.GREEN + "Received";
            RenderUtils.drawScaledOpaqueText(Main.mc, text, 0.7, titleAlpha, posX + 3.0, posY - 7.0, true, 0);
            if (rewardList.size() > rewardLimit) {
                text = EnumChatFormatting.GRAY + "And " + (rewardList.size() - rewardLimit) + " More...";
                RenderUtils.drawScaledOpaqueText(Main.mc, text, 0.7, titleAlpha, posX + 3.0, posY + (double)rewardLimit * gapPer - 1.0, true, 0);
            }
        }
        GL11.glPopMatrix();
    }

    public static void drawItem(ItemStack itemStack, boolean drawStackSize, double posX, double posY, double backAlpha, double itemAlpha) {
        double width = 20.0;
        double height = 20.0;
        int color = 0;
        int color2 = 0xFFFFFF;
        if (backAlpha > 0.0) {
            RenderUtils.drawRectangle(posX, posY, width, height, color, backAlpha);
            RenderUtils.drawRectangle(posX + 1.0, posY + 1.0, height - 2.0, height - 2.0, color2, backAlpha * 0.3);
        }
        CrateScreen.drawItem(itemStack, drawStackSize, posX, posY, 18.0, (float)itemAlpha);
    }

    static long getTimeLimit() {
        long reduction = (long)rewardList.size() * (timeLimit / 100L);
        return Math.max(timeLimit / 2L, timeLimit - reduction);
    }

    static void setRewardTime(int entry, long timeSet) {
        Object[] rewardEntry = new Object[]{rewardList.get(entry)[0], rewardList.get(entry)[1], timeSet};
        rewardList.set(entry, rewardEntry);
    }

    public static void addReward(String reward) {
        ItemStack itemStack = CrateScreen.getClientStack(reward);
        int tpAmount = reward.contains("tp") && !reward.contains("tpB") ? Integer.parseInt(reward.split(":")[1]) : -1;
        Object[] rewardEntry = new Object[]{itemStack, tpAmount, -1L};
        rewardList.add(rewardEntry);
    }
}

