/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import JinRyuu.JRMCore.JRMCoreGuiScreen;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Client.Events.MultiThread;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.EscapeSettings.EscapeMenu;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.GuiRender;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.HairEditor;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.OnScreen.OnScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ConfigButtons;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ConfigHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.FileWalker;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.InfoHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Storage;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.UrlWalker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class ClientUtils {
    public static final Minecraft mc = Minecraft.func_71410_x();
    public static boolean hasIconAnimated = false;
    public static boolean isAnimating = false;
    public static String animType = null;
    static int animFrame = 0;
    static int animFrameLimit = 3;
    static int animTime = 0;
    static int animTimeLimit = 5;
    static long lastFpsTime = 0L;
    static long lastPingTime = 0L;
    static long lastServerPingTime = 0L;
    public static List<Long> serverPings = new ArrayList<Long>();
    public static boolean pingWork = false;
    public static EnumChatFormatting[] pingColor = new EnumChatFormatting[]{EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.GREEN, EnumChatFormatting.GOLD, EnumChatFormatting.RED, EnumChatFormatting.DARK_RED};
    public static int[] pingColorCodes = new int[]{0xFF55FF, 0x55FF55, 0xFFAA00, 0xFF5555, 0xAA0000};
    static double lastPosX;
    static double lastPosY;
    static double lastPosZ;
    static int positionTimer;
    static long lastClick;

    public static void addALogMessage(String message) {
        message = Methods.enumConvert((String)message);
        boolean debug = false;
        boolean replaced = false;
        boolean combined = false;
        for (int i = 0; i < GuiRender.aLogMessages.size(); ++i) {
            String[][] combine;
            String loopMessage = GuiRender.aLogMessages.get(i);
            for (String[] phrase : combine = new String[][]{{"TP", "You have gained ", " TP"}, {"Z-Soul", "has gained ", " exp!"}, {"Kaioken", "has gained ", " exp!"}}) {
                if (!message.contains(phrase[0]) || !message.contains(phrase[1]) || !message.contains(phrase[2]) || !loopMessage.contains(phrase[0]) || !loopMessage.contains(phrase[1]) || !loopMessage.contains(phrase[2])) continue;
                boolean extraPass = true;
                if (phrase[0].equals("Z-Soul")) {
                    String formName = loopMessage.split(phrase[1])[0];
                    String formNameNew = message.split(phrase[1])[0];
                    if (debug) {
                        System.out.println("Name: " + formName + " vs. " + formNameNew);
                    }
                    extraPass = formName.equals(formNameNew);
                }
                if (!extraPass) continue;
                combined = true;
                String loopMessageNoFormat = EnumChatFormatting.func_110646_a((String)loopMessage).replaceAll(",", "");
                String messageNoFormat = EnumChatFormatting.func_110646_a((String)message).replaceAll(",", "");
                int contentsInt = Integer.parseInt(loopMessageNoFormat.split(phrase[1])[1].split(phrase[2])[0]);
                int newInt = Integer.parseInt(messageNoFormat.split(phrase[1])[1].split(phrase[2])[0]);
                int newContentsInt = contentsInt + newInt;
                boolean ignoreEnd = phrase[2].contains("TP");
                String contents = Methods.numSep((int)newInt) + (!ignoreEnd ? phrase[2] : "");
                String newContents = Methods.numSep((int)newContentsInt) + (!ignoreEnd ? phrase[2] : "");
                if (debug) {
                    System.out.println("existing: " + loopMessage);
                }
                if (debug) {
                    System.out.println("before: " + message);
                }
                if (debug) {
                    System.out.println("- replacing: \"" + contents + "\" with \"" + newContents + "\"");
                }
                message = message.replaceFirst(contents, newContents);
                if (!debug) break;
                System.out.println("after: " + message);
                break;
            }
            if (!combined && message.equals(loopMessage)) {
                replaced = true;
                int repeatCount = GuiRender.aLogRepeats.getOrDefault(message, 1);
                GuiRender.aLogRepeats.put(message, repeatCount + 1);
            }
            if (!replaced && !combined) continue;
            GuiRender.aLogMessages.remove(i);
            GuiRender.aLogTime.remove(i);
        }
        GuiRender.aLogMessages.add(message);
        GuiRender.aLogTime.add(System.currentTimeMillis());
        if (GuiRender.aLogMessages.size() > ApolloConfig.actionLogMessageCount) {
            GuiRender.aLogMessages.remove(0);
            GuiRender.aLogTime.remove(0);
        }
        if (!replaced && !message.startsWith("Example Message #")) {
            Main.logger.info("Action-Log message added: " + message);
        }
    }

    public static void addDebugMessage(String debugMessage, int limit) {
        if (GuiRender.onScreenDebug.size() >= limit) {
            GuiRender.onScreenDebug.remove(0);
        }
        GuiRender.onScreenDebug.add(debugMessage);
    }

    public static void setDebugMessage(int spot, String debugMessage) {
        if (GuiRender.onScreenDebug.size() <= spot + 1) {
            GuiRender.onScreenDebug.add(debugMessage);
        } else {
            GuiRender.onScreenDebug.set(0, debugMessage);
        }
    }

    public static void drawInfoDisplay(FontRenderer fr, String type) {
        if (!ApolloConfig.showInfoDisplay || !ApolloConfig.showInfoInMenu && type.equals("inMenu")) {
            return;
        }
        boolean inStatMenu = ClientUtils.mc.field_71462_r instanceof JRMCoreGuiScreen;
        boolean inInterfaceConfig = inStatMenu && ConfigButtons.cs_mode == 1;
        boolean inInfoDisplayConfig = inInterfaceConfig && ConfigButtons.cs_page == 9 && ConfigButtons.cs_sub4;
        ArrayList<String> infoDisplay = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy - HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date();
        String time = dateFormat.format(date);
        String color = type.equals("inMenu") && ClientUtils.mc.field_71462_r instanceof EscapeMenu ? EnumChatFormatting.YELLOW + "" : EnumChatFormatting.GRAY + "";
        String tpText = "";
        String expText = "";
        String currentEvent = UrlWalker.getEventName(false);
        if (!currentEvent.equals("No Event")) {
            tpText = color + "Event: " + EnumChatFormatting.LIGHT_PURPLE + currentEvent;
        }
        if (net.MCApolloNetwork.ApolloCrux.Bridge.Main.eventFailedToLoad) {
            tpText = EnumChatFormatting.RED + "Error: " + EnumChatFormatting.GRAY + "Event Data Failed to Load";
        }
        if (ApolloConfig.showInfoDisplayBooster) {
            String addition;
            int boosterTimer;
            if (net.MCApolloNetwork.ApolloCrux.Bridge.Main.tpMulti > 1.0) {
                int tpMulti = (int)Math.round(Double.parseDouble(BridgeUtils.convertDecimalToPercent((float)((float)net.MCApolloNetwork.ApolloCrux.Bridge.Main.tpMulti)).split("%")[0]));
                tpText = tpText + color + (!tpText.isEmpty() ? " | " : "") + (tpMulti == 5 ? "Weekend" : "Event") + " TP Booster " + EnumChatFormatting.LIGHT_PURPLE + tpMulti + "%" + color;
            }
            double boosterMulti = !Storage.tpBoosterActive.isEmpty() ? Double.parseDouble(Storage.tpBoosterActive) : 0.0;
            int n = boosterTimer = Storage.tpBoosterTimer != 0 ? Storage.tpBoosterTimer : 0;
            if (boosterTimer > 0) {
                addition = color + (!tpText.isEmpty() ? " | " : "") + "Booster Active: " + EnumChatFormatting.LIGHT_PURPLE + BridgeUtils.convertDecimalToPercent((float)((float)boosterMulti)) + color + " for " + BridgeUtils.timerBuilder((int)boosterTimer);
                tpText = !tpText.isEmpty() ? tpText + addition : addition;
            }
            if (Storage.divine && net.MCApolloNetwork.ApolloCrux.Bridge.Main.tpMulti == 1.0 && boosterMulti == 0.0) {
                addition = color + (!tpText.isEmpty() ? " | " : "") + "Divine Rank Boost: " + EnumChatFormatting.LIGHT_PURPLE + "5%" + color;
                tpText = !tpText.isEmpty() ? tpText + addition : addition;
            }
            if (net.MCApolloNetwork.ApolloCrux.Bridge.Main.expMulti > 1.0) {
                int expMulti = (int)Math.round(Double.parseDouble(BridgeUtils.convertDecimalToPercent((float)((float)net.MCApolloNetwork.ApolloCrux.Bridge.Main.expMulti)).split("%")[0]));
                expText = color + "Event EXP Booster " + EnumChatFormatting.LIGHT_PURPLE + expMulti + "%";
            }
        }
        String timePlayed = "";
        if (ApolloConfig.showInfoDisplayTimeOn && (type.equals("inMenu") || inInfoDisplayConfig) && Main.loginTime != 0) {
            timePlayed = color + "Time on Modpack " + ClientUtils.getTimeOnModpack();
        }
        if (ApolloConfig.showInfoDisplayTopLine) {
            String upperText = color + "Dragon Block Apollo | " + (!GuiRender.characterData.contains("#-1") && !GuiRender.characterData.contains("#0") ? (GuiRender.characterData.contains("Loaded Slot #") ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + "(" + GuiRender.characterData + ")" + color + " - " : "") + GuiRender.serverName + " - " + time + " UTC";
            infoDisplay.add(upperText);
        }
        if (ApolloConfig.showInfoDisplayGameVersion) {
            String versionText = color + ClientUtils.buildVersionString(Main.version, Main.build) + (Main.devBuild ? " | Development Build" : "");
            infoDisplay.add(versionText);
        }
        if (!tpText.isEmpty() || !expText.isEmpty()) {
            String text = (!tpText.isEmpty() ? tpText : "") + (!expText.isEmpty() ? (!tpText.isEmpty() ? " | " : "") + expText : "");
            infoDisplay.add(text);
        }
        if (ApolloConfig.showFpsDisplay || ApolloConfig.showPingDisplay) {
            String fpsText = "FPS: " + Methods.numSep((int)Main.FPS);
            String pingText = "Ping: " + ClientUtils.colorPing(Main.ping) + color + "ms";
            if (ApolloConfig.showFpsDisplay && ApolloConfig.showAverageFps && !Main.fpsHistory.isEmpty()) {
                int sum = 0;
                for (int i = 0; i < Main.fpsHistory.size(); ++i) {
                    if (Main.fpsHistory.size() < i + 1 || Main.fpsHistory.get(i) == null) continue;
                    sum += Main.fpsHistory.get(i).intValue();
                }
                String averageFpsText = " Avg: " + Methods.numSep((int)(sum / Main.fpsHistory.size()));
                fpsText = fpsText + averageFpsText;
            }
            if (ApolloConfig.showPingDisplay && pingWork && ApolloConfig.showAveragePing && !Main.pingHistory.isEmpty()) {
                int sum = 0;
                for (int i = 0; i < Main.pingHistory.size(); ++i) {
                    if (Main.pingHistory.size() < i + 1 || Main.pingHistory.get(i) == null) continue;
                    sum += Main.pingHistory.get(i).intValue();
                }
                String averagePingText = " Avg: " + ClientUtils.colorPing(sum / Main.pingHistory.size()) + color + "ms";
                pingText = pingText + averagePingText;
            }
            pingText = "";
            String text = color + (ApolloConfig.showFpsDisplay && ApolloConfig.showPingDisplay && pingWork ? fpsText : (!ApolloConfig.showFpsDisplay && ApolloConfig.showPingDisplay && pingWork ? pingText : fpsText));
            infoDisplay.add(text);
        }
        if (ApolloConfig.showInfoDisplayKillCount && GuiRender.deaths != -1 && GuiRender.kills != -1 && (type.equals("inMenu") || inInfoDisplayConfig)) {
            float kdRatio = GuiRender.deaths == 0 ? (float)GuiRender.kills : BridgeUtils.round((float)100.0f, (float)((float)GuiRender.kills / (float)GuiRender.deaths));
            String text = color + "Kills: " + Methods.numSep((int)GuiRender.kills) + " | Deaths: " + Methods.numSep((int)GuiRender.deaths) + " | KD: " + kdRatio;
            infoDisplay.add(text);
        }
        if (!timePlayed.isEmpty()) {
            infoDisplay.add(color + " - ");
            infoDisplay.add(timePlayed);
        }
        float infoDisplayScale = ConfigHandler.getConfigOption(ApolloConfig.infoDisplayScale, ApolloConfig.guiScale);
        float infoDisplayOpacity = ConfigHandler.getConfigOption(ApolloConfig.infoDisplayOpacity, ApolloConfig.guiOpacity);
        float displayScale = OnScreen.getScreenScale(mc, false, 0.0f);
        float displayScaleUp = (float)Math.pow(displayScale, -1.0);
        float scale = 0.6f * displayScale * infoDisplayScale;
        float scaleUp = (float)Math.pow(scale, -1.0);
        ScaledResolution scaledResolution = new ScaledResolution(mc, ClientUtils.mc.field_71443_c, ClientUtils.mc.field_71440_d);
        int posX = (int)((float)scaledResolution.func_78326_a() * scaleUp) - 5 + ApolloConfig.infoDisplayOffsetX;
        int posY = 5 + ApolloConfig.infoDisplayOffsetY;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)infoDisplayOpacity);
        for (int line = 0; line < infoDisplay.size(); ++line) {
            String text = (String)infoDisplay.get(line);
            RenderUtils.drawTextBackdrop(mc, text, (double)(posX - fr.func_78256_a(text)), (double)(posY + line * 11), 0, (double)ApolloConfig.guiOpacity, -2);
        }
        GL11.glPopMatrix();
    }

    public static String buildVersionString(String ver, int build) {
        boolean isB = ver.equals("1.2.7") && build == 54;
        return "ver. " + ver + (isB ? "b" : "") + " build #" + build;
    }

    public static void getVersionInfo(String modName) {
        ClientUtils.updateBuild(modName);
        ClientUtils.updateVersion(modName);
    }

    public static void updateVersion(String modName) {
        String version = FileWalker.getModInfo(modName, "version");
        if (modName.equals("ApolloBridge")) {
            net.MCApolloNetwork.ApolloCrux.Bridge.Main.version = version;
        } else {
            Main.version = version;
        }
    }

    public static void updateBuild(String modName) {
        int build = 0;
        String buildString = FileWalker.getModInfo(modName, "build");
        if (Methods.isNumeric((String)buildString)) {
            build = Integer.parseInt(buildString);
        }
        if (modName.equals("ApolloBridge")) {
            net.MCApolloNetwork.ApolloCrux.Bridge.Main.build = build;
        } else {
            Main.build = build;
        }
    }

    public static int getTimeSince(int input) {
        return ClientUtils.getTimeSince(input, 1000);
    }

    public static int getTimeSince(long input, int factor) {
        long curTime = System.currentTimeMillis() / (long)factor;
        return (int)(curTime - input);
    }

    public static long getTimeSince(long input) {
        long curTime = System.currentTimeMillis();
        return curTime - input;
    }

    public static String getTimeOnModpack() {
        int curTime = (int)(System.currentTimeMillis() / 1000L);
        return BridgeUtils.timerBuilder((int)ClientUtils.getTimeSince(Main.loginTime));
    }

    public static void setCursor(int cursorId) {
        ClientUtils.setCursor(cursorId, 0);
    }

    public static void setCursor(int cursorId, int animFrame) {
        boolean debug = false;
        try {
            int y;
            Class.forName("org.lwjgl.LWJGLException");
            if (cursorId == ApolloConfig.cursorStyleCount) {
                Mouse.setNativeCursor((Cursor)Main.cursor);
                return;
            }
            String animTex = animFrame != 0 ? "_" + animFrame : "";
            String texPath = "/assets/dbapollo/textures/gui/onScreen/cursor/" + cursorId + animTex;
            BufferedImage image = ImageIO.read(Main.class.getResource(texPath + ".png"));
            if (debug) {
                System.out.println("cursor: " + cursorId + " | " + texPath);
            }
            int w = image.getWidth();
            int h = image.getHeight();
            int numImg = h / w;
            int[] pixels = new int[w * h];
            image.getRGB(0, 0, w, h, pixels, 0, w);
            IntBuffer buffer = BufferUtils.createIntBuffer((int)(w * h));
            IntBuffer delayBuffer = BufferUtils.createIntBuffer((int)(numImg * 2));
            for (int i = 0; i < numImg; ++i) {
                delayBuffer.put(1);
                for (y = i * w; y < (i + 1) * w; ++y) {
                    for (int x = 0; x < w; ++x) {
                        buffer.put(pixels[((i + 1) * w - 1 - y) * w + x]);
                    }
                }
            }
            ((Buffer)buffer).flip();
            int x = cursorId == -1 ? 28 : w / 2;
            y = cursorId == -1 ? 108 : w - 1 - h / 2;
            Mouse.setNativeCursor((Cursor)new Cursor(w, h, x, y, numImg, buffer, numImg != 1 ? delayBuffer : null));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setIcon(int animFrame) {
        try {
            String iconType = Main.devBuild ? "dev_" : "main_";
            iconType = "main_";
            String animTex = animFrame != 0 ? "_" + animFrame : "";
            InputStream icon16 = Main.class.getResourceAsStream("/assets/dbapollo/textures/icons/" + iconType + "16" + animTex + ".png");
            InputStream icon32 = Main.class.getResourceAsStream("/assets/dbapollo/textures/icons/" + iconType + "32" + animTex + ".png");
            ByteBuffer[] iconArray = new ByteBuffer[]{Main.InputOutputBuffer(icon16), Main.InputOutputBuffer(icon32)};
            Display.setIcon((ByteBuffer[])iconArray);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static void doAnimation(String type) {
        boolean canStart;
        boolean bl = canStart = !type.equalsIgnoreCase("cursor") || Mouse.getEventButtonState();
        animFrameLimit = type.equalsIgnoreCase("cursor") ? (ApolloConfig.cursorStyle == 0 ? 5 : 3) : 5;
        int n = animTimeLimit = type.equalsIgnoreCase("cursor") ? 5 : 15;
        if (canStart && !isAnimating || isAnimating && animFrame > 0) {
            isAnimating = true;
            animType = type;
            if (++animTime >= animTimeLimit || animFrame == 0) {
                animTime = 0;
                ++animFrame;
            }
            if (animFrame > animFrameLimit) {
                animFrame = 0;
                isAnimating = false;
            }
            if (type.equalsIgnoreCase("cursor")) {
                ClientUtils.setCursor(ApolloConfig.cursorStyle, animFrame);
            }
        }
    }

    public static void updateFPS() {
        if (Main.mc.field_71426_K.isEmpty()) {
            return;
        }
        try {
            Main.FPS = Integer.parseInt(Main.mc.field_71426_K.split(" fps,")[0]);
            if (ApolloConfig.showAverageFps) {
                if (ClientUtils.getTimeSince(lastFpsTime) < 1000L) {
                    return;
                }
                lastFpsTime = System.currentTimeMillis();
                Main.fpsHistory.add(Main.FPS);
                if (Main.fpsHistory.size() >= 7) {
                    Main.fpsHistory.remove(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updatePing() {
        if (ClientUtils.getTimeSince(lastPingTime) < (long)(pingWork ? 1000 : 2000) || !Display.isVisible() || !Display.isActive()) {
            return;
        }
        MultiThread thread = new MultiThread("ping");
        thread.start();
    }

    public static void updatePingThread() {
        if (pingWork) {
            ServerData serverData = Main.mc.func_147104_D();
            String serverIP = serverData.field_78845_b;
            if (serverIP.contains(":")) {
                serverIP = serverIP.split(":")[0];
            }
            lastPingTime = System.currentTimeMillis();
            Main.ping = (int)ClientUtils.pingServerIP(serverIP);
        } else {
            List players = Main.mc.field_71439_g.field_71174_a.field_147303_b;
            for (GuiPlayerInfo player : players) {
                ScorePlayerTeam team = Main.mc.field_71441_e.func_96441_U().func_96509_i(player.field_78831_a);
                String displayName = ScorePlayerTeam.func_96667_a((Team)team, (String)player.field_78831_a);
                boolean isPlayerClient = displayName.contains(Main.mc.field_71439_g.func_70005_c_());
                if (!isPlayerClient) continue;
                lastPingTime = System.currentTimeMillis();
                Main.ping = player.field_78829_b;
                break;
            }
        }
        if (ApolloConfig.showAveragePing) {
            Main.pingHistory.add(Main.ping);
            if (Main.pingHistory.size() >= 7) {
                Main.pingHistory.remove(0);
            }
        }
    }

    public static void pingAllServers() {
        if (ClientUtils.getTimeSince(lastServerPingTime) < 5000L || !Display.isVisible() || !Display.isActive()) {
            return;
        }
        MultiThread thread = new MultiThread("pingServers");
        thread.start();
    }

    public static void pingAllServersThread() {
        int i;
        lastServerPingTime = System.currentTimeMillis();
        if (serverPings.isEmpty()) {
            for (i = 0; i < InfoHandler.servers.size(); ++i) {
                serverPings.add(0L);
            }
        }
        for (i = 0; i < InfoHandler.servers.size(); ++i) {
            String serverIP = (String)InfoHandler.servers.get(i)[2];
            if (serverIP.contains(":")) {
                serverIP = serverIP.split(":")[0];
            }
            long serverPing = ClientUtils.pingServerIP(serverIP);
            serverPings.set(i, serverPing);
        }
    }

    public static long pingServerIP(String serverIP) {
        if (!ApolloConfig.showPingDisplay) {
            return -1L;
        }
        long startTime = System.currentTimeMillis();
        long finishTime = 0L;
        try {
            InetAddress address = InetAddress.getByName(serverIP);
            boolean isReachable = address.isReachable(2000);
            finishTime = System.currentTimeMillis();
            long pingTime = finishTime - startTime;
            if (pingTime >= 2000L) {
                if (pingWork) {
                    System.out.println("Ping was greater than target, disabling Ping as it likely doesn't work for the Client");
                    pingWork = false;
                }
            } else {
                pingWork = true;
            }
            return pingTime;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public static long getPing(int instance) {
        long ping = -1L;
        if (pingWork && instance < 6 && !serverPings.isEmpty() && (InfoHandler.servers.size() >= instance + 3 || instance >= 6)) {
            ping = serverPings.get(instance + 3);
        }
        return ping;
    }

    public static int colorPingInt(long ping) {
        return ping < 80L ? 1 : (ping < 180L ? 2 : (ping < 360L ? 3 : 4));
    }

    public static String colorPing(long ping) {
        int colorPingInt = ClientUtils.colorPingInt(ping);
        return ClientUtils.colorPing(ping, colorPingInt);
    }

    public static String colorPing(long ping, int colorPingInt) {
        EnumChatFormatting color = pingColor[colorPingInt];
        return color + "" + Methods.numSep((int)((int)ping)) + EnumChatFormatting.RESET;
    }

    public static void positionValidate() {
        if (++positionTimer >= SUBEvents.getTV(1).intValue()) {
            positionTimer = 0;
            lastPosX = Main.mc.field_71439_g.field_70142_S;
            lastPosY = Main.mc.field_71439_g.field_70137_T;
            lastPosZ = Main.mc.field_71439_g.field_70136_U;
        }
        if (SUBEvents.getTV(2) != 1.0) {
            BridgePD.tellServer((String)"entityID");
            SUBEvents.testVariables.set(2, 1.0);
        }
        double sqDistance = Main.mc.field_71439_g.func_70092_e(lastPosX, lastPosY, lastPosZ);
        System.out.println("sqDistance: " + sqDistance);
        System.out.println("Dim ID: " + Main.mc.field_71441_e.field_73011_w.field_76574_g + " | Entity ID: " + Main.mc.field_71439_g.func_145782_y());
        if (sqDistance >= (double)SUBEvents.getTV(0).intValue()) {
            System.out.println("sqDistance was greater then, attempting refresh");
            Main.mc.field_71439_g.field_70142_S = Main.mc.field_71439_g.field_70165_t;
            Main.mc.field_71439_g.field_70137_T = Main.mc.field_71439_g.field_70163_u;
            Main.mc.field_71439_g.field_70136_U = Main.mc.field_71439_g.field_70161_v;
        }
    }

    public static void convertAreaMessage(String input) {
        GuiRender.areaMessages.clear();
        GuiRender.areaCount = 0;
        GuiRender.areaProg = 0;
        GuiRender.areaAnimation = 0;
        if (input.contains("> ")) {
            input = input.split("> ")[1];
            GuiRender.areaMessages.add(EnumChatFormatting.YELLOW + "Entered " + EnumChatFormatting.GREEN + "New Area");
        }
        GuiRender.areaMessages.add(input);
        if (input.contains("Conton")) {
            GuiRender.worldName = "Conton";
            BridgePD.tellServer((String)"stat:spawn");
        }
        if (input.contains("Wild")) {
            GuiRender.worldName = "Wild";
            BridgePD.tellServer((String)"stat:wild");
        }
        if (input.contains("Npc World")) {
            GuiRender.worldName = "Npc World";
        }
    }

    public static boolean checkOnServer() {
        return GuiRender.serverName != null && !GuiRender.serverName.equalsIgnoreCase("liltesting");
    }

    public static boolean checkOnTestServer() {
        return GuiRender.serverName != null && GuiRender.serverName.toLowerCase().contains("test");
    }

    public static boolean checkInSpawn() {
        return GuiRender.serverName.contains("Hub") || Main.mc.field_71439_g.field_70165_t <= 500.0 && Main.mc.field_71439_g.field_70165_t >= -500.0 && Main.mc.field_71439_g.field_70161_v <= 500.0 && Main.mc.field_71439_g.field_70161_v >= -500.0 && (!(Main.mc.field_71439_g.field_70165_t >= 157.0) || !(Main.mc.field_71439_g.field_70165_t <= 181.0) || !(Main.mc.field_71439_g.field_70161_v >= 0.0) || !(Main.mc.field_71439_g.field_70161_v <= 34.0) || !(Main.mc.field_71439_g.field_70163_u >= 79.0) || !(Main.mc.field_71439_g.field_70163_u <= 99.0)) && ClientUtils.checkOnServer() && GuiRender.worldName.equalsIgnoreCase("Conton");
    }

    public static boolean checkInHub() {
        return ClientUtils.checkOnServer() && GuiRender.serverName.toLowerCase().contains("hub");
    }

    public static boolean checkInWild() {
        return ClientUtils.checkOnServer() && GuiRender.serverName.toLowerCase().contains("wild");
    }

    public static boolean checkInWildMall() {
        return ClientUtils.checkInWild() && Main.mc.field_71439_g.field_70165_t <= 500.0 && Main.mc.field_71439_g.field_70165_t >= -500.0 && Main.mc.field_71439_g.field_70161_v <= 500.0 && Main.mc.field_71439_g.field_70161_v >= -500.0;
    }

    public static boolean checkInCrates() {
        return Main.mc.field_71439_g.field_70165_t <= -14500.0 && Main.mc.field_71439_g.field_70165_t >= -17500.0 && Main.mc.field_71439_g.field_70161_v <= 16000.0 && Main.mc.field_71439_g.field_70161_v >= 14500.0 && ClientUtils.checkOnServer() && GuiRender.worldName.equalsIgnoreCase("Conton");
    }

    public static void checkClicked() {
    }

    public static void validateGuiOpen(GuiScreen gui) {
        if (EscapeMenu.isOpen && !(gui instanceof EscapeMenu)) {
            EscapeMenu.isOpen = false;
        }
        if (CharacterCreation.isOpen && !(gui instanceof CharacterCreation) && !(gui instanceof HairEditor)) {
            CharacterCreation.isOpen = false;
            ClientUtils.setCursor(ApolloConfig.cursorStyle);
        }
        if (HairEditor.isOpen && !(gui instanceof HairEditor)) {
            HairEditor.isOpen = false;
            ClientUtils.setCursor(ApolloConfig.cursorStyle);
            HairEditor.saveHairCodeServer();
        }
        if (CharacterCreation.fromHairEditor && !(gui instanceof CharacterCreation)) {
            CharacterCreation.fromHairEditor = false;
            CharacterCreation.page = 0;
        }
    }

    static {
        positionTimer = 0;
        lastClick = -1L;
    }
}

