/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class LaunchInfo {
    public static boolean firstTimePrompt;
    public static boolean hasSentLaunchInfo;
    public static boolean hardwareDisallow;
    public static String systemOS;
    public static String javaRunTime;
    public static String graphicsCard;
    public static String openGLVersion;
    public static String displayResolution;
    public static String launcher;
    public static int ramAllocated;
    public static int cpuCores;
    public static boolean hasOptifine;
    public static boolean hasFastCraft;
    public static boolean hasBetterFPS;
    public static boolean hasNeodymium;
    public static boolean hasCoreTweaks;
    public static String shaderPack;
    public static String[] launchInfoEntries;

    public static void printSystem() {
        Runtime run = Runtime.getRuntime();
        Main.logger.info(" - - - - - - - ");
        Main.logger.info(" Apollo Client | User System Information:");
        systemOS = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")";
        Main.logger.info(" - System OS: " + systemOS);
        javaRunTime = System.getProperty("java.runtime.version");
        Main.logger.info(" - Java RunTime: " + javaRunTime);
        cpuCores = run.availableProcessors();
        Main.logger.info(" - CPU Cores: " + cpuCores);
        graphicsCard = GL11.glGetString((int)7937);
        if (graphicsCard.contains("/PCIe")) {
            graphicsCard = graphicsCard.split("/PCIe")[0];
        }
        Main.logger.info(" - GPU: " + graphicsCard);
        openGLVersion = GL11.glGetString((int)7938);
        Main.logger.info(" - OpenGL Version: " + openGLVersion);
        Main.logger.info(" - LWJGL Version: " + Sys.getVersion());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        displayResolution = (int)screenSize.getHeight() + "x" + (int)screenSize.getWidth();
        Main.logger.info(" - Display Resolution: " + displayResolution);
        ramAllocated = (int)(run.maxMemory() / 1000000L);
        long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 1000000L;
        Main.logger.info(" - RAM: " + Methods.numSep((int)ramAllocated) + "mb / " + Methods.numSep((int)((int)memorySize)) + "mb");
        launcher = System.getProperty("user.dir");
        if (launcher.toLowerCase().contains("technic")) {
            launcher = "Technic Launcher";
        } else if (launcher.toLowerCase().contains("multimc")) {
            launcher = "MultiMC Launcher";
        } else if (launcher.toLowerCase().contains("prismlauncher")) {
            launcher = "Prism Launcher";
        } else if (launcher.toLowerCase().contains("atlauncher")) {
            launcher = "AT Launcher";
        } else if (launcher.toLowerCase().contains("gdlauncher")) {
            launcher = "GD Launcher";
        } else if (launcher.toLowerCase().contains("ftb")) {
            launcher = "FTB Launcher";
        } else if (launcher.toLowerCase().contains("twitch") || launcher.toLowerCase().contains("curse")) {
            launcher = "CurseForge Launcher";
        } else if (launcher.toLowerCase().contains(".minecraft")) {
            launcher = "Minecraft Launcher";
        } else if (launcher.toLowerCase().contains("modrinth")) {
            launcher = "Modrinth Launcher";
        }
        Main.logger.info(" - Launcher: " + launcher);
        Main.logger.info(" - - - - - - - ");
    }

    public static void sendLaunchInfo() {
        if (!hasSentLaunchInfo) {
            String hardwareID;
            hasSentLaunchInfo = true;
            String launchInfo = hardwareID = LaunchInfo.getHardwareID(false);
            for (int setting = 0; setting < launchInfoEntries.length; ++setting) {
                launchInfo = Methods.addToExisting((String)launchInfo, (String)LaunchInfo.getLaunchInfo(setting, false), (String)"~ ", (boolean)true);
            }
            BridgePD.tellServer((String)("launchInfo:" + launchInfo));
        }
    }

    public static String getLaunchInfo(int setting, boolean ignoreConfig) {
        if (!ApolloConfig.sendLaunchInfo && !ignoreConfig) {
            return setting == 2 || setting == 3 ? "-1" : "null";
        }
        return "" + (setting == 0 ? systemOS : (setting == 1 ? javaRunTime : (setting == 2 ? Integer.valueOf(ramAllocated) : (setting == 3 ? Integer.valueOf(cpuCores) : (setting == 4 ? graphicsCard : (setting == 5 ? openGLVersion : (setting == 6 ? displayResolution : (setting == 7 ? launcher : "N/A"))))))));
    }

    public static String getHardwareID(boolean useVersion2) {
        try {
            byte[] byteData;
            if (useVersion2) {
                String s;
                Process process = Runtime.getRuntime().exec("wmic csproduct get UUID");
                InputStreamReader isr = new InputStreamReader(process.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                StringBuilder sb = new StringBuilder();
                int lineCount = 0;
                while ((s = br.readLine()) != null) {
                    if (++lineCount != 3) continue;
                    sb.append(s);
                }
                return sb.toString();
            }
            String toEncrypt = System.getenv("COMPUTERNAME") + "~" + System.getProperty("user.name") + "~" + System.getenv("PROCESSOR_IDENTIFIER") + "~" + System.getenv("PROCESSOR_LEVEL") + "~" + graphicsCard;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(toEncrypt.getBytes());
            StringBuffer hexString = new StringBuffer();
            for (byte aByteData : byteData = md.digest()) {
                String hex = Integer.toHexString(0xFF & aByteData);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error";
        }
    }

    static {
        shaderPack = null;
        launchInfoEntries = new String[]{"System OS", "Java Version", "Ram Allocated", "CPU Cores", "Graphics Card", "OpenGL Version", "Display Resolution", "Launcher"};
    }
}

