/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.GUI;

import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CustomGuiButton;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.HairEditor;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.OnScreen.OnScreen;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.CharacterUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.GLUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class CustomSlider
extends CustomGuiButton {
    public float sliderValue = 1.0f;
    public float sliderMinValue = 1.0f;
    public float sliderMaxValue = 1.0f;
    public boolean dragging = false;
    public double field_146128_h;
    public double field_146129_i;
    public String label;
    public boolean hovered = false;
    public GuiScreen sourceGui;
    float scaleX = 1.0f;
    float scaleXUp = 1.0f;
    float scaleY = 1.0f;
    float scaleYUp = 1.0f;

    public CustomSlider(int id, double posX, double posY, String label, float startingValue, float minValue, float maxValue, GuiScreen sourceGui) {
        this(id, posX, posY, label, startingValue, minValue, maxValue, sourceGui, 1.0f, 1.0f);
    }

    public CustomSlider(int id, double posX, double posY, String label, float startingValue, float minValue, float maxValue, GuiScreen sourceGui, float scaleX) {
        this(id, posX, posY, label, startingValue, minValue, maxValue, sourceGui, scaleX, scaleX);
    }

    public CustomSlider(int id, double posX, double posY, String label, float startingValue, float minValue, float maxValue, GuiScreen sourceGui, float scaleX, float scaleY) {
        super(id, (int)posX, (int)posY, 150.0, 20.0, label, sourceGui);
        this.displayScaleX = OnScreen.getScreenScaleWidth();
        this.displayScaleUpX = (float)Math.pow(this.displayScaleX, -1.0);
        this.displayScaleY = OnScreen.getScreenScaleHeight();
        this.displayScaleUpY = (float)Math.pow(this.displayScaleY, -1.0);
        this.scaleX = scaleX * this.displayScaleX;
        this.scaleXUp = (float)Math.pow(this.scaleX, -1.0);
        this.scaleY = scaleY * this.displayScaleY;
        this.scaleYUp = (float)Math.pow(this.scaleY, -1.0);
        double d = CharacterCreation.isOpen || HairEditor.isOpen ? CharacterCreation.offsetWidth * (double)this.scaleXUp : 0.0;
        this.field_146120_f = 150.0;
        this.field_146121_g = 13.0;
        this.field_146128_h = posX += d;
        this.field_146129_i = posY;
        this.label = label;
        this.sliderValue = startingValue;
        this.sliderMinValue = minValue;
        this.sliderMaxValue = maxValue;
        this.sourceGui = sourceGui;
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = mc.field_71466_p;
            this.hovered = this.mousePressed(mc, mouseX, mouseY, false);
            boolean k = true;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(CharacterCreation.page == 1 ? 1000.0f : 500.0f));
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)1.0f);
            double posX = this.field_146128_h;
            double posY = this.field_146129_i;
            RenderUtils.drawRectangle((posX -= CharacterCreation.isOpen || HairEditor.isOpen ? CharacterCreation.offsetWidth : 0.0) - 3.0, posY - 2.0, this.field_146120_f + 2.0, this.field_146121_g + 2.0, 0, 0.3);
            RenderUtils.drawRectangle(posX - 2.0, posY - 1.0, this.field_146120_f, this.field_146121_g, 0, 0.3);
            this.func_146119_b(mc, mouseX, mouseY);
            int l = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                l = this.packedFGColour;
            } else if (!this.field_146124_l) {
                l = 0xA0A0A0;
            } else if (this.hovered) {
                l = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, (int)((posX += CharacterCreation.isOpen || HairEditor.isOpen ? CharacterCreation.offsetWidth : 0.0) + this.field_146120_f / 2.0), (int)(posY + 2.0), l);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146124_l && this.field_146125_m && this.packedFGColour == 0) {
            String value;
            double posX = this.field_146128_h;
            double posY = this.field_146129_i;
            posX -= CharacterCreation.isOpen || HairEditor.isOpen ? CharacterCreation.offsetWidth : 0.0;
            if (this.dragging) {
                this.sliderSet(mouseX, mouseY);
            }
            if (this.label.contains("Character Rotation")) {
                value = "" + (int)(this.sliderValue * this.sliderMaxValue * 2.0f - 360.0f);
            } else if (this.label.contains("Muscle Definition") || this.label.contains("Scarring Intensity")) {
                value = "" + BridgeUtils.convertDecimalToPercent((float)(1.0f + BridgeUtils.round((float)100.0f, (float)(this.sliderValue * this.sliderMaxValue))));
            } else if (this.label.contains("Rotate")) {
                value = "" + GLUtils.flipFlopRotate(this.sliderValue);
            } else if (this.label.contains("Translate")) {
                value = "" + GLUtils.flipFlopTranslate(this.sliderValue);
            } else if (this.label.contains("Scale")) {
                value = "" + GLUtils.flipFlopScale(this.sliderValue);
            } else if (this.label.contains("Height")) {
                float baseHeight = Methods.ccSizeInches[0];
                float inputHeight = (float)(Methods.ccSizeInches[1] - Methods.ccSizeInches[0]) * (this.sliderValue * this.sliderMaxValue);
                float totalHeight = baseHeight + inputHeight;
                int feet = (int)Math.floor(totalHeight / 12.0f);
                int inches = (int)((totalHeight / 12.0f - (float)feet) * 12.0f);
                value = feet + "ft '" + inches + "in";
            } else if (this.label.contains("Body Size")) {
                float widthRatio = Methods.ccWidthRatio[CharacterCreation.rc];
                float valueWidth = 1.0f + this.sliderValue * widthRatio - widthRatio / 2.0f;
                if (valueWidth < 1.0f) {
                    valueWidth -= 2.0f;
                }
                value = "" + BridgeUtils.convertDecimalToPercent((float)(1.0f + valueWidth));
            } else if (this.label.contains("Color Brightness")) {
                value = "" + BridgeUtils.convertDecimalToPercent((float)(1.0f + BridgeUtils.round((float)100.0f, (float)(this.sliderValue * this.sliderMaxValue + (this.label.isEmpty() ? CharacterUtils.getBrightnessLimit() : 0.0f)))));
            } else if (this.field_146127_k >= 200 && this.field_146127_k < 1000) {
                if (this.label.contains("Rotation") || this.label.contains("Bend") || this.label.contains("Shape")) {
                    value = "" + (int)(this.sliderValue * 64.0f - 32.0f);
                } else if (this.label.contains("Length")) {
                    int result = (int)(this.sliderValue * 36.0f + 1.0f);
                    value = "" + (this.sliderValue == 0.0f ? "0 (Hidden)" : Integer.valueOf(result));
                } else {
                    value = "" + (int)(this.sliderValue * this.sliderMaxValue + (float)(this.label.isEmpty() ? 1 : 0));
                }
            } else {
                value = "" + (int)(this.sliderValue * this.sliderMaxValue + (float)(this.label.isEmpty() ? 1 : 0));
            }
            this.field_146126_j = this.label.isEmpty() ? value : this.label + ": " + value;
            double sliderPosX = posX + (double)((int)(this.sliderValue * (float)(this.field_146120_f - 8.0)));
            double sliderPosY = posY - 3.0;
            RenderUtils.drawRectangle(sliderPosX, sliderPosY, 4.0, 17.0, 0, 0.8);
            int color = this.hovered ? 0xFFFFFF : 15583006;
            RenderUtils.drawRectangle(sliderPosX + 1.0, sliderPosY + 1.0, 2.0, 15.0, color, 1.0);
            if (this.label.contains("Color Brightness")) {
                CharacterUtils.setColorSelection(CharacterCreation.curColSelectedX, CharacterCreation.curColSelectedY, false);
                CharacterUtils.setColorBri(this.sliderValue);
            }
        }
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.mousePressed(mc, mouseX, mouseY, true);
    }

    @Override
    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY, boolean realPress) {
        boolean canPress;
        double posX = this.field_146128_h * (double)this.scaleX;
        double posY = this.field_146129_i * (double)this.scaleY;
        double width = this.field_146120_f * (double)this.scaleX;
        double height = this.field_146121_g * (double)this.scaleY;
        boolean bl = canPress = this.field_146124_l && this.field_146125_m && (double)mouseX >= posX && (double)mouseY >= posY && (double)mouseX < posX + width && (double)mouseY < posY + height;
        if (RenderUtils.buttonBounds) {
            RenderUtils.drawRectangle(posX * 1.0 - 2.0, posY * 1.0 - 1.0, width, height, canPress ? 0xFFFFFF : (realPress ? 65535 : 16766976), 0.3f);
        }
        if (canPress && realPress) {
            this.sliderSet(mouseX, mouseY);
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
        if (this.label.contains("Color Brightness")) {
            CharacterUtils.setColorSelection(CharacterCreation.curColSelectedX, CharacterCreation.curColSelectedY, false);
            CharacterUtils.setColorBri(this.sliderValue);
        }
    }

    void sliderSet(int mouseX, int mouseY) {
        double posX = this.field_146128_h * (double)this.scaleX;
        double width = this.field_146120_f * (double)this.scaleX;
        float minValue = (float)((double)mouseX - (posX + 2.0));
        float maxValue = (float)(width - 8.0);
        this.sliderValue = minValue / maxValue;
        this.sliderValue = Math.max(0.0f, this.sliderValue);
        this.sliderValue = Math.min(1.0f, this.sliderValue);
    }
}

