/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Render;

import java.util.HashMap;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Player.RenderPlayerCustom;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.AnimationUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.RenderUtils;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;

public class Body {
    public static boolean isEnabled = false;
    public static boolean textures = false;
    public static Object[][] newBodyParts = new Object[][]{{"character", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {"head", 0.0, 25.0, 0.0, 0.0, 0.0, 0.0}, {"body_top", 0.0, 20.0, 0.0, 0.0, 0.0, 0.0}, {"right_arm_top", 4.0, 23.0, 0.0, -0.125, 0.0, 0.0}, {"right_arm_bottom", 6.0, 19.0, 2.0, -0.125, 0.0, 0.0}, {"left_arm_top", -4.0, 23.0, 0.0, 0.125, 0.0, 0.0}, {"left_arm_bottom", -6.0, 19.0, 2.0, 0.125, 0.0, 0.0}, {"body_bottom", 0.0, 12.0, 0.0, 0.0, 0.0, 0.0}, {"right_leg_top", 2.0, 12.0, 0.0, -0.125, 0.0, 0.0}, {"right_leg_bottom", 2.0, 6.0, -2.0, -0.125, 0.0, 0.0}, {"left_leg_top", -2.0, 12.0, 0.0, 0.125, 0.0, 0.0}, {"left_leg_bottom", -2.0, 6.0, -2.0, 0.125, 0.0, 0.0}};
    public static HashMap<String, HashMap<String, double[]>> currentRotations = new HashMap();
    public static HashMap<String, HashMap<String, double[]>> currentPositions = new HashMap();
    public static HashMap<String, HashMap<String, double[]>> currentScaling = new HashMap();
    public static Object[][] newTailParts = new Object[][]{{"tail1"}, {"tail2"}, {"tail3"}, {"tail4"}, {"tail5"}, {"tail6"}};

    static void validateModelPlacements() {
        if (currentRotations.isEmpty()) {
            for (String identifier : AnimationUtils.animationIdentifiers) {
                currentRotations.putIfAbsent(identifier, new HashMap());
                currentPositions.putIfAbsent(identifier, new HashMap());
                currentScaling.putIfAbsent(identifier, new HashMap());
                Object[][] modelParts = AnimationUtils.getIdentifierParts(identifier);
                for (int partNum = 0; partNum < modelParts.length; ++partNum) {
                    String modelPart = (String)modelParts[partNum][0];
                    double[] defaultEntry = new double[]{0.0, 0.0, 0.0};
                    currentRotations.get(identifier).put(modelPart, defaultEntry);
                    currentPositions.get(identifier).put(modelPart, defaultEntry);
                    defaultEntry = new double[]{1.0, 1.0, 1.0};
                    currentScaling.get(identifier).put(modelPart, defaultEntry);
                }
            }
        }
        AnimationUtils.animateModel();
    }

    public static void newBodyRender(EntityLivingBase entity, boolean hasTextures) {
        if (!isEnabled || !hasTextures && textures) {
            return;
        }
        Body.validateModelPlacements();
        double offsetX = 1.25;
        double offsetY = -1.505;
        double offsetZ = 0.0;
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        Body.bodyCharacterRender(entity);
        Body.bodyUpperHalfRender(entity);
        Body.bodyLowerHalfRender(entity);
        GL11.glPopMatrix();
    }

    static void bodyCharacterRender(EntityLivingBase entity) {
        Body.OBJBodyRender(entity, 0);
    }

    static void bodyUpperHalfRender(EntityLivingBase entity) {
        GL11.glPushMatrix();
        Body.OBJBodyRender(entity, 2);
        Body.bodyHeadRender(entity);
        Body.bodyArmRender(entity, true);
        Body.bodyArmRender(entity, false);
        GL11.glPopMatrix();
    }

    static void bodyLowerHalfRender(EntityLivingBase entity) {
        GL11.glPushMatrix();
        Body.OBJBodyRender(entity, 7);
        Body.newTailRender(entity);
        Body.bodyLegRender(entity, true);
        Body.bodyLegRender(entity, false);
        GL11.glPopMatrix();
    }

    static void bodyHeadRender(EntityLivingBase entity) {
        GL11.glPushMatrix();
        Body.OBJBodyRender(entity, 1);
        GL11.glPopMatrix();
    }

    static void bodyArmRender(EntityLivingBase entity, boolean rightSide) {
        GL11.glPushMatrix();
        Body.OBJBodyRender(entity, rightSide ? 3 : 5);
        Body.OBJBodyRender(entity, rightSide ? 4 : 6);
        GL11.glPopMatrix();
    }

    static void bodyLegRender(EntityLivingBase entity, boolean rightSide) {
        GL11.glPushMatrix();
        Body.OBJBodyRender(entity, rightSide ? 8 : 10);
        Body.OBJBodyRender(entity, rightSide ? 9 : 11);
        GL11.glPopMatrix();
    }

    static void OBJBodyRender(EntityLivingBase entity, int limbNum) {
        boolean debug = false;
        boolean showPivotNode = false;
        boolean showPivotLines = true;
        boolean canRotate = true;
        boolean canPosition = true;
        boolean canScale = true;
        boolean canLimbScale = false;
        boolean brianMode = !textures;
        boolean isCharacter = limbNum == 0;
        boolean isHead = limbNum == 1;
        boolean isUpperBody = limbNum == 2;
        boolean isLowerBody = limbNum == 7;
        boolean isBody = isUpperBody || isLowerBody;
        boolean isUpperArm = limbNum == 3 || limbNum == 5;
        boolean isLowerArm = limbNum == 4 || limbNum == 6;
        boolean isArm = isUpperArm || isLowerArm;
        boolean isUpperLeg = limbNum == 8 || limbNum == 10;
        boolean isLowerLeg = limbNum == 9 || limbNum == 11;
        boolean isLeg = isUpperLeg || isLowerLeg;
        boolean isRightSide = limbNum == 3 || limbNum == 4 || limbNum == 8 || limbNum == 9;
        Object model = null;
        String modelTexture = "dbapollo:models/newBody.png";
        int modelColor = 0xFFFFFF;
        String identifier = "player";
        String modelPart = (String)newBodyParts[limbNum][0];
        double rotateXPoint = AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][1]);
        double rotateYPoint = AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][2]);
        double rotateZPoint = AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][3]);
        double scaleXPoint = rotateXPoint + AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][4]);
        double scaleYPoint = rotateYPoint + AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][5]);
        double scaleZPoint = rotateZPoint + AnimationUtils.parseBBOffset((Double)newBodyParts[limbNum][6]);
        double limbScaleX = 0.0;
        double limbScaleY = 0.0;
        double limbScaleZ = 0.0;
        if (canLimbScale && limbNum >= 1 && limbNum <= 11) {
            double scaleFactor = isHead ? 0.45 : (isLowerBody || isLeg ? 0.7 : 1.0);
            boolean average = isHead;
            double widthInput = SUBEvents.getTV(0);
            double heightInput = SUBEvents.getTV(1);
            widthInput = 0.5;
            heightInput = 0.5;
            double averageInput = (widthInput + heightInput) / 2.0;
            double widthFactor = -0.1 + 0.3 * widthInput;
            double heightFactor = -0.17241 + 0.44827 * heightInput;
            double averageFactor = -0.15 + 0.3 * averageInput;
            limbScaleX = (average ? averageFactor : widthFactor) * scaleFactor;
            limbScaleY = (average ? averageFactor : heightFactor) * scaleFactor;
            limbScaleZ = (average ? averageFactor : widthFactor) * scaleFactor;
        }
        double[] rotation = currentRotations.get(identifier).get(modelPart);
        double rotateX = rotation[0];
        double rotateY = rotation[1];
        double rotateZ = rotation[2];
        double[] position = currentPositions.get(identifier).get(modelPart);
        double positionX = AnimationUtils.parseBBOffset(position[0]);
        double positionY = AnimationUtils.parseBBOffset(position[1]);
        double positionZ = AnimationUtils.parseBBOffset(position[2]);
        if (!isUpperLeg || isRightSide) {
            // empty if block
        }
        double[] scale = currentScaling.get(identifier).get(modelPart);
        double scaleX = limbScaleX + scale[0];
        double scaleY = limbScaleY + scale[1];
        double scaleZ = limbScaleZ + scale[2];
        if (isArm) {
            positionX += (isRightSide ? 0.125 : -0.125) * limbScaleX;
        }
        if (!isUpperBody && !isUpperLeg) {
            positionY += (isCharacter ? SUBEvents.getTV(3) : (isHead ? SUBEvents.getTV(3) : (isLowerBody ? -0.515 : (isUpperArm ? 0.3 : (isLowerArm ? -0.3725 : (isLowerLeg ? -0.368 : 0.0)))))) * limbScaleY;
        }
        if (isHead || isLowerArm || isLowerLeg) {
            positionZ += (isHead ? -0.03 : (isLowerArm ? 0.10818 : (isLowerLeg ? -0.14106 : 0.0))) * limbScaleZ;
        }
        if (isHead) {
            double headYaw = -entity.field_70759_as;
            headYaw = headYaw < 0.0 ? Math.min(-SUBEvents.getTV(0).doubleValue(), headYaw) : Math.max(SUBEvents.getTV(0), headYaw);
            rotateX += (double)entity.field_70125_A;
            rotateY += headYaw;
        }
        GL11.glTranslated((double)rotateXPoint, (double)rotateYPoint, (double)rotateZPoint);
        if (canPosition) {
            GL11.glTranslated((double)positionX, (double)positionY, (double)positionZ);
        }
        if (showPivotNode) {
            RenderPlayerCustom.renderPivotNode(showPivotLines);
        }
        if (canRotate) {
            GL11.glRotated((double)(rotateX * -1.0), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotateY, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotateZ, (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glTranslated((double)(-rotateXPoint), (double)(-rotateYPoint), (double)(-rotateZPoint));
        if (canScale) {
            GL11.glTranslated((double)scaleXPoint, (double)scaleYPoint, (double)scaleZPoint);
            if (showPivotNode) {
                // empty if block
            }
            GL11.glScaled((double)scaleX, (double)scaleY, (double)scaleZ);
            GL11.glTranslated((double)(-scaleXPoint), (double)(-scaleYPoint), (double)(-scaleZPoint));
        }
        if (brianMode) {
            RenderUtils.bindTexture(modelTexture);
            RenderPlayerCustom.glColor3f(modelColor, entity);
        }
        model.renderPart(modelPart);
        if (canScale) {
            GL11.glTranslated((double)scaleXPoint, (double)scaleYPoint, (double)scaleZPoint);
            GL11.glScaled((double)Math.pow(scaleX, -1.0), (double)Math.pow(scaleY, -1.0), (double)Math.pow(scaleZ, -1.0));
            GL11.glTranslated((double)(-scaleXPoint), (double)(-scaleYPoint), (double)(-scaleZPoint));
        }
    }

    static void newTailRender(EntityLivingBase entity) {
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        for (int segmentNum = 0; segmentNum < newTailParts.length; ++segmentNum) {
            Body.OBJTailRender(entity, segmentNum);
        }
        GL11.glPopMatrix();
    }

    static void OBJTailRender(EntityLivingBase entity, int segmentNum) {
        boolean debug = false;
        boolean showPivotNode = false;
        boolean showPivotLines = true;
        Object model = null;
        String modelTexture = "dbapollo:models/newTail.png";
        int modelColor = 0xFFFFFF;
        String identifier = "tail";
        String modelPart = (String)newTailParts[segmentNum][0];
        double rotateXPoint = 0.0;
        double rotateYPoint = 0.94;
        double rotateZPoint = 0.065 + (double)segmentNum * 0.24;
        double[] rotation = currentRotations.get(identifier).get(modelPart);
        double rotateX = rotation[0];
        double rotateY = rotation[1];
        double rotateZ = rotation[2];
        double[] position = currentPositions.get(identifier).get(modelPart);
        double positionX = AnimationUtils.parseBBOffset(position[0]);
        double positionY = AnimationUtils.parseBBOffset(position[1]);
        double positionZ = AnimationUtils.parseBBOffset(position[2]);
        GL11.glTranslated((double)rotateXPoint, (double)rotateYPoint, (double)rotateZPoint);
        GL11.glRotated((double)(rotateX * -1.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotateY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotateZ, (double)0.0, (double)0.0, (double)1.0);
        if (showPivotNode) {
            RenderPlayerCustom.renderPivotNode(showPivotLines);
        }
        GL11.glTranslated((double)(-rotateXPoint), (double)(-rotateYPoint), (double)(-rotateZPoint));
        RenderUtils.bindTexture(modelTexture);
        RenderPlayerCustom.glColor3f(modelColor, entity);
        model.renderPart(modelPart);
    }
}

