/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Arrays;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Render.Camera;
import net.MCApolloNetwork.ApolloCrux.Client.Render.PlayerCliTicH;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientKeyHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderHandEvent;
import noppes.npcs.entity.EntityNPCInterface;

public class CameraUtils {
    public static Camera camera;
    public static boolean inDialog;
    public static boolean inFusion;
    public static boolean freeCam;
    public static boolean shoulderCam;
    public static boolean spinCam;
    public static int spinCount;
    public static int spinCountTarget;
    public static long manualRotationTime;
    public static double freeCamMovementDefault;
    public static double freeCamMovement;
    public static double freeCamX;
    public static double freeCamY;
    public static double freeCamZ;
    public static float freeCamYaw;
    public static float freeCamPitch;
    public static float freeCamStartYaw;
    public static float freeCamStartPitch;
    public static double cameraPosX;
    public static double cameraPosY;
    public static double cameraPosZ;
    public static double cameraYaw;
    public static double cameraPitch;
    static double playerPosX;
    static double playerPosY;
    static double playerPosZ;
    static double playerYaw;
    static double playerPitch;
    public static String spectateTarget;
    public static EntityNPCInterface dialogEntity;
    public static EntityPlayer fusionController;
    public static EntityPlayer fusionPartner;
    public static EntityPlayer spinTarget;
    static int perspectiveBefore;
    static double cameraSway;
    static double cameraSwayRate;
    static boolean cameraSwayDirection;
    public static Object[][] cinematicNodes;
    static int nodeDataTarget;
    static int cinematicDataTarget;
    static double[][][] cinematicNodeData;
    static double[][] cinematicStartPoint;
    static int cinematicPlaying;
    static int cinematicFrame;
    static boolean cinematicPositionSet;
    static long cinematicStartTime;
    static double cinematicPosX;
    static double cinematicPosY;
    static double cinematicPosZ;
    static double cinematicYaw;
    static double cinematicPitch;
    public static int cinematicWaypoint;
    public static ArrayList<double[]> cinematicWaypoints;
    static boolean removeNextWaypoints;

    public static void cleanUpCamera() {
        CameraUtils.stopSpinCamera();
        inDialog = false;
        inFusion = false;
        freeCam = false;
        shoulderCam = false;
        dialogEntity = null;
        fusionController = null;
        fusionPartner = null;
        CameraUtils.revertCamera();
    }

    public static void startSpinCamera(EntityPlayer target, int targetCount, boolean cameraSway) {
        spinCam = true;
        spinTarget = target;
        spinCount = 0;
        spinCountTarget = targetCount;
        cameraSwayRate = cameraSway ? 4.0 : 0.0;
    }

    public static void stopSpinCamera() {
        spinCam = false;
        spinTarget = null;
        spinCount = 0;
        spinCountTarget = 0;
        CameraUtils.revertCamera();
    }

    static void createCamera(EntityPlayer player, World world) {
        camera = new Camera(world);
        world.func_72838_d((Entity)camera);
        camera.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
    }

    static void revertCamera() {
        Main.mc.field_71451_h = Main.mc.field_71439_g;
        Main.mc.field_71474_y.field_74320_O = perspectiveBefore;
        if (camera != null) {
            CameraUtils.camera.field_70128_L = true;
            camera = null;
        }
    }

    public static void updateCamera(RenderHandEvent event) {
        boolean debug = false;
        EntityClientPlayerMP player = Main.mc.field_71439_g;
        WorldClient world = Main.mc.field_71441_e;
        CameraUtils.cinematicTick();
        if (CameraUtils.isCinematicPlaying()) {
            return;
        }
        if (freeCam || shoulderCam) {
            inDialog = true;
        }
        if (inDialog || inFusion || spinCam) {
            if (debug) {
                System.out.println("inDialog! camera: " + (Object)((Object)camera));
            }
            if (camera == null) {
                CameraUtils.createCamera((EntityPlayer)player, (World)world);
                perspectiveBefore = Main.mc.field_71474_y.field_74320_O;
                Main.mc.field_71474_y.field_74320_O = 1;
                if (debug) {
                    System.out.println("Created Camera, set as view Entity | " + (Object)((Object)camera));
                }
            }
        }
        if (camera != null) {
            if (debug) {
                System.out.println("view | dialog: " + inDialog + " | fusion: " + inFusion + " | spin: " + spinCam + " | camera: " + (Object)((Object)camera));
            }
            if (!(inDialog || inFusion || spinCam)) {
                if (debug) {
                    System.out.println("No Longer in Dialog, despawning Camera and Reverting View Entity");
                }
                CameraUtils.revertCamera();
                return;
            }
            double distanceX = SUBEvents.testVariables.get(0);
            double distanceY = SUBEvents.testVariables.get(1);
            double distanceZ = SUBEvents.testVariables.get(2);
            distanceX = Math.sin(Math.toRadians(player.field_70177_z)) * distanceX;
            distanceY = Math.sin(Math.toRadians(player.field_70125_A)) * distanceY;
            distanceZ = Math.cos(Math.toRadians(player.field_70177_z)) * distanceZ;
            if (freeCam) {
                CameraUtils.freeCamMovement();
                distanceX = freeCamX;
                distanceY = freeCamY;
                distanceZ = freeCamZ;
            }
            cameraPosX = player.field_70165_t + distanceX;
            cameraPosY = player.field_70163_u - (double)player.field_70131_O + distanceY;
            cameraPosZ = player.field_70161_v + distanceZ;
            cameraYaw = player.field_70177_z;
            cameraPitch = player.field_70125_A;
            if (!(!inDialog || inFusion || freeCam || shoulderCam || spinCam)) {
                cameraPosX = (player.field_70165_t + CameraUtils.dialogEntity.field_70165_t) / 2.0;
                cameraPosY = player.field_70163_u - 1.5;
                cameraPosZ = (player.field_70161_v + CameraUtils.dialogEntity.field_70161_v) / 2.0;
                cameraYaw = player.field_70177_z - 50.0f;
                cameraPitch = 15.0 + cameraSway;
            }
            if (!(!inFusion && !spinCam || inDialog || freeCam || shoulderCam)) {
                boolean canRotate = spinCam || ClientUtils.getTimeSince(manualRotationTime) > 5000L;
                Camera viewEntity = camera;
                EntityPlayer cameraTarget = spinCam ? spinTarget : fusionController;
                double moveFactor = 4.0;
                double rotationFactor = 7.5;
                double motionX = CameraUtils.cameraMovement(viewEntity.field_70165_t, cameraTarget.field_70165_t, moveFactor);
                double motionY = CameraUtils.cameraMovement(viewEntity.field_70163_u, cameraTarget.field_70163_u, moveFactor) + (inFusion ? 0.2 : -0.4);
                double motionZ = CameraUtils.cameraMovement(viewEntity.field_70161_v, cameraTarget.field_70161_v, moveFactor);
                double motionYaw = CameraUtils.cameraRotation(viewEntity.field_70177_z, (double)cameraTarget.field_70177_z - (inFusion ? 25.0 : cameraSway), rotationFactor);
                double motionPitch = CameraUtils.cameraRotation(viewEntity.field_70125_A, cameraTarget.field_70125_A + (float)(inFusion ? 10 : 0), rotationFactor);
                viewEntity.field_70159_w = motionX;
                viewEntity.field_70181_x = motionY;
                viewEntity.field_70179_y = motionZ;
                float f = canRotate ? (float)(motionYaw + (inFusion ? cameraSway / 3.0 : 0.0)) : (viewEntity.field_70177_z = player.field_70177_z);
                viewEntity.field_70125_A = canRotate ? (float)(motionPitch + (inFusion ? cameraSway / 3.0 : 0.0)) : player.field_70125_A;
                cameraPosX = PlayerCliTicH.positionPartialTicks(viewEntity.field_70165_t, viewEntity.field_70169_q, event.partialTicks);
                cameraPosY = PlayerCliTicH.positionPartialTicks(viewEntity.field_70163_u, viewEntity.field_70167_r, event.partialTicks);
                cameraPosZ = PlayerCliTicH.positionPartialTicks(viewEntity.field_70161_v, viewEntity.field_70166_s, event.partialTicks);
                if (canRotate) {
                    cameraYaw = PlayerCliTicH.positionPartialTicks(viewEntity.field_70177_z, viewEntity.field_70126_B, event.partialTicks);
                    cameraPitch = PlayerCliTicH.positionPartialTicks(viewEntity.field_70125_A, viewEntity.field_70127_C, event.partialTicks);
                }
                if (!spinCam) {
                    player.func_70012_b(cameraTarget.field_70165_t, cameraTarget.field_70163_u, cameraTarget.field_70161_v, viewEntity.field_70177_z, viewEntity.field_70125_A);
                }
                Main.mc.field_71474_y.field_74320_O = 1;
            }
            if (debug) {
                System.out.println("updateCamera posX:" + cameraPosX + " posY:" + cameraPosY + " posZ:" + cameraPosZ + " | yaw:" + cameraYaw + " pitch:" + cameraPitch);
            }
            if (debug) {
                System.out.println("player posX:" + player.field_70165_t + " posY:" + player.field_70163_u + " posZ:" + player.field_70161_v + " | yaw:" + player.field_70177_z + " pitch:" + player.field_70125_A);
            }
            if (!inFusion && !spinCam) {
                cameraYaw = CameraUtils.correctYaw(cameraYaw);
                camera.func_70080_a(cameraPosX, cameraPosY, cameraPosZ, (float)cameraYaw, (float)cameraPitch);
            }
            Main.mc.field_71451_h = camera;
        }
    }

    public static void cameraTick() {
        if (inDialog || inFusion) {
            double d = !cameraSwayDirection ? 0.02 : -0.02;
            if ((cameraSway += d) > 5.0 || cameraSway < -5.0) {
                cameraSwayDirection = !cameraSwayDirection;
            }
        } else if (spinCam) {
            if ((cameraSway += cameraSwayRate) >= (double)((spinCount + 1) * 360) && ++spinCount >= spinCountTarget) {
                CameraUtils.stopSpinCamera();
            }
        } else {
            cameraSway = 0.0;
        }
    }

    static void freeCamMovement() {
        boolean inverse;
        if (ClientKeyHandler.isKeyPressed(13) && (freeCamMovement += 0.001) > freeCamMovementDefault * 5.0) {
            freeCamMovement = freeCamMovementDefault * 5.0;
        }
        if (ClientKeyHandler.isKeyPressed(12) && (freeCamMovement -= 0.001) < freeCamMovementDefault / 5.0) {
            freeCamMovement = freeCamMovementDefault / 5.0;
        }
        freeCamYaw = Main.mc.field_71439_g.field_70177_z;
        freeCamPitch = Main.mc.field_71439_g.field_70125_A;
        double lookingX = Math.sin(Math.toRadians(freeCamYaw));
        double lookingY = Math.sin(Math.toRadians(freeCamPitch));
        double lookingZ = Math.cos(Math.toRadians(freeCamYaw));
        if (ClientKeyHandler.isKeyPressed(17) || ClientKeyHandler.isKeyPressed(31)) {
            inverse = ClientKeyHandler.isKeyPressed(31);
            freeCamX += lookingX * (!inverse ? -freeCamMovement : freeCamMovement);
            freeCamY += lookingY * (!inverse ? -freeCamMovement : freeCamMovement);
            freeCamZ += -lookingZ * (!inverse ? -freeCamMovement : freeCamMovement);
        }
        if (ClientKeyHandler.isKeyPressed(30) || ClientKeyHandler.isKeyPressed(32)) {
            inverse = ClientKeyHandler.isKeyPressed(32);
            freeCamX += -lookingX * (!inverse ? -freeCamMovement : freeCamMovement);
            freeCamZ += lookingZ * (!inverse ? -freeCamMovement : freeCamMovement);
        }
        if (ClientKeyHandler.isKeyPressed(57)) {
            freeCamY += freeCamMovement;
        }
        if (ClientKeyHandler.isKeyPressed(42)) {
            freeCamY -= freeCamMovement;
        }
    }

    static double cameraMovement(double startPos, double targetPos, double moveFactor) {
        double change = targetPos - startPos;
        return change / moveFactor;
    }

    static double cameraRotation(double startRot, double targetRot, double rotationFactor) {
        double changeRot = (targetRot - startRot) / rotationFactor;
        return startRot + changeRot;
    }

    static double correctYaw(double cameraYaw) {
        while (cameraYaw < 0.0) {
            cameraYaw += 360.0;
        }
        while (cameraYaw >= 360.0) {
            cameraYaw -= 360.0;
        }
        return cameraYaw;
    }

    public static void playCinematic(String cinematicName) {
        System.out.println("Attempting to playCinematic: \"" + cinematicName + "\"");
        int node = CameraUtils.getCinematicNode(cinematicName);
        if (node == -1) {
            System.out.println("\"" + cinematicName + "\" is not valid");
            return;
        }
        double[] nodeArray = cinematicNodeData[node][0];
        if (nodeArray.length != nodeDataTarget) {
            System.out.println("Invalid nodeArray Length: " + nodeArray.length);
            return;
        }
        EntityClientPlayerMP player = Main.mc.field_71439_g;
        playerPosX = player.field_70165_t;
        playerPosY = player.field_70163_u;
        playerPosZ = player.field_70161_v;
        playerYaw = player.field_70177_z;
        playerPitch = player.field_70125_A;
        cinematicPlaying = node;
        cinematicStartTime = System.currentTimeMillis();
    }

    public static void stopCinematic() {
        if (cinematicPlaying != -1) {
            cinematicPlaying = -1;
            cinematicFrame = 0;
            cinematicPositionSet = false;
            CameraUtils.revertCamera();
            Main.mc.field_71439_g.func_70012_b(playerPosX, playerPosY, playerPosZ, (float)playerYaw, (float)playerPitch);
        }
    }

    static void nextCinematicFrame() {
        cinematicStartTime = System.currentTimeMillis();
        cinematicPositionSet = false;
        if (++cinematicFrame > cinematicNodeData[cinematicPlaying].length) {
            CameraUtils.stopCinematic();
        } else {
            CameraUtils.playCinematicFrame();
        }
    }

    static void playCinematicFrame() {
        double endTime;
        double curTime;
        double nodeProgress;
        boolean debug = cinematicFrame <= 1;
        debug = false;
        EntityClientPlayerMP player = Main.mc.field_71439_g;
        WorldClient world = Main.mc.field_71441_e;
        boolean isReturnFrame = cinematicFrame == cinematicNodeData[cinematicPlaying].length;
        double[] nodeArray = cinematicNodeData[cinematicPlaying][isReturnFrame ? 0 : cinematicFrame];
        if (nodeArray.length != nodeDataTarget) {
            System.out.println("Invalid nodeArray Length: " + nodeArray.length + " != " + nodeDataTarget);
            return;
        }
        Object[] cinematicArray = cinematicNodes[cinematicPlaying];
        if (cinematicArray.length != cinematicDataTarget) {
            System.out.println("Invalid cinematicArray Length: " + cinematicArray.length + " != " + cinematicDataTarget);
            return;
        }
        double nodePosX = nodeArray[0];
        double nodePosY = nodeArray[1];
        double nodePosZ = nodeArray[2];
        double nodeYaw = nodeArray[3];
        double nodePitch = nodeArray[4];
        String nodeName = (String)cinematicArray[0];
        double nodeTime = (Double)cinematicArray[1];
        double nodeSpeed = (Double)cinematicArray[2];
        Vec3 cinematicTarget = Vec3.func_72443_a((double)nodePosX, (double)nodePosY, (double)nodePosZ);
        Vec3 cinematicStart = Vec3.func_72443_a((double)cinematicPosX, (double)cinematicPosY, (double)cinematicPosZ);
        double sqDis = cinematicStart.func_72438_d(cinematicTarget);
        double speedFactor = sqDis / nodeSpeed;
        nodeTime *= speedFactor;
        if (debug) {
            System.out.println("playCinematicFrame #" + cinematicFrame);
        }
        if ((nodeProgress = (curTime = (double)(System.currentTimeMillis() - cinematicStartTime)) / (endTime = nodeTime)) >= 1.0 || !cinematicPositionSet && cinematicFrame == 0) {
            cinematicPositionSet = true;
            cinematicPosX = nodePosX;
            cinematicPosY = nodePosY;
            cinematicPosZ = nodePosZ;
            cinematicYaw = nodeYaw;
            cinematicPitch = nodePitch;
            if (debug) {
                System.out.println("Set Position");
            }
            if (nodeProgress >= 1.0) {
                if (debug) {
                    System.out.println(" - Next Frame");
                }
                CameraUtils.nextCinematicFrame();
                return;
            }
        }
        double newPosX = CameraUtils.getProgress(cinematicPosX, nodePosX, nodeProgress, 0);
        double newPosY = CameraUtils.getProgress(cinematicPosY, nodePosY, nodeProgress, 1);
        double newPosZ = CameraUtils.getProgress(cinematicPosZ, nodePosZ, nodeProgress, 2);
        double newYaw = CameraUtils.getProgress(cinematicYaw, nodeYaw, nodeProgress, 3);
        double newPitch = CameraUtils.getProgress(cinematicPitch, nodePitch, nodeProgress, 4);
        if (debug) {
            System.out.println("Node: #" + cinematicFrame + " | progress: " + nodeProgress + " | pos: " + newPosX + "_" + newPosY + "_" + newPosZ + " | rot: " + newYaw + "_" + newPitch);
        }
        if (camera == null) {
            CameraUtils.createCamera((EntityPlayer)player, (World)world);
        }
        camera.func_70080_a(newPosX, newPosY, newPosZ, (float)newYaw, (float)newPitch);
        Main.mc.field_71451_h = camera;
    }

    public static void showCinematicTextures(Minecraft mc) {
        if (!CameraUtils.isCinematicPlaying()) {
            return;
        }
    }

    static double getProgress(double startPos, double targetPos, double nodeProgress, int type) {
        boolean debug = true;
        boolean rightTurn = targetPos > startPos;
        double difference = (targetPos - startPos) * nodeProgress;
        double result = startPos + difference;
        if (type == 3 && debug) {
            System.out.println("#3 change: " + difference + " = " + result + " (turnType: " + rightTurn + ")");
        }
        return result;
    }

    public static void cinematicTick() {
        if (CameraUtils.isCinematicPlaying()) {
            CameraUtils.playCinematicFrame();
        }
    }

    static boolean isCinematicPlaying() {
        return cinematicPlaying != -1;
    }

    static int getCinematicNode(String cinematicName) {
        for (int node = 0; node < cinematicNodes.length; ++node) {
            String cinematicNodeName = (String)cinematicNodes[node][0];
            if (!cinematicName.equalsIgnoreCase(cinematicNodeName)) continue;
            return node;
        }
        return -1;
    }

    public static void saveKeyFrame() {
        if (removeNextWaypoints) {
            removeNextWaypoints = false;
            cinematicWaypoints.clear();
            cinematicWaypoint = -1;
        }
        EntityClientPlayerMP player = Main.mc.field_71439_g;
        double[] nodeArray = new double[]{player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, CameraUtils.correctYaw(player.field_70177_z), player.field_70125_A};
        cinematicWaypoints.add(nodeArray);
    }

    public static void deleteKeyFrame(int number) {
        cinematicWaypoints.remove(number);
    }

    static String keyFrameString(double[] nodeArray, int number) {
        return "{" + (int)nodeArray[0] + ", " + (int)nodeArray[1] + ", " + (int)nodeArray[2] + ", " + (int)nodeArray[3] + ", " + (int)nodeArray[4] + "}, // #" + number;
    }

    public static void copyKeyFrames() {
        String keyFrames = "";
        for (int i = 0; i < cinematicWaypoints.size(); ++i) {
            double[] nodeArray = cinematicWaypoints.get(i);
            String keyFrame = CameraUtils.keyFrameString(nodeArray, i);
            keyFrames = Methods.addToExisting((String)keyFrames, (String)keyFrame, (String)"\n", (boolean)true);
        }
        if (!keyFrames.isEmpty()) {
            StringSelection selection = new StringSelection(keyFrames);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
    }

    public static void clearKeyFrames() {
        cinematicWaypoints.clear();
        cinematicWaypoint = -1;
    }

    public static void cinematicWaypoints(String input) {
        int target = -1;
        for (int node = 0; node < cinematicNodes.length; ++node) {
            String cinematicNodeName = (String)cinematicNodes[node][0];
            if (!input.equalsIgnoreCase(cinematicNodeName)) continue;
            target = node;
            break;
        }
        if (target != -1) {
            System.out.println("cinematicWaypoints: " + target + " from: " + input);
            cinematicWaypoints.clear();
            cinematicWaypoint = target;
            removeNextWaypoints = true;
            for (int i = 0; i < cinematicNodeData[target].length; ++i) {
                double[] nodeArray = cinematicNodeData[target][i];
                System.out.println("Added Waypoint Node #" + i + " | " + Arrays.toString(nodeArray));
                cinematicWaypoints.add(nodeArray);
            }
        }
    }

    static {
        spinCount = 0;
        spinCountTarget = 0;
        manualRotationTime = 0L;
        freeCamMovement = freeCamMovementDefault = 0.05;
        freeCamX = 0.0;
        freeCamY = 0.0;
        freeCamZ = 0.0;
        freeCamYaw = 0.0f;
        freeCamPitch = 0.0f;
        freeCamStartYaw = 0.0f;
        freeCamStartPitch = 0.0f;
        cameraPosX = 0.0;
        cameraPosY = 0.0;
        cameraPosZ = 0.0;
        cameraYaw = 0.0;
        cameraPitch = 0.0;
        playerPosX = 0.0;
        playerPosY = 0.0;
        playerPosZ = 0.0;
        playerYaw = 0.0;
        playerPitch = 0.0;
        spectateTarget = null;
        dialogEntity = null;
        fusionPartner = null;
        spinTarget = null;
        perspectiveBefore = 0;
        cameraSway = 0.0;
        cameraSwayRate = 0.0;
        cameraSwayDirection = false;
        cinematicNodes = new Object[][]{{"test", 1500.0, 15.0}, {"spawn", 1500.0, 15.0}, {"trailer0", 1500.0, 15.0}, {"trailer1", 1500.0, 15.0}, {"trailer2", 1500.0, 15.0}, {"trailer3", 1500.0, 15.0}, {"trailer4", 1500.0, 15.0}, {"trailer5", 1500.0, 15.0}, {"trailer6", 1500.0, 15.0}, {"trailer7", 1500.0, 15.0}};
        nodeDataTarget = 5;
        cinematicDataTarget = 3;
        cinematicNodeData = new double[][][]{new double[][]{{706.0, 64.0, -958.0, 90.0, 0.0}, {753.0, 66.0, -957.0, 0.0, -25.0}, {755.0, 64.0, -986.0, -90.0, 0.0}, {692.0, 66.0, -998.0, -180.0, 15.0}}, new double[][]{{0.0, 50.0, 37.0, 0.0, 25.0}, {33.0, 50.0, 0.0, -90.0, 0.0}, {0.0, 50.0, -37.0, -180.0, 25.0}, {-37.0, 50.0, 0.0, -270.0, 0.0}}, new double[][]{{-8910.0, 57.0, -14430.0, 96.0, 0.0}, {-8967.0, 59.0, -14436.0, 58.0, -9.0}, {-9067.0, 85.0, -14395.0, 349.0, -11.0}, {-9015.0, 90.0, -14267.0, 277.0, -4.0}, {-8838.0, 72.0, -14253.0, 293.0, -5.0}, {-8789.0, 95.0, -14227.0, 119.0, 0.0}, {-8789.0, 95.0, -14227.0, 119.0, 0.0}}, new double[][]{{-8893.0, 55.0, -14433.0, 84.0, -4.0}, {-8893.0, 55.0, -14433.0, 84.0, -4.0}, {-8906.0, 57.0, -14432.0, 84.0, 0.0}, {-8930.0, 57.0, -14429.0, 82.0, -2.0}, {-8956.0, 63.0, -14428.0, 63.0, -1.0}, {-8981.0, 63.0, -14408.0, 85.0, -3.0}}, new double[][]{{-8908.0, 52.0, -14257.0, 112.0, 0.0}, {-8918.0, 53.0, -14256.0, 126.0, -1.0}, {-8922.0, 53.0, -14265.0, 108.0, -1.0}, {-8930.0, 53.0, -14262.0, 143.0, -2.0}, {-8934.0, 53.0, -14270.0, 125.0, -4.0}, {-8942.0, 53.0, -14279.0, 120.0, 1.0}, {-8947.0, 53.0, -14281.0, 81.0, 3.0}, {-8954.0, 53.0, -14274.0, 110.0, 4.0}, {-8966.0, 53.0, -14281.0, 91.0, 2.0}, {-8977.0, 53.0, -14277.0, 100.0, -7.0}, {-8990.0, 57.0, -14270.0, 80.0, -11.0}, {-9005.0, 64.0, -14263.0, 97.0, -18.0}, {-9019.0, 74.0, -14270.0, 94.0, -25.0}, {-9034.0, 81.0, -14262.0, 102.0, -23.0}}, new double[][]{{-8755.0, 55.0, -14191.5, 270.0, -3.0}, {-8736.0, 57.0, -14191.5, 270.0, -2.0}, {-8714.0, 57.0, -14191.5, 301.0, -6.0}, {-8684.0, 62.0, -14181.0, 328.0, -15.0}, {-8665.0, 65.0, -14168.0, 9.0, -14.0}, {-8651.0, 65.0, -14137.0, 25.0, -15.0}, {-8651.0, 65.0, -14110.0, 48.0, -16.0}, {-8665.0, 73.0, -14076.0, 79.0, -16.0}, {-8691.0, 73.0, -14053.0, 110.0, -16.0}, {-8732.0, 79.0, -14051.0, 140.0, -15.0}, {-8742.0, 90.0, -14075.0, 98.0, -22.0}, {-8771.0, 101.0, -14079.0, 90.0, 1.0}}, new double[][]{{-8446.0, 72.0, -12893.0, 134.0, -7.0}, {-8458.0, 74.0, -12898.0, 141.0, -3.0}, {-8473.0, 74.0, -12907.0, 177.0, 0.0}, {-8485.0, 74.0, -12920.0, 190.0, -2.0}, {-8491.0, 74.0, -12938.0, 204.0, 0.0}, {-8477.0, 74.0, -12944.0, 188.0, 0.0}, {-8463.0, 79.0, -12962.0, 164.0, -7.0}, {-8477.0, 79.0, -12981.0, 173.0, -6.0}, {-8477.0, 79.0, -13008.0, 228.0, -3.0}, {-8469.0, 79.0, -13024.0, 250.0, -4.0}, {-8457.0, 79.0, -13031.0, 272.0, -3.0}, {-8443.0, 79.0, -13046.0, 275.0, -3.0}, {-8418.0, 79.0, -13039.0, 254.0, -5.0}, {-8396.0, 79.0, -13039.0, 305.0, 8.0}, {-8385.0, 79.0, -13021.0, 292.0, 5.0}, {-8361.0, 79.0, -13010.0, 354.0, 15.0}}, new double[][]{{-9492.0, 65.0, -13384.0, 270.0, 0.0}, {-9472.0, 65.0, -13384.0, 270.0, -5.0}, {-9455.0, 65.0, -13384.0, 270.0, -10.0}, {-9449.0, 65.0, -13387.0, 179.0, 0.0}, {-9448.0, 65.0, -13397.0, 179.0, 0.0}, {-9448.0, 65.0, -13407.0, 179.0, 0.0}, {-9448.0, 65.0, -13421.0, 179.0, 0.0}, {-9448.0, 65.0, -13429.0, 179.0, 0.0}, {-9448.0, 65.0, -13458.0, 179.0, 0.0}, {-9448.0, 65.0, -13473.0, 179.0, 0.0}, {-9451.0, 65.0, -13480.0, 90.0, -3.0}, {-9462.0, 65.0, -13480.0, 90.0, -3.0}, {-9498.0, 65.0, -13480.0, 90.0, -3.0}, {-9525.0, 76.0, -13480.0, 90.0, -3.0}}, new double[][]{{-10050.0, 81.0, -13942.0, 239.0, 2.0}, {-10014.0, 81.0, -13960.0, 231.0, 0.0}, {-9989.0, 79.0, -13980.0, 215.0, -2.0}, {-9980.0, 79.0, -13997.0, 192.0, -2.0}, {-9981.0, 79.0, -14018.0, 157.0, -1.0}, {-9994.0, 79.0, -14036.0, 131.0, -2.0}, {-10010.0, 80.0, -14047.0, 121.0, 0.0}, {-10020.0, 82.0, -14054.0, 180.0, -19.0}, {-10020.0, 86.0, -14064.0, 180.0, -19.0}}, new double[][]{{-8740.0, 56.0, -14191.0, 90.0, 1.0}, {-8767.0, 56.0, -14192.0, 99.0, 1.0}, {-8782.0, 55.0, -14195.0, 121.0, 0.0}, {-8794.0, 55.0, -14202.0, 137.0, 0.0}, {-8800.0, 55.0, -14219.0, 151.0, 0.0}, {-8809.0, 55.0, -14231.0, 142.0, 0.0}, {-8815.0, 62.0, -14240.0, 134.0, -5.0}, {-8806.0, 55.0, -14256.0, 78.0, -7.0}, {-8814.0, 62.0, -14264.0, 52.0, -7.0}, {-8828.0, 64.0, -14254.0, 61.0, -12.0}, {-8841.0, 68.0, -14246.0, 65.0, -9.0}, {-8852.0, 68.0, -14243.0, 77.0, -15.0}, {-8877.0, 84.0, -14238.0, 77.0, -15.0}}};
        cinematicStartPoint = new double[][]{{706.0, 64.0, -958.0, 0.0, 0.0}, {0.0, 36.0, 0.0, 90.0, 0.0}, {-8949.0, 79.0, -14442.0, 125.0, 3.0}};
        cinematicPlaying = -1;
        cinematicFrame = 0;
        cinematicPositionSet = false;
        cinematicStartTime = 0L;
        cinematicPosX = 0.0;
        cinematicPosY = 0.0;
        cinematicPosZ = 0.0;
        cinematicYaw = 0.0;
        cinematicPitch = 0.0;
        cinematicWaypoint = -1;
        cinematicWaypoints = new ArrayList();
        removeNextWaypoints = false;
    }
}

