/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Client.Utils;

import JinRyuu.JRMCore.JRMCoreH;
import codechicken.nei.NEIClientConfig;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.Events.SUBEvents;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.EscapeSettings.Prompt;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.HairEditor;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.CharacterUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.Config.ApolloConfig;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.DisplayUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.LaunchInfo;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.SoundUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.EnumChatFormatting;

public class FileWalker {
    public static String apolloConfig = "/config/Apollo/ApolloConfig.cfg";
    public static String runCount = "/config/Apollo/ApolloRunCount.txt";
    public static String specialOptions = "/config/Apollo/ApolloSpecialOptions.txt";
    public static String defaultSettings = "/config/Apollo/DefaultSettings.txt";
    public static String testVariables = "/config/Apollo/TestVariables.txt";
    public static String hairPresets = "/config/Apollo/Hair Editor Presets";
    public static String characterPresets = "/config/Apollo/Character Presets";
    public static String launchInfo = "/config/Apollo/LaunchInfo.txt";
    public static boolean specialOptionsLoaded = false;
    static boolean isNEIInstalled = false;
    public static boolean loadSet = false;
    public static int characterRenderCalls = 0;
    public static int auraRenderCalls = 0;
    public static int particleRenderCalls = 0;
    static ArrayList<String> fpsRecordFPS = new ArrayList();
    static ArrayList<String> fpsRecordChunk = new ArrayList();
    static ArrayList<Integer> fpsRecordCharacter = new ArrayList();
    static ArrayList<Integer> fpsRecordAura = new ArrayList();
    static ArrayList<Integer> fpsRecordParticle = new ArrayList();
    static ArrayList<Integer> fpsRecordTime = new ArrayList();
    static int fpsStartTime = 0;
    static int fpsLastRecordedTime = 0;
    public static boolean fpsProfilerActive = false;
    static boolean debugFPSProfiler = false;
    static boolean debugHairPreset = false;
    static boolean debugCharacterPreset = false;

    public static void validateConfigFiles() {
        String userDir = System.getProperty("user.dir");
        FileWalker.attemptMoveFile(userDir, apolloConfig);
        FileWalker.attemptMoveFile(userDir, runCount);
        FileWalker.attemptMoveFile(userDir, specialOptions);
        FileWalker.attemptMoveFile(userDir, defaultSettings);
        FileWalker.attemptMoveFile(userDir, testVariables);
    }

    public static String getModInfo(String modName, String infoType) {
        File[] listOfFiles;
        boolean debug = false;
        String info = null;
        String userDir = System.getProperty("user.dir");
        File folder = new File(userDir + "/mods");
        for (File file : listOfFiles = folder.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getName();
                if (debug) {
                    System.out.println("File " + fileName);
                }
                if (!fileName.contains(modName)) continue;
                if (debug) {
                    System.out.println("is " + modName);
                }
                info = infoType.equalsIgnoreCase("build") ? fileName.split(".b")[1].split("-")[0] : fileName.split("v")[1].split(".b")[0];
                break;
            }
            if (!file.isDirectory() || !debug) continue;
            System.out.println("Directory " + file.getName());
        }
        if (debug) {
            System.out.println("userDir: " + userDir);
        }
        return info;
    }

    public static ArrayList<String> getModList(boolean outOfDateOnly) {
        ArrayList<String> modList = new ArrayList<String>();
        String userDir = System.getProperty("user.dir");
        File folder = new File(userDir + "/mods");
        File[] listOfFiles = folder.listFiles();
        try {
            for (File file : listOfFiles) {
                String indicator;
                String color;
                if (!file.isFile()) continue;
                String fileName = file.getName();
                boolean isApolloMod = fileName.contains("Apollo");
                int jarBuild = Main.serverBuild;
                if (isApolloMod && fileName.contains(".b")) {
                    jarBuild = Integer.parseInt(fileName.split(".b")[1].split("-")[0]);
                }
                boolean apolloOutDated = !fileName.contains("v" + Main.serverVersion + ".b" + Main.serverBuild) && jarBuild <= Main.serverBuild;
                boolean isCoreMod = fileName.contains("CustomNPC-Plus") || fileName.contains("DragonBlockC") || fileName.contains("JRMCore") || fileName.contains("ironchest") || fileName.contains("CodeChickenCore") || fileName.contains("NotEnoughItems") || fileName.contains("fastcraft") || fileName.contains("neodymium") || fileName.contains("ReAuth");
                boolean coreOutDated = fileName.contains("CustomNPC-Plus") && !fileName.contains("1.7.jar") || fileName.contains("DragonBlockC") && !fileName.contains("v1.4.67") || fileName.contains("JRMCore") && !fileName.contains("v1.3.28") || fileName.contains("JBRA") && !fileName.contains("1.6.42") || fileName.contains("ironchest") && !fileName.contains("1.7.10-6.0.62.742") || fileName.contains("CodeChickenCore") && !fileName.contains("1.7.10-1.0.7.48") || fileName.contains("NotEnoughItems") && !fileName.contains("1.7.10-1.0.5.120") || fileName.contains("fastcraft") && !fileName.contains("1.25") || fileName.contains("neodymium") && !fileName.contains("0.1.8.4") || fileName.contains("ReAuth") && !fileName.contains("4.0.7");
                boolean deletedMod = fileName.contains("ApolloCrux-Core") || fileName.contains("ApolloCrux-Library") || fileName.contains("JBRA") || fileName.contains("ResourceLoader") || fileName.contains("CustomMainMenu") || fileName.contains("extrablocks") || fileName.contains("Armourers-Workshop") || fileName.contains("ArchitectureCraft");
                boolean issueMod = fileName.contains("journeymap");
                if (fileName.contains("OptiFine")) {
                    LaunchInfo.hasOptifine = true;
                }
                if (fileName.contains("fastcraft")) {
                    LaunchInfo.hasFastCraft = true;
                }
                if (fileName.contains("BetterFps")) {
                    LaunchInfo.hasBetterFPS = true;
                }
                if (fileName.contains("neodymium")) {
                    LaunchInfo.hasNeodymium = true;
                }
                if (fileName.contains("CoreTweaks")) {
                    LaunchInfo.hasCoreTweaks = true;
                }
                String string = isApolloMod ? (apolloOutDated ? "" + EnumChatFormatting.RED : "" + EnumChatFormatting.GREEN) : (isCoreMod ? (coreOutDated ? "" + EnumChatFormatting.RED : "" + EnumChatFormatting.GREEN) : (deletedMod ? "" + EnumChatFormatting.DARK_RED : (color = issueMod ? "" + EnumChatFormatting.YELLOW : "" + EnumChatFormatting.GRAY)));
                String string2 = isApolloMod ? (apolloOutDated ? "Out Dated" : " ") : (isCoreMod ? (coreOutDated ? "Out Dated" : " ") : (deletedMod ? "This mod is no longer needed / used" : (indicator = issueMod ? "This mod is known to cause issues" : "Your Addition ")));
                if (!outOfDateOnly || outOfDateOnly && isApolloMod && apolloOutDated || isCoreMod && coreOutDated || deletedMod || issueMod) {
                    modList.add(color + indicator + "-s-" + color + " | " + fileName);
                }
                if (!fileName.contains("NotEnoughItems")) continue;
                isNEIInstalled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modList;
    }

    public static void handleRunCount() {
        int existingRuns = 1;
        try {
            String userDir = System.getProperty("user.dir");
            try {
                BufferedReader reader = new BufferedReader(new FileReader(userDir + runCount));
                String textContents = reader.readLine();
                if (Methods.isNumeric((String)textContents)) {
                    existingRuns = Integer.parseInt(textContents) + 1;
                }
                reader.close();
            }
            catch (Exception reader) {
                // empty catch block
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + runCount));
            writer.write("" + existingRuns);
            writer.close();
            Main.runCount = existingRuns;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void handleSpecialOptions(int type, boolean updateOptions) {
        boolean debug = false;
        if (debug) {
            System.out.println("handleSpecialOptions is running");
        }
        int fpsFromFile = DisplayUtils.fpsLimitB4;
        float soundLevelFromFile = SoundUtils.soundLevelB4;
        boolean fpsCheck = ApolloConfig.limitFPSMinimized || ApolloConfig.limitFPSUnfocused;
        boolean soundCheck = ApolloConfig.soundWhileMinimized || ApolloConfig.soundWhileUnfocused;
        try {
            String userDir = System.getProperty("user.dir");
            try {
                BufferedReader reader;
                String textContents;
                if (debug) {
                    System.out.println("Loading Options from File");
                }
                if (Methods.isNumeric((String)(textContents = (reader = new BufferedReader(new FileReader(userDir + specialOptions))).readLine().split(": ")[1].split(" ##")[0])) && fpsCheck) {
                    if (!updateOptions) {
                        Main.mc.field_71474_y.field_74350_i = Integer.parseInt(textContents);
                        if (debug) {
                            System.out.println("- Setting FPS Limit: " + Integer.parseInt(textContents));
                        }
                    } else if (type != 0) {
                        fpsFromFile = Integer.parseInt(textContents);
                        if (debug) {
                            System.out.println("- Reading FPS Limit: " + Integer.parseInt(textContents));
                        }
                    }
                }
                if (Methods.isFloateric((String)(textContents = reader.readLine().split(": ")[1].split(" ##")[0])) && soundCheck) {
                    if (!updateOptions) {
                        Main.mc.field_71474_y.func_151439_a(SoundCategory.MASTER, Float.parseFloat(textContents));
                        if (debug) {
                            System.out.println("- Setting Sound Level: " + Float.parseFloat(textContents));
                        }
                    } else if (type != 1) {
                        soundLevelFromFile = Float.parseFloat(textContents);
                        if (debug) {
                            System.out.println("- Reading Sound Level: " + Float.parseFloat(textContents));
                        }
                    }
                }
                reader.close();
            }
            catch (Exception reader) {
                // empty catch block
            }
            if (updateOptions && (fpsCheck || soundCheck)) {
                if (debug) {
                    System.out.println("Settings Options in File");
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + specialOptions));
                if (debug) {
                    System.out.println("- Setting FPS Limit: " + fpsFromFile);
                }
                writer.write("FPS Limit: " + fpsFromFile + " ## FPS Limit before Minimize / Not Focused");
                if (debug) {
                    System.out.println("- Setting Sound Level: " + soundLevelFromFile);
                }
                writer.write("\nSound Level: " + soundLevelFromFile + " ## Sound Level before Minimize / Not Focused");
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void validateSettings() {
        String[] removalTargets;
        File defaultSettingsFile;
        File options;
        boolean noDirectory;
        String userDir = System.getProperty("user.dir");
        File directory = new File(userDir + "/config/Apollo");
        boolean bl = noDirectory = !directory.exists();
        if (noDirectory) {
            FileWalker.makeDirectory(userDir + "/config/Apollo");
        }
        if (!(options = new File(userDir + "/options.txt")).exists()) {
            FileWalker.generateDefaultSettings("/options.txt");
            FileWalker.generateDefaultSettings(defaultSettings);
        }
        if (!(defaultSettingsFile = new File(userDir + defaultSettings)).exists()) {
            FileWalker.generateDefaultSettings(defaultSettings);
        }
        FileWalker.validateShaders(userDir);
        FileWalker.generateLaunchInfo(true);
        for (String target : removalTargets = new String[]{"armourersWorkshop", "ArchitectureCraft.cfg", "BensConfig_JRMCore.cfg"}) {
            File removalTarget = new File(userDir + "/config/" + target);
            FileWalker.deleteFile(removalTarget);
        }
        File oldHairFile = new File(userDir + "/config/jinryuujrmcore.dat");
        if (oldHairFile.exists()) {
            System.out.println("\"jinryuujrmcore.dat\" exists");
            String rawString = JRMCoreH.rld((String)"HairPresets", (String)"jinryuujrmcore.dat");
            List<Object> oldHairPresets = Collections.emptyList();
            if (rawString.length() > 3) {
                oldHairPresets = Arrays.asList(rawString.split(","));
            }
            ArrayList hairPresets = new ArrayList(oldHairPresets);
            for (int preset = 0; preset < hairPresets.size(); ++preset) {
                String hairCode = (String)hairPresets.get(preset);
                System.out.println("hairCode: #" + (preset + 1) + " exists");
                FileWalker.setHairPresetFile(userDir, preset, hairCode);
            }
            System.out.println("\"jinryuujrmcore.dat\" transferred all Presets to New Hair Preset Format");
            FileWalker.deleteFile(oldHairFile);
        }
        if (isNEIInstalled) {
            FileWalker.validateNEISettings();
        }
    }

    public static void generateDefaultSettings(String fileLocation) {
        String userDir = System.getProperty("user.dir");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + fileLocation));
            if (fileLocation.contains("DefaultSettings.txt")) {
                writer.write("## These are the default settings for the options.txt file, paste them in that file if you want to revert to these ##\n");
            }
            writer.write("gamma:1.0");
            writer.write("\nrenderDistance:8");
            writer.write("\nguiScale:3");
            writer.write("\nmaxFps:260");
            writer.write("\nfancyGraphics:false");
            writer.write("\nclouds:false");
            writer.write("\nresourcePacks:[\"DBApolloRemastered - Core Pack.zip\"]");
            writer.write("\nenableVsync:false");
            writer.write("\nsoundCategory_master:0.10");
            writer.write("\nsoundCategory_music:0.05");
            writer.write("\nsoundCategory_record:1.0");
            writer.write("\nsoundCategory_weather:1.0");
            writer.write("\nsoundCategory_block:0.25");
            writer.write("\nsoundCategory_hostile:0.2");
            writer.write("\nsoundCategory_neutral:0.2");
            writer.write("\nsoundCategory_player:0.4");
            writer.write("\nsoundCategory_ambient:1.0");
            writer.write("\nkey_key.streamStartStop:0");
            writer.write("\nkey_key.streamPauseUnpause:0");
            writer.write("\nkey_of.key.zoom:0");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void generateSplashProperties(String fileLocation) {
        String userDir = System.getProperty("user.dir");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + fileLocation));
            writer.write("#Splash screen properties");
            writer.write("\n#Sat May 20 14:44:25 CDT 2023");
            writer.write("\nlogoTexture=textures/gui/title/mojang.png");
            writer.write("\nbackground=0xFFFFFF");
            writer.write("\nfont=0x000000");
            writer.write("\nbarBackground=0x422E1E");
            writer.write("\nbarBorder=0x000000");
            writer.write("\nrotate=false");
            writer.write("\nbar=0xEEC71E");
            writer.write("\nenabled=true");
            writer.write("\nresourcePackPath=resources");
            writer.write("\nlogoOffset=0");
            writer.write("\nforgeTexture=fml\\:textures/gui/forge.gif");
            writer.write("\nfontTexture=textures/font/ascii.png\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void validateNEISettings() {
        String userDir = System.getProperty("user.dir");
        File neiConfig = new File(userDir + "/config/NEI/client.cfg");
        File neiConfigDefault = new File(userDir + "/config/NEI/clientDefault.txt");
        if (!neiConfigDefault.exists()) {
            FileWalker.generateNEISettings();
        }
    }

    public static void generateNEISettings() {
        boolean debug = false;
        String userDir = System.getProperty("user.dir");
        int cheatMode = NEIClientConfig.getIntSetting((String)"inventory.cheatmode");
        if (debug) {
            System.out.println("cheatMode: " + cheatMode);
        }
        if (cheatMode != 0) {
            NEIClientConfig.setIntSetting((String)"inventory.cheatmode", (int)0);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + "/config/NEI/clientDefault.txt"));
            writer.write("# Cheat Mode was set to 0");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void generateLaunchInfo(boolean check) {
        String userDir = System.getProperty("user.dir");
        File launchInfoFile = new File(userDir + launchInfo);
        if (!launchInfoFile.exists() && check) {
            LaunchInfo.firstTimePrompt = true;
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + launchInfo));
            writer.write(Prompt.launchInfoHeader);
            for (int setting = 0; setting < LaunchInfo.launchInfoEntries.length; ++setting) {
                String launchInfoEntry = LaunchInfo.launchInfoEntries[setting];
                writer.write("\n" + launchInfoEntry + ": " + LaunchInfo.getLaunchInfo(setting, false));
            }
            writer.write("\n");
            writer.write("\nYou Opted " + (ApolloConfig.sendLaunchInfo ? "In to" : "Out of") + " Data Sending, Basic System Data will " + (ApolloConfig.sendLaunchInfo ? "be sent" : "not be sent"));
            writer.write("\nDeleting this will allow you to change your option (On next Launch) or you can change it in the Player Settings");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static boolean canUseTestVariables() {
        if (Main.mc.field_71441_e != null && Main.mc.field_71439_g != null) {
            String playerName = Main.mc.field_71439_g.func_70005_c_();
            return FileWalker.canUseTestVariables(playerName);
        }
        return false;
    }

    public static boolean canUseTestVariables(String playerName) {
        return playerName.equals("XeroZon") || playerName.equals("MunchkinBoy") || playerName.equals("PreciseRook") || playerName.equals("Kat_The_Neko");
    }

    public static void setTestVariables(String testVariables) {
        testVariables = testVariables.split(":")[1].replaceAll(" ", "");
        String[] list = testVariables.split(",");
        for (int i = 0; i < list.length; ++i) {
            SUBEvents.testVariables.set(i, Double.parseDouble(list[i]));
        }
        FileWalker.generateTestVariables(list.length);
    }

    public static void generateTestVariables(int amount) {
        String userDir = System.getProperty("user.dir");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + testVariables));
            writer.write("## These are the last saved Test Variables ##");
            writer.write("\n");
            StringBuilder tv = new StringBuilder("tv:");
            for (int i = 0; i < amount; ++i) {
                tv.append(SUBEvents.testVariables.get(i)).append(i != amount - 1 ? "," : "");
                writer.write("\nVariable #" + i + " = " + SUBEvents.testVariables.get(i));
            }
            writer.write("\n");
            writer.write("\nloadSet: " + loadSet);
            writer.write("\n## Or an easy copy pasted version, run \"tv:load\" to load the below test variables. Or better yet enable loadSet above this ##");
            writer.write("\n" + tv);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void loadTestVariables() {
        String userDir = System.getProperty("user.dir");
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(userDir + testVariables));
            String lastLine = "";
            while ((currentLine = reader.readLine()) != null) {
                lastLine = currentLine;
            }
            FileWalker.setTestVariables(lastLine);
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void configTestVariables() {
        String userDir = System.getProperty("user.dir");
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(userDir + testVariables));
            while ((currentLine = reader.readLine()) != null) {
                if (!currentLine.contains("loadSet:")) continue;
                loadSet = currentLine.contains("true");
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadConfigTestVariables() {
        if (loadSet) {
            FileWalker.loadTestVariables();
        }
    }

    public static void toggleFPSProfiler(boolean start) {
        if (debugFPSProfiler) {
            System.out.println("toggleFPSProfiler: " + start);
        }
        if (start) {
            fpsProfilerActive = true;
            ClientUtils.addALogMessage("Toggled FPS Profiler ON");
        } else if (FileWalker.generateFPSLog()) {
            ClientUtils.addALogMessage("Toggled FPS Profiler OFF");
            fpsProfilerActive = false;
            fpsRecordFPS.clear();
            fpsRecordChunk.clear();
            fpsRecordTime.clear();
        }
    }

    public static void runFPSProfiler() {
        if (!fpsProfilerActive) {
            return;
        }
        String curFPS = Minecraft.func_71410_x().field_71426_K;
        String curChunks = curFPS.split(", ")[1].replace(" chunk updates", "");
        curFPS = curFPS.split(", ")[0].replace(" fps", "");
        int curCharacter = characterRenderCalls;
        characterRenderCalls = 0;
        int curAura = auraRenderCalls;
        auraRenderCalls = 0;
        int curParticle = particleRenderCalls;
        particleRenderCalls = 0;
        int curTime = (int)(System.currentTimeMillis() / 1000L);
        if (ClientUtils.getTimeSince(fpsLastRecordedTime) > 0) {
            if (fpsStartTime == 0) {
                fpsStartTime = curTime;
            }
            int readableTime = curTime - fpsStartTime;
            if (debugFPSProfiler) {
                System.out.println("runFPSProfiler: " + readableTime + " : " + curFPS);
            }
            fpsLastRecordedTime = curTime;
            fpsRecordFPS.add(curFPS);
            fpsRecordChunk.add(curChunks);
            fpsRecordCharacter.add(curCharacter);
            fpsRecordAura.add(curAura);
            fpsRecordParticle.add(curParticle);
            fpsRecordTime.add(readableTime);
        }
    }

    public static boolean generateFPSLog() {
        if (debugFPSProfiler) {
            System.out.println("generateFPSLog");
        }
        boolean ran = false;
        if (fpsRecordFPS.size() == fpsRecordChunk.size() && fpsRecordFPS.size() == fpsRecordTime.size()) {
            String userDir = System.getProperty("user.dir");
            FileWalker.makeDirectory(userDir + "/logs/FPSProfilerLogs");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            String date = minute + "_" + hour + "-" + month + "_" + day + "_" + year;
            String fileLocation = "/logs/FPSProfilerLogs/FPSProfiler_" + date + ".txt";
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + fileLocation));
                writer.write("## This is an FPS Profiler ran on " + date + " ##");
                writer.write("\n");
                writer.write("\nTime (Seconds):Frames Per Second:Chunk Updates:Character Render:Aura Render:Particle Render");
                for (int i = 0; i < fpsRecordFPS.size(); ++i) {
                    String logFPS = fpsRecordFPS.get(i);
                    String logChunks = fpsRecordChunk.get(i);
                    int logCharacter = fpsRecordCharacter.get(i);
                    int logAura = fpsRecordAura.get(i);
                    int logParticle = fpsRecordParticle.get(i);
                    long logTime = fpsRecordTime.get(i).intValue();
                    writer.write("\n" + logTime + ":" + logFPS + ":" + logChunks + ":" + logCharacter + ":" + logAura + ":" + logParticle);
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            ClientUtils.addALogMessage("Generated \"FPSProfiler_" + date + ".txt\"");
            ran = true;
        }
        return ran;
    }

    public static void saveHairPreset(boolean firstTime, boolean autoSave) {
        int preset;
        boolean noDirectory;
        String userDir = System.getProperty("user.dir");
        File directory = new File(userDir + hairPresets);
        boolean bl = noDirectory = !directory.exists();
        if (noDirectory) {
            FileWalker.makeDirectory(userDir + hairPresets);
            for (preset = 0; preset <= CharacterCreation.hairPresetCount; ++preset) {
                FileWalker.setHairPreset(userDir, true, preset);
            }
        } else if (!firstTime) {
            FileWalker.setHairPreset(userDir, false, autoSave ? 0 : CharacterCreation.curPreset + 1);
        }
        if (firstTime) {
            for (preset = 0; preset <= CharacterCreation.hairPresetCount; ++preset) {
                File presetFile = new File(userDir + FileWalker.getHairPresetPath(preset));
                if (presetFile.exists()) continue;
                FileWalker.setHairPreset(userDir, true, preset);
            }
            FileWalker.validateHairPresetArray();
        }
    }

    public static String[] getHairPreset(int preset, boolean firstTime) {
        String userDir = System.getProperty("user.dir");
        String[] presetArray = null;
        String presetData = null;
        String creationInfo = null;
        if (CharacterCreation.presetHairData.size() > preset && !firstTime) {
            String[] array = CharacterCreation.presetHairData.get(preset);
            presetData = array[0];
            creationInfo = array[1];
            presetArray = new String[]{presetData, creationInfo};
            if (debugHairPreset) {
                System.out.println("existing #" + preset + " \"" + presetData + "\"");
            }
        } else {
            try {
                String currentLine;
                BufferedReader reader = new BufferedReader(new FileReader(userDir + FileWalker.getHairPresetPath(preset)));
                while ((currentLine = reader.readLine()) != null) {
                    if (!currentLine.startsWith("##")) {
                        presetData = currentLine;
                        continue;
                    }
                    if (!currentLine.contains("## Created on ")) continue;
                    creationInfo = currentLine;
                }
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            presetArray = new String[]{presetData, creationInfo};
            if (debugHairPreset) {
                System.out.println("get setting #" + preset + " \"" + presetData + "\"");
            }
            CharacterCreation.presetHairData.set(preset, presetArray);
        }
        return presetArray;
    }

    public static void loadHairPreset() {
        String userDir = System.getProperty("user.dir");
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(userDir + FileWalker.getHairPresetPath(CharacterCreation.curPreset)));
            String presetData = null;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.startsWith("##")) continue;
                presetData = currentLine;
            }
            HairEditor.hairCodeBefore = HairEditor.hairCode;
            HairEditor.hairCode = presetData;
            HairEditor.validateHairCode();
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setHairPreset(String userDir, boolean firstTime, int preset) {
        FileWalker.validateHairPresetArray();
        String textContents = "## Paste your Hair Code here to load it in the Hair Editor";
        if (!firstTime) {
            textContents = FileWalker.presetHeader() + "\n" + HairEditor.hairCode;
        }
        FileWalker.setHairPresetFile(userDir, preset, textContents);
    }

    public static void setHairPresetFile(String userDir, int preset, String presetData) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + FileWalker.getHairPresetPath(preset)));
            writer.write(presetData);
            if (presetData.contains("\n") && presetData.split("\n").length >= 2) {
                String[] presetArray = presetData.split("\n");
                String hairData = presetArray[1];
                String creationInfo = presetArray[0];
                CharacterCreation.presetHairData.set(preset, new String[]{hairData, creationInfo});
                if (debugHairPreset) {
                    System.out.println("set setting #" + preset + " \"" + hairData + "\"");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void validateHairPresetArray() {
        if (CharacterCreation.presetHairData.isEmpty()) {
            int preset;
            for (preset = 0; preset <= CharacterCreation.hairPresetCount; ++preset) {
                CharacterCreation.presetHairData.add(new String[]{null, null});
            }
            for (preset = 0; preset <= CharacterCreation.hairPresetCount; ++preset) {
                FileWalker.getHairPreset(preset, true);
            }
        }
    }

    static String getHairPresetPath(int preset) {
        int presetNum = preset;
        String fileName = "Hair Preset " + (presetNum < 10 ? "0" : "") + presetNum + (presetNum == 0 ? " Auto Save" : "");
        return hairPresets + "/" + fileName + ".txt";
    }

    public static void saveCharacterPreset(boolean firstTime, boolean autoSave) {
        boolean noDirectory;
        String userDir = System.getProperty("user.dir");
        File directory = new File(userDir + characterPresets);
        boolean bl = noDirectory = !directory.exists();
        if (noDirectory) {
            FileWalker.makeDirectory(userDir + characterPresets);
        } else if (!firstTime) {
            FileWalker.setCharacterPreset(userDir, false, autoSave ? 0 : CharacterCreation.curPreset + 1);
        }
        if (firstTime) {
            for (int preset = 0; preset <= CharacterCreation.characterPresetCount; ++preset) {
                File presetFile = new File(userDir + FileWalker.getCharacterPresetPath(preset));
                if (presetFile.exists()) continue;
                FileWalker.setCharacterPreset(userDir, true, preset);
            }
            FileWalker.validateCharacterPresetArray();
        }
    }

    public static String[] getCharacterPreset(int preset, boolean firstTime) {
        String userDir = System.getProperty("user.dir");
        String[] presetArray = null;
        String presetData = null;
        String creationInfo = null;
        if (CharacterCreation.presetCharacterData.size() > preset && !firstTime) {
            String[] array = CharacterCreation.presetCharacterData.get(preset);
            presetData = array[0];
            creationInfo = array[1];
            presetArray = new String[]{presetData, creationInfo};
            if (debugCharacterPreset) {
                System.out.println("existing #" + preset + " \"" + presetData + "\"");
            }
        } else {
            try {
                String currentLine;
                BufferedReader reader = new BufferedReader(new FileReader(userDir + FileWalker.getCharacterPresetPath(preset)));
                while ((currentLine = reader.readLine()) != null) {
                    if (!currentLine.startsWith("##")) {
                        presetData = currentLine;
                        continue;
                    }
                    if (!currentLine.contains("## Created on ")) continue;
                    creationInfo = currentLine;
                }
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            presetArray = new String[]{presetData, creationInfo};
            if (debugCharacterPreset) {
                System.out.println("get setting #" + preset + " \"" + presetData + "\"");
            }
            CharacterCreation.presetCharacterData.set(preset, presetArray);
        }
        return presetArray;
    }

    public static void loadCharacterPreset() {
        String presetData = FileWalker.getCharacterPreset(CharacterCreation.curPreset, false)[0];
        if (presetData != null) {
            CharacterUtils.setCharacterCreationData(true, presetData);
        }
    }

    static String getCharacterPresetPath(int preset) {
        int presetNum = preset;
        String fileName = "Character Preset " + (presetNum < 10 ? "0" : "") + presetNum + (presetNum == 0 ? " Auto Save" : "");
        return characterPresets + "/" + fileName + ".txt";
    }

    public static void setCharacterPreset(String userDir, boolean firstTime, int preset) {
        FileWalker.validateCharacterPresetArray();
        String textContents = "## Paste your Character Creation Data here to load it in the Character Creator";
        if (!firstTime) {
            textContents = FileWalker.presetHeader() + "\n" + CharacterUtils.getCharacterCreationData();
        }
        FileWalker.setCharacterPresetFile(userDir, preset, textContents);
    }

    public static void setCharacterPresetFile(String userDir, int preset, String presetData) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(userDir + FileWalker.getCharacterPresetPath(preset)));
            writer.write(presetData);
            if (presetData.contains("\n") && presetData.split("\n").length >= 2) {
                String[] presetArray = presetData.split("\n");
                String characterData = presetArray[1];
                String creationInfo = presetArray[0];
                CharacterCreation.presetCharacterData.set(preset, new String[]{characterData, creationInfo});
                if (debugCharacterPreset) {
                    System.out.println("set setting #" + preset + " \"" + characterData + "\"");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void validateCharacterPresetArray() {
        if (CharacterCreation.presetCharacterData.isEmpty()) {
            int preset;
            for (preset = 0; preset <= CharacterCreation.characterPresetCount; ++preset) {
                CharacterCreation.presetCharacterData.add(new String[]{null, null});
            }
            for (preset = 0; preset <= CharacterCreation.characterPresetCount; ++preset) {
                FileWalker.getCharacterPreset(preset, true);
            }
        }
    }

    static String presetHeader() {
        String dateFormatted = Methods.getDateFormatted();
        LocalDate currentDate = LocalDate.parse(dateFormatted, DateTimeFormatter.ofPattern("MM/dd/yyyy"));
        String playerName = Main.mc.field_71439_g != null ? Main.mc.field_71439_g.func_70005_c_() : "N/A";
        return "## Created on " + currentDate + " by " + playerName;
    }

    static void validateShaders(String userDir) {
        if (!LaunchInfo.hasOptifine) {
            return;
        }
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(userDir + "/optionsshaders.txt"));
            while ((currentLine = reader.readLine()) != null) {
                if (!currentLine.startsWith("shaderPack=")) continue;
                LaunchInfo.shaderPack = currentLine.split("shaderPack=")[1];
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setClipboardContents(String contents) {
        StringSelection stringSelection = new StringSelection(contents);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace(System.out);
            }
        }
        return result;
    }

    static void attemptMoveFile(String userDir, String newPath) {
        String oldPath = newPath.replace("/config/Apollo", "/config");
        File oldFile = new File(userDir + oldPath);
        if (oldFile.exists()) {
            System.out.println("attemptMoveFile: old: " + oldPath + " > " + newPath);
            FileWalker.moveFile(userDir, oldPath, newPath);
        }
    }

    static void moveFile(String userDir, String sourcePath, String targetPath) {
        File sourceFile = new File(userDir + sourcePath);
        File targetFile = new File(userDir + targetPath);
        FileWalker.makeDirectory(userDir + targetPath.substring(0, targetPath.lastIndexOf("/")));
        boolean status = sourceFile.renameTo(targetFile);
    }

    static void makeDirectory(String dirPath) {
        File directory = new File(dirPath);
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            System.out.println("Made Directory! \"" + directory + "\" | created: " + created);
        }
    }

    static void deleteFile(File file) {
        boolean removed = false;
        if (file.isDirectory()) {
            String[] entries;
            for (String s : entries = file.list()) {
                File subFile = new File(file.getPath(), s);
                removed = subFile.delete();
            }
            removed = file.delete();
        } else {
            removed = file.delete();
        }
        if (removed) {
            System.out.println("Removed old Config File \"" + file + "\"");
        }
    }
}

