/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonCommand;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.commands.AddonSubCommand;
import dev.jsinco.brewery.garden.commands.subcomands.GiveCommand;
import dev.jsinco.brewery.garden.commands.subcomands.GrowthStageCommand;
import dev.jsinco.brewery.garden.commands.subcomands.IsPlantCommand;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddonCommandManager
implements AddonCommand {
    private final BreweryGardenConfig config = (BreweryGardenConfig)BreweryGarden.getInstance().getAddonConfigManager().getConfig(BreweryGardenConfig.class);
    private final Map<String, AddonSubCommand> subCommands = new HashMap<String, AddonSubCommand>();

    public AddonCommandManager() {
        this.subCommands.put("give", new GiveCommand());
        this.subCommands.put("isplant", new IsPlantCommand());
        this.subCommands.put("growthstage", new GrowthStageCommand());
    }

    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        AddonSubCommand subCommand;
        if (args.length == 0) {
            Logging.msg((CommandSender)sender, (String)"Provide a subcommand.");
        }
        if ((subCommand = this.subCommands.get(args[1])) == null) {
            Logging.msg((CommandSender)sender, (String)"Unknown subcommand.");
            return;
        }
        if (subCommand.permission() != null && !sender.hasPermission(subCommand.permission())) {
            Logging.msg((CommandSender)sender, (String)"You do not have permission to execute this command.");
        } else if (subCommand.playerOnly() && !(sender instanceof Player)) {
            Logging.msg((CommandSender)sender, (String)"You must be a player to execute this command.");
        }
        String[] subArgs = new String[args.length - 2];
        System.arraycopy(args, 2, subArgs, 0, args.length - 2);
        if (!subCommand.execute(BreweryGarden.getInstance(), this.config, sender, label, subArgs)) {
            Logging.msg((CommandSender)sender, (String)subCommand.usage(label));
        }
    }

    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String s, String[] args) {
        if (args.length == 2) {
            return this.subCommands.entrySet().stream().filter(entry -> ((AddonSubCommand)entry.getValue()).permission() == null || sender.hasPermission(((AddonSubCommand)entry.getValue()).permission())).map(Map.Entry::getKey).toList();
        }
        AddonSubCommand subCommand = this.subCommands.get(args[1]);
        if (subCommand == null) {
            return null;
        }
        String[] subArgs = new String[args.length - 2];
        System.arraycopy(args, 2, subArgs, 0, args.length - 2);
        return subCommand.tabComplete(BreweryGarden.getInstance(), sender, s, subArgs);
    }

    public String permission() {
        return "brewery.cmd.garden";
    }

    public boolean playerOnly() {
        return false;
    }
}

