/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands.subcomands;

import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.commands.AddonSubCommand;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.constants.GenericPlantType;
import dev.jsinco.brewery.garden.constants.PlantType;
import dev.jsinco.brewery.garden.constants.PlantTypeSeeds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
implements AddonSubCommand {
    private final Map<String, GenericPlantType> items = new HashMap<String, GenericPlantType>();

    public GiveCommand() {
        for (PlantType plant : PlantType.values()) {
            this.items.put(plant.name().toLowerCase(), plant);
        }
        for (PlantTypeSeeds seed : PlantTypeSeeds.values()) {
            this.items.put(seed.name().toLowerCase(), seed);
        }
    }

    @Override
    public boolean execute(BreweryGarden addon, BreweryGardenConfig config, CommandSender sender, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        int amount = 1;
        if (args.length >= 2) {
            amount = BUtil.parseIntOrZero((String)args[1]);
        }
        Player player = null;
        if (args.length >= 3) {
            player = Bukkit.getPlayerExact((String)args[2]);
        } else if (sender instanceof Player) {
            Player p;
            player = p = (Player)sender;
        }
        if (player == null) {
            return false;
        }
        GenericPlantType plantType = this.items.get(args[0].toLowerCase());
        ItemStack item = plantType.getItemStack(amount);
        if (item != null) {
            player.getInventory().addItem(new ItemStack[]{item});
            Logging.msg((CommandSender)sender, (String)("Gave &6x" + amount + " " + plantType.name().toLowerCase() + " &rto " + player.getName()));
        } else {
            Logging.msg((CommandSender)sender, (String)"Unknown item.");
        }
        return true;
    }

    @Override
    public List<String> tabComplete(BreweryGarden addon, CommandSender sender, String label, String[] args) {
        if (args.length == 1) {
            return this.items.keySet().stream().toList();
        }
        if (args.length == 2) {
            return List.of("1", "16", "24", "32", "48", "64");
        }
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.garden.give";
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String usage(String label) {
        return "&e/" + label + "garden give <item!> <amount?> <player?>";
    }
}

