/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands.subcomands;

import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.GardenManager;
import dev.jsinco.brewery.garden.commands.AddonSubCommand;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.objects.GardenPlant;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IsPlantCommand
implements AddonSubCommand {
    @Override
    public boolean execute(BreweryGarden addon, BreweryGardenConfig config, CommandSender sender, String label, String[] args) {
        GardenPlant gardenPlant;
        Player player = (Player)sender;
        GardenManager gardenManager = BreweryGarden.getGardenManager();
        int maxDistance = 30;
        if (args.length > 0) {
            maxDistance = BUtil.parseIntOrZero((String)args[0]);
        }
        if ((gardenPlant = gardenManager.getByLocation(player.getTargetBlockExact(maxDistance))) != null) {
            Logging.msg((CommandSender)player, (String)("Found a GardenPlant: " + String.valueOf(gardenPlant)));
        } else {
            Logging.msg((CommandSender)player, (String)"No GardenPlant found.");
        }
        return true;
    }

    @Override
    public List<String> tabComplete(BreweryGarden addon, CommandSender sender, String label, String[] args) {
        return List.of("<distance>");
    }

    @Override
    public String permission() {
        return "brewery.cmd.garden.isplant";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String usage(String label) {
        return "/" + label + "garden isplant <distance?>";
    }
}

