/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.constants;

import com.dre.brewery.BreweryPlugin;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.constants.GenericPlantType;
import dev.jsinco.brewery.garden.constants.PlantType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class PlantTypeSeeds
extends GenericPlantType {
    public static final PlantTypeSeeds BERRY_SEEDS = new PlantTypeSeeds(PlantType.BERRY, Material.MELON_SEEDS);
    public static final PlantTypeSeeds STRAWBERRY_SEEDS = new PlantTypeSeeds(PlantType.STRAWBERRY, Material.WHEAT_SEEDS);
    public static final PlantTypeSeeds LEMON_SEEDS = new PlantTypeSeeds(PlantType.LEMON, Material.PUMPKIN_SEEDS);
    public static final PlantTypeSeeds LIME_SEEDS = new PlantTypeSeeds(PlantType.LIME, Material.BEETROOT_SEEDS);
    public static final PlantTypeSeeds ORANGE_SEEDS = new PlantTypeSeeds(PlantType.ORANGE, Material.NETHER_WART);
    public static final PlantTypeSeeds GRAPE_SEEDS = new PlantTypeSeeds(PlantType.GRAPE, Material.COCOA_BEANS);
    public static final PlantTypeSeeds APPLE_SEEDS = new PlantTypeSeeds(PlantType.APPLE, Material.SWEET_BERRIES);
    public static final PlantTypeSeeds PEACH_SEEDS = new PlantTypeSeeds(PlantType.PEACH, Material.PUMPKIN_SEEDS);
    public static final PlantTypeSeeds CRANBERRY_SEEDS = new PlantTypeSeeds(PlantType.CRANBERRY, Material.MELON_SEEDS);
    public static final PlantTypeSeeds BLUEBERRY_SEEDS = new PlantTypeSeeds(PlantType.BLUEBERRY, Material.MELON_SEEDS);
    public static final PlantTypeSeeds CHERRY_SEEDS = new PlantTypeSeeds(PlantType.CHERRY, Material.MELON_SEEDS);
    private static final NamespacedKey PERSISTENT_DATA_KEY = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "plant_seeds");
    private String FIELD_NAME;
    private final PlantType parent;
    private final Material seedMaterial;
    private static final Map<String, PlantTypeSeeds> VALUES = new HashMap<String, PlantTypeSeeds>();

    public PlantTypeSeeds(PlantType parent, String name, Material seedMaterial) {
        super(MiniMessage.miniMessage().deserialize((Object)name));
        this.parent = parent;
        this.seedMaterial = seedMaterial;
    }

    public PlantTypeSeeds(PlantType parent, Material seedMaterial) {
        super(parent.getName().append((Component)Component.text((String)" Seeds")));
        this.parent = parent;
        this.seedMaterial = seedMaterial;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        ItemStack item = new ItemStack(this.seedMaterial, amount);
        item.setData(DataComponentTypes.ITEM_NAME, (Object)this.name);
        ItemMeta meta = item.getItemMeta();
        meta.lore(List.of((TextComponent)Component.text((String)"Rough seeds").color((TextColor)NamedTextColor.DARK_GRAY)));
        meta.getPersistentDataContainer().set(PERSISTENT_DATA_KEY, PersistentDataType.STRING, (Object)this.FIELD_NAME);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isSeeds(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(PERSISTENT_DATA_KEY, PersistentDataType.STRING);
    }

    @Nullable
    public static PlantTypeSeeds getPlantSeedsType(ItemStack item) {
        if (!PlantTypeSeeds.isSeeds(item)) {
            return null;
        }
        String field_name = (String)item.getItemMeta().getPersistentDataContainer().get(PERSISTENT_DATA_KEY, PersistentDataType.STRING);
        if (field_name == null) {
            return null;
        }
        return PlantTypeSeeds.valueOf(field_name);
    }

    public static PlantTypeSeeds valueOf(String name) {
        return VALUES.get(name);
    }

    public static List<PlantTypeSeeds> values() {
        return VALUES.values().stream().toList();
    }

    @Override
    public String toString() {
        return this.FIELD_NAME;
    }

    @Override
    public String name() {
        return this.FIELD_NAME;
    }

    public String getFIELD_NAME() {
        return this.FIELD_NAME;
    }

    public PlantType getParent() {
        return this.parent;
    }

    public Material getSeedMaterial() {
        return this.seedMaterial;
    }

    static {
        for (Field field : PlantTypeSeeds.class.getDeclaredFields()) {
            if (field.getType() != PlantTypeSeeds.class) continue;
            try {
                PlantTypeSeeds plantType = (PlantTypeSeeds)field.get(null);
                plantType.FIELD_NAME = field.getName();
                VALUES.put(field.getName(), plantType);
            }
            catch (IllegalAccessException e) {
                BreweryGarden.getInstance().getAddonLogger().severe("Failed to get field reflectively.", (Throwable)e);
            }
        }
    }
}

