/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.events;

import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.GardenManager;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.constants.PlantPart;
import dev.jsinco.brewery.garden.constants.PlantType;
import dev.jsinco.brewery.garden.constants.PlantTypeSeeds;
import dev.jsinco.brewery.garden.objects.GardenPlant;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class EventListeners
implements Listener {
    private static final Random RANDOM = new Random();
    private final BreweryGardenConfig config = (BreweryGardenConfig)BreweryGarden.getInstance().getAddonConfigManager().getConfig(BreweryGardenConfig.class);
    private final GardenManager gardenManager;

    public EventListeners(GardenManager gardenManager) {
        this.gardenManager = gardenManager;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onLeafDecay(LeavesDecayEvent event) {
        if (this.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        GardenPlant gardenPlant = this.gardenManager.getByLocation(event.getBlock());
        if (gardenPlant != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        Block block = event.getBlock();
        if (this.config.getValidSeedDropBlocks().contains(block.getType()) && RANDOM.nextInt(100) <= this.config.getSeedSpawnChance()) {
            List<PlantTypeSeeds> seedsList = PlantTypeSeeds.values();
            block.getWorld().dropItemNaturally(block.getLocation(), seedsList.get(RANDOM.nextInt(seedsList.size())).getItemStack(1));
            return;
        }
        GardenPlant gardenPlant = this.gardenManager.getByLocation(block);
        if (gardenPlant == null) {
            return;
        }
        Logging.debugLog((String)("Found a GardenPlant at Location for BlockBreak: " + String.valueOf(block.getLocation())));
        Material itemMaterial = event.getPlayer().getInventory().getItemInMainHand().getType();
        if (block.getType() == Material.PLAYER_HEAD) {
            if (itemMaterial != Material.SHEARS) {
                Logging.msg((CommandSender)event.getPlayer(), (String)"&rThis plant needs to be interacted with &6shears &rto be obtained.");
                event.setCancelled(true);
            }
        } else {
            this.gardenManager.removePlant(gardenPlant);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null || this.isBlacklistedWorld(block.getLocation())) {
            return;
        }
        this.handlePlantShearing(event.getItem(), block);
        if (event.getBlockFace() == BlockFace.UP && event.getAction().isRightClick() && this.config.getPlantableBlocks().contains(block.getType())) {
            event.setCancelled(this.handleSeedPlacement(event.getItem(), block));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        if (PlantType.isPlant(event.getItemInHand())) {
            PlantType plantType = PlantType.getPlantType(event.getItemInHand());
            plantType.setDataOnPlayerSkullBlock(event.getBlock());
        }
    }

    private void handlePlantShearing(ItemStack itemInHand, Block clickedBlock) {
        if (itemInHand == null || itemInHand.getType() != Material.SHEARS) {
            return;
        }
        Location clickedLocation = clickedBlock.getLocation();
        GardenPlant gardenPlant = this.gardenManager.getByLocation(clickedBlock);
        if (gardenPlant == null || gardenPlant.getPlantPart(clickedLocation) != PlantPart.TOP || !gardenPlant.isValid()) {
            return;
        }
        gardenPlant.resetGrowthStage(true);
        clickedLocation.getWorld().playSound(clickedLocation, Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
    }

    private boolean handleSeedPlacement(ItemStack itemInHand, Block clickedBlock) {
        if (!PlantTypeSeeds.isSeeds(itemInHand)) {
            return false;
        }
        Location location = clickedBlock.getLocation().add(0.0, 1.0, 0.0);
        PlantTypeSeeds seeds = PlantTypeSeeds.getPlantSeedsType(itemInHand);
        if (seeds == null) {
            return false;
        }
        GardenPlant gardenPlant = new GardenPlant(seeds.getParent(), location);
        this.gardenManager.addPlant(gardenPlant);
        itemInHand.setAmount(itemInHand.getAmount() - 1);
        location.getWorld().playSound(location, Sound.BLOCK_GRASS_PLACE, 1.0f, 1.0f);
        return true;
    }

    private boolean isBlacklistedWorld(Location location) {
        return this.config.getBlacklistedWorlds().contains(location.getWorld().getName());
    }
}

