/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.objects;

import com.destroystokyo.paper.MaterialTags;
import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.constants.PlantPart;
import dev.jsinco.brewery.garden.constants.PlantType;
import dev.jsinco.brewery.garden.objects.WorldTiedBoundingBox;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.jetbrains.annotations.Nullable;

public class GardenPlant {
    private static final Random RANDOM = new Random();
    private static final BreweryGardenConfig config = (BreweryGardenConfig)BreweryGarden.getInstance().getAddonConfigManager().getConfig(BreweryGardenConfig.class);
    private final UUID id;
    private final PlantType type;
    private final WorldTiedBoundingBox region;
    private int age;

    public GardenPlant(PlantType type, Location bottomLocation) {
        this(type, WorldTiedBoundingBox.of(bottomLocation, bottomLocation.clone().add(0.0, 2.0, 0.0)));
    }

    public GardenPlant(PlantType type, WorldTiedBoundingBox region) {
        this.id = UUID.randomUUID();
        this.type = type;
        this.region = region;
        this.age = 0;
    }

    public boolean place() {
        for (PlantPart plantPart : PlantPart.values()) {
            Location location;
            Block block;
            if (plantPart == PlantPart.TOP) {
                if (!this.isFullyGrown()) {
                    ++this.age;
                    continue;
                }
                this.age = 0;
            }
            if ((block = (location = plantPart.locationFromCenter(this.region.getCenter(), this.region.getWorld())).getBlock()).getType() != Material.AIR) continue;
            block.setType(plantPart.getAssigneeMaterial());
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Leaves) {
                Leaves leaves = (Leaves)blockData;
                leaves.setPersistent(true);
                block.setBlockData((BlockData)leaves);
            }
            if (plantPart.getAssigneeMaterial() != Material.PLAYER_HEAD) continue;
            this.type.setSkullTexture(block);
            block.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, block.getLocation().toCenterLocation(), 5, 0.1, 0.1, 0.1);
        }
        return true;
    }

    @Nullable
    public PlantPart getPlantPart(Location location) {
        for (PlantPart part : PlantPart.values()) {
            Location locationFromCenter = part.locationFromCenter(this.region.getCenter(), this.region.getWorld());
            Logging.debugLog((String)("Checking if " + String.valueOf(locationFromCenter) + " is equal to " + String.valueOf(location)));
            if (!locationFromCenter.equals((Object)location)) continue;
            return part;
        }
        return null;
    }

    public boolean unPlace() {
        for (Block block : this.region.getBlocks()) {
            if (block.getType() == Material.AIR) continue;
            if (block.getType() == Material.PLAYER_HEAD) {
                block.getWorld().dropItemNaturally(block.getLocation(), this.type.getItemStack(1));
            }
            if (!MaterialTags.WOODEN_FENCES.isTagged(block) && !Tag.LEAVES.isTagged((Keyed)block.getType())) continue;
            block.setType(Material.AIR);
        }
        return true;
    }

    public boolean isValid() {
        for (PlantPart part : PlantPart.values()) {
            Location location;
            Block block;
            if (part == PlantPart.TOP || (block = (location = part.locationFromCenter(this.region.getCenter(), this.region.getWorld())).getBlock()).getType() == part.getAssigneeMaterial()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyGrown() {
        return this.age >= config.getFullyGrown();
    }

    public void incrementGrowthStage(int amount) {
        this.age += amount;
    }

    public void resetGrowthStage(boolean dropPlantItem) {
        this.age = 0;
        Location location = PlantPart.TOP.locationFromCenter(this.region.getCenter(), this.region.getWorld());
        location.getBlock().setType(Material.AIR);
        if (dropPlantItem) {
            location.getWorld().dropItemNaturally(location, this.type.getItemStack(1));
        }
    }

    public static GardenPlantBuilder builder() {
        return new GardenPlantBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public PlantType getType() {
        return this.type;
    }

    public WorldTiedBoundingBox getRegion() {
        return this.region;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String toString() {
        return "GardenPlant(id=" + String.valueOf(this.getId()) + ", type=" + String.valueOf(this.getType()) + ", region=" + String.valueOf((Object)this.getRegion()) + ", age=" + this.getAge() + ")";
    }

    public GardenPlant(UUID id, PlantType type, WorldTiedBoundingBox region, int age) {
        this.id = id;
        this.type = type;
        this.region = region;
        this.age = age;
    }

    public static class GardenPlantBuilder {
        private UUID id;
        private PlantType type;
        private WorldTiedBoundingBox region;
        private int age;

        GardenPlantBuilder() {
        }

        public GardenPlantBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public GardenPlantBuilder type(PlantType type) {
            this.type = type;
            return this;
        }

        public GardenPlantBuilder region(WorldTiedBoundingBox region) {
            this.region = region;
            return this;
        }

        public GardenPlantBuilder age(int age) {
            this.age = age;
            return this;
        }

        public GardenPlant build() {
            return new GardenPlant(this.id, this.type, this.region, this.age);
        }

        public String toString() {
            return "GardenPlant.GardenPlantBuilder(id=" + String.valueOf(this.id) + ", type=" + String.valueOf(this.type) + ", region=" + String.valueOf((Object)this.region) + ", age=" + this.age + ")";
        }
    }
}

