/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.objects;

import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;

public class WorldTiedBoundingBox
extends BoundingBox {
    private World world;

    public WorldTiedBoundingBox(World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.world = world;
    }

    public List<Block> getBlocks() {
        LinkedList<Block> bL = new LinkedList<Block>();
        for (int x = (int)this.getMinX(); x <= (int)this.getMaxX(); ++x) {
            for (int y = (int)this.getMinY(); y <= (int)this.getMaxY(); ++y) {
                for (int z = (int)this.getMinZ(); z <= (int)this.getMaxZ(); ++z) {
                    bL.add(this.world.getBlockAt(x, y, z));
                }
            }
        }
        return bL;
    }

    public String toString() {
        return String.join((CharSequence)",", this.getWorld().getName(), String.valueOf(this.getMinX()), String.valueOf(this.getMinY()), String.valueOf(this.getMinZ()), String.valueOf(this.getMaxX()), String.valueOf(this.getMaxY()), String.valueOf(this.getMaxZ()));
    }

    public static WorldTiedBoundingBox of(Location location, Location location2) {
        return new WorldTiedBoundingBox(location.getWorld(), location.getX(), location.getY(), location.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static WorldTiedBoundingBox fromString(String data) {
        String[] split = data.split(",");
        World world = Bukkit.getWorld((String)split[0]);
        double x1 = Double.parseDouble(split[1]);
        double y1 = Double.parseDouble(split[2]);
        double z1 = Double.parseDouble(split[3]);
        double x2 = Double.parseDouble(split[4]);
        double y2 = Double.parseDouble(split[5]);
        double z2 = Double.parseDouble(split[6]);
        return new WorldTiedBoundingBox(world, x1, y1, z1, x2, y2, z2);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }
}

