/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.hardcoremode.events;

import com.rumaruka.hardcoremode.init.HMSounds;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class HardCoreEvents {
    private static boolean isFullHP;

    @SubscribeEvent
    public static void onServerLevelTick(ServerTickEvent.Post event) {
        event.getServer().getAllLevels().forEach(serverLevel -> serverLevel.getServer().setDifficulty(Difficulty.HARD, true));
        event.getServer().getAllLevels().forEach(serverLevel -> serverLevel.getServer().setDifficultyLocked(true));
        event.getServer().getAllLevels().forEach(serverLevel -> serverLevel.getServer().setDefaultGameType(GameType.SURVIVAL));
    }

    @SubscribeEvent
    public static void onLivingHurt(EntityInvulnerabilityCheckEvent event) {
        Entity e = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (e instanceof LivingEntity) {
            Set holders;
            ItemEnchantments tagEnchantments;
            ItemStack mainHandItem;
            Player player;
            LivingEntity living = (LivingEntity)e;
            if (living instanceof Zombie || living instanceof AbstractSkeleton || living instanceof Phantom) {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    mainHandItem = player.getMainHandItem();
                    if (!mainHandItem.isEmpty() && mainHandItem.getItem().components().has(DataComponents.WEAPON)) {
                        tagEnchantments = mainHandItem.getTagEnchantments();
                        holders = tagEnchantments.keySet();
                        if (!holders.isEmpty()) {
                            for (Holder holder : holders) {
                                if (!holder.is(Enchantments.SMITE)) continue;
                                event.setInvulnerable(false);
                            }
                        } else {
                            event.setInvulnerable(true);
                        }
                    } else {
                        event.setInvulnerable(true);
                    }
                } else {
                    event.setInvulnerable(false);
                }
            }
            if (living instanceof Silverfish || living instanceof Spider || living instanceof Endermite) {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    mainHandItem = player.getMainHandItem();
                    if (!mainHandItem.isEmpty() && mainHandItem.getItem().components().has(DataComponents.WEAPON)) {
                        tagEnchantments = mainHandItem.getTagEnchantments();
                        holders = tagEnchantments.keySet();
                        if (!holders.isEmpty()) {
                            for (Holder holder : holders) {
                                if (!holder.is(Enchantments.BANE_OF_ARTHROPODS)) continue;
                                event.setInvulnerable(false);
                            }
                        } else {
                            event.setInvulnerable(true);
                        }
                    } else {
                        event.setInvulnerable(true);
                    }
                } else {
                    event.setInvulnerable(false);
                }
            }
            if (living instanceof Blaze && !(event.getSource().getDirectEntity() instanceof Snowball)) {
                event.setInvulnerable(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().getHealth() > 4.0f) {
            isFullHP = true;
        }
        if (event.getEntity().level().getGameTime() % 100L == 0L && isFullHP) {
            Level level;
            if (!event.getEntity().getAbilities().instabuild && (level = event.getEntity().level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                event.getEntity().hurtServer(level2, event.getEntity().level().damageSources().generic(), 1.0f);
                event.getEntity().level().playSound(null, event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (SoundEvent)HMSounds.TAKE_HEALTH.get(), SoundSource.MASTER, 2.0f, 1.0f);
            }
            if (event.getEntity().getHealth() <= 4.0f) {
                isFullHP = false;
            }
        }
    }
}

