/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.truststore;

import com.juanmuscaria.truststore.TrustManagerMerger;
import com.juanmuscaria.truststore.launch.Platform;
import com.juanmuscaria.truststore.logger.LoggerAdapter;
import java.security.KeyStore;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;

public class TrustStorePatchMod {
    public static final String LOGGER_NAME = "TrustStorePatch";

    public static void patch(Platform platform) {
        KeyStore keystore;
        LoggerAdapter logger = platform.logger();
        logger.info("Trust Store Patch loaded from " + platform.getClass().getSimpleName(), new Object[0]);
        try {
            keystore = TrustManagerMerger.loadKeystoreFromResources(TrustManagerMerger.class, "/jdk-25+36-jre/cacerts", "jks");
        }
        catch (Throwable e) {
            logger.warn("Unable to load embedded keystore! No changes will be made.", e);
            return;
        }
        AtomicReference<Throwable> exception = new AtomicReference<Throwable>();
        if (!TrustManagerMerger.mergeTrustManagers(keystore, exception)) {
            logger.warn("Trust store merge failed! No changes where made.", exception.get());
        } else {
            ForkJoinPool.commonPool().submit(() -> {
                if (TrustManagerMerger.checkUrl("https://google.com", exception)) {
                    logger.warn("URL test failed", exception.get());
                }
                if (TrustManagerMerger.checkUrl("https://helloworld.letsencrypt.org", exception)) {
                    logger.warn("URL test failed", exception.get());
                }
                if (TrustManagerMerger.checkUrl("https://sessionserver.mojang.com", exception)) {
                    logger.warn("URL test failed", exception.get());
                }
                if (exception.get() != null) {
                    logger.error("One or more URL tests failed, perhaps the patch failed.", new Object[0]);
                } else {
                    logger.info("All URL tests passed!", new Object[0]);
                }
            });
        }
    }
}

