/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.truststore.logger;

import com.juanmuscaria.truststore.logger.LoggerAdapter;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Log4jLogger
implements LoggerAdapter {
    private final Logger logger;

    public Log4jLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void log(java.util.logging.Level level, String message, Object ... format) {
        Level log4jLevel = this.translate(level);
        if (this.logger.isEnabled(log4jLevel)) {
            Throwable throwable = null;
            if (format.length > 0 && format[format.length - 1] instanceof Throwable) {
                throwable = (Throwable)format[format.length - 1];
                format = Arrays.copyOf(format, format.length - 1);
            }
            this.logger.log(log4jLevel, this.javaLoggingFormat(message, format));
            if (throwable != null) {
                this.logger.log(log4jLevel, "Exception: ", throwable);
            }
        }
    }

    private Level translate(java.util.logging.Level level) {
        if (level.intValue() >= java.util.logging.Level.OFF.intValue()) {
            return Level.OFF;
        }
        if (level.intValue() >= java.util.logging.Level.SEVERE.intValue()) {
            return Level.ERROR;
        }
        if (level.intValue() >= java.util.logging.Level.WARNING.intValue()) {
            return Level.WARN;
        }
        if (level.intValue() >= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (level.intValue() >= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG;
        }
        if (level.intValue() >= java.util.logging.Level.FINEST.intValue()) {
            return Level.TRACE;
        }
        if (level.intValue() >= java.util.logging.Level.ALL.intValue()) {
            return Level.ALL;
        }
        return Level.INFO;
    }
}

