/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.truststore.logger;

import com.juanmuscaria.truststore.logger.JavaLogger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface LoggerAdapter {
    public static final AtomicReference<LoggerProvider> PROVIDER = new AtomicReference<LoggerProvider>(name -> new JavaLogger(Logger.getLogger(name)));

    public static LoggerAdapter getLogger(String name) {
        return PROVIDER.get().getLogger(name);
    }

    public void log(Level var1, String var2, Object ... var3);

    default public void error(String message, Object ... format) {
        this.log(Level.SEVERE, message, format);
    }

    default public void warn(String message, Object ... format) {
        this.log(Level.WARNING, message, format);
    }

    default public void info(String message, Object ... format) {
        this.log(Level.INFO, message, format);
    }

    default public void debug(String message, Object ... format) {
        this.log(Level.FINE, message, format);
    }

    default public String javaLoggingFormat(String message, Object ... format) {
        if (format == null || format.length == 0) {
            return message;
        }
        try {
            return MessageFormat.format(message, format);
        }
        catch (Exception ex) {
            return message;
        }
    }

    public static interface LoggerProvider {
        public LoggerAdapter getLogger(String var1);
    }
}

