/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit;

import com.restoreit.command.RestoreItCommand;
import com.restoreit.config.ConfigManager;
import com.restoreit.core.ArenaManager;
import com.restoreit.core.RestoreManager;
import com.restoreit.core.SnapshotManager;
import com.restoreit.integration.WorldEditIntegration;
import com.restoreit.util.DependencyContainer;
import com.restoreit.util.MessageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class RestoreItPlugin
extends JavaPlugin {
    private DependencyContainer container;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private WorldEditIntegration worldEditIntegration;
    private ArenaManager arenaManager;
    private SnapshotManager snapshotManager;
    private RestoreManager restoreManager;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        try {
            this.container = new DependencyContainer(this);
            this.initializeCore();
            this.initializeConfiguration();
            this.initializeWorldEdit();
            this.initializeCommands();
            this.setupLogging();
            long enableTime = System.currentTimeMillis() - startTime;
            Component enableMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"RestoreIt ").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)("v" + this.getPluginMeta().getVersion())))).append((Component)Component.text((String)" enabled successfully in "))).append((Component)Component.text((String)(enableTime + "ms"), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"!"));
            this.getServer().getConsoleSender().sendMessage(enableMessage);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to enable RestoreIt: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            if (this.restoreManager != null) {
                this.restoreManager.shutdown();
            }
            if (this.configManager != null) {
                this.configManager.saveConfig();
            }
            if (this.container != null) {
                this.container.cleanup();
            }
            Component disableMessage = Component.text((String)"RestoreIt disabled successfully!").color((TextColor)NamedTextColor.YELLOW);
            this.getServer().getConsoleSender().sendMessage(disableMessage);
        }
        catch (Exception e) {
            this.getLogger().severe("Error during plugin disable: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initializeCore() {
        this.getLogger().info("Initializing core framework...");
        this.container.register(RestoreItPlugin.class, this);
        this.container.register(JavaPlugin.class, this);
        this.getLogger().info("Core framework initialized");
    }

    private void initializeConfiguration() {
        this.getLogger().info("Initializing configuration system...");
        this.configManager = new ConfigManager(this);
        this.container.register(ConfigManager.class, this.configManager);
        this.configManager.loadConfig();
        this.messageManager = new MessageManager(this, this.configManager);
        this.container.register(MessageManager.class, this.messageManager);
        this.getLogger().info("Configuration system initialized");
    }

    private void initializeWorldEdit() {
        this.getLogger().info("Initializing WorldEdit integration...");
        this.worldEditIntegration = new WorldEditIntegration(this);
        this.container.register(WorldEditIntegration.class, this.worldEditIntegration);
        if (!this.worldEditIntegration.isAvailable()) {
            throw new RuntimeException("WorldEdit is required but not available!");
        }
        this.arenaManager = new ArenaManager(this, this.worldEditIntegration, this.configManager);
        this.snapshotManager = new SnapshotManager(this, this.worldEditIntegration, this.configManager);
        this.restoreManager = new RestoreManager(this, this.worldEditIntegration, this.configManager, this.messageManager, this.snapshotManager.getSnapshotStorage());
        this.container.register(ArenaManager.class, this.arenaManager);
        this.container.register(SnapshotManager.class, this.snapshotManager);
        this.container.register(RestoreManager.class, this.restoreManager);
        this.getLogger().info("WorldEdit integration initialized");
    }

    private void initializeCommands() {
        this.getLogger().info("Initializing command system...");
        RestoreItCommand mainCommand = new RestoreItCommand(this, this.arenaManager, this.snapshotManager, this.restoreManager, this.messageManager);
        this.getCommand("restoreit").setExecutor((CommandExecutor)mainCommand);
        this.getCommand("restoreit").setTabCompleter((TabCompleter)mainCommand);
        this.container.register(RestoreItCommand.class, mainCommand);
        this.getLogger().info("Command system initialized with unified /restoreit command");
    }

    private void setupLogging() {
        this.getLogger().info("Setting up logging infrastructure...");
        if (this.configManager.isDebugMode()) {
            this.getLogger().info("Debug mode enabled - verbose logging active");
        }
        this.getLogger().info("Logging infrastructure ready");
    }

    @NotNull
    public DependencyContainer getContainer() {
        return this.container;
    }

    @NotNull
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    @NotNull
    public WorldEditIntegration getWorldEditIntegration() {
        return this.worldEditIntegration;
    }

    @NotNull
    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    @NotNull
    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    @NotNull
    public RestoreManager getRestoreManager() {
        return this.restoreManager;
    }
}

