/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.command;

import com.restoreit.core.ArenaManager;
import com.restoreit.model.Arena;
import com.restoreit.util.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArenaCommand
implements CommandExecutor,
TabCompleter {
    private final ArenaManager arenaManager;
    private final MessageManager messageManager;

    public ArenaCommand(@NotNull JavaPlugin plugin, @NotNull ArenaManager arenaManager, @NotNull MessageManager messageManager) {
        this.arenaManager = arenaManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.arena.use")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.showArenaHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.showArenaHelp(sender);
                return true;
            }
            case "create": {
                return this.handleCreate(sender, args);
            }
            case "delete": 
            case "remove": {
                return this.handleDelete(sender, args);
            }
            case "list": {
                return this.handleList(sender, args);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "validate": {
                return this.handleValidate(sender, args);
            }
            case "near": {
                return this.handleNear(sender, args);
            }
            case "stats": {
                return this.handleStats(sender, args);
            }
        }
        this.messageManager.sendError(sender, "Unknown arena subcommand: " + subCommand);
        this.showArenaHelp(sender);
        return true;
    }

    private void showArenaHelp(@NotNull CommandSender sender) {
        TextComponent header = Component.text((String)"Arena Commands", (TextColor)NamedTextColor.GOLD);
        sender.sendMessage(this.messageManager.getPrefixedComponent().append((Component)header));
        if (sender.hasPermission("restoreit.arena.create")) {
            sender.sendMessage(Component.text((String)"  /arena create <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Create arena from WorldEdit selection", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.delete")) {
            sender.sendMessage(Component.text((String)"  /arena delete <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Delete an arena", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.list")) {
            sender.sendMessage(Component.text((String)"  /arena list [pattern]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List all arenas", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.info")) {
            sender.sendMessage(Component.text((String)"  /arena info <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show arena information", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.create")) {
            sender.sendMessage(Component.text((String)"  /arena validate <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Validate arena creation", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.list")) {
            sender.sendMessage(Component.text((String)"  /arena near [radius]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Find nearby arenas", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /arena stats", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show arena statistics", (TextColor)NamedTextColor.GRAY)));
        }
    }

    private boolean handleCreate(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.create")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /arena create <name>");
            return true;
        }
        String arenaName = args[1];
        if (arenaName.trim().isEmpty()) {
            this.messageManager.sendError(sender, "Arena name cannot be empty!");
            return true;
        }
        if (this.arenaManager.arenaExists(arenaName)) {
            this.messageManager.sendMessage(sender, "arena.already-exists", arenaName);
            return true;
        }
        Arena arena = this.arenaManager.createArena(arenaName, player);
        if (arena != null) {
            String message = this.messageManager.getRawMessage("arena.created", arenaName);
            this.messageManager.sendSuccess(sender, message);
        } else {
            this.messageManager.sendError(sender, "Failed to create arena. Check your WorldEdit selection!");
        }
        return true;
    }

    private boolean handleDelete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.delete")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /arena delete <name>");
            return true;
        }
        String arenaName = args[1];
        if (!this.arenaManager.arenaExists(arenaName)) {
            this.messageManager.sendMessage(sender, "arena.not-found", arenaName);
            return true;
        }
        boolean deleted = this.arenaManager.deleteArena(arenaName);
        if (deleted) {
            this.messageManager.sendMessage(sender, "arena.deleted", arenaName);
        } else {
            this.messageManager.sendError(sender, "Failed to delete arena '" + arenaName + "'");
        }
        return true;
    }

    private boolean handleList(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        Collection<Arena> arenas = this.arenaManager.getAllArenas();
        if (arenas.isEmpty()) {
            this.messageManager.sendInfo(sender, "No arenas found. Create one with /arena create <name>");
            return true;
        }
        String pattern = args.length > 1 ? args[1] : null;
        List<String> arenaNames = this.arenaManager.getArenaNames(pattern);
        if (arenaNames.isEmpty()) {
            this.messageManager.sendError(sender, "No arenas match pattern: " + pattern);
            return true;
        }
        this.messageManager.sendMessage(sender, "arena.list-header", arenaNames.size());
        for (String arenaName : arenaNames) {
            Arena arena = this.arenaManager.getArena(arenaName);
            if (arena == null) continue;
            Component arenaInfo = this.messageManager.createClickableComponent(arena.getName(), "/arena info " + arena.getName(), "Click to view arena info");
            Component entry = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append(arenaInfo)).append((Component)Component.text((String)" (", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)(arena.getBlockCount() + " blocks"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)(arena.getSnapshotCount() + " snapshots"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY));
            sender.sendMessage(entry);
        }
        return true;
    }

    private boolean handleInfo(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.info")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /arena info <name>");
            return true;
        }
        String arenaName = args[1];
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            this.messageManager.sendMessage(sender, "arena.not-found", arenaName);
            return true;
        }
        Component header = Component.text((String)"Arena Information: ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)arena.getName(), (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
        sender.sendMessage(Component.text((String)"  World: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)arena.getWorldName(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  Size: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)arena.getRegion().getSizeString(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" (", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)(arena.getBlockCount() + " blocks"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"  Center: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)arena.getRegion().getCenterString(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"  Created: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.messageManager.formatTimestamp(arena.getCreatedAt()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)arena.getCreatedBy(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  Snapshots: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("" + arena.getSnapshotCount()), (TextColor)NamedTextColor.WHITE)));
        return true;
    }

    private boolean handleValidate(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.create")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /arena validate <name>");
            return true;
        }
        this.messageManager.sendInfo(sender, "Arena validation feature coming soon!");
        this.messageManager.sendInfo(sender, "Use /arena create <name> to create an arena with built-in validation.");
        return true;
    }

    private boolean handleNear(@NotNull CommandSender sender, @NotNull String[] args) {
        List<Arena> nearbyArenas;
        if (!sender.hasPermission("restoreit.arena.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        int radius = 100;
        if (args.length > 1) {
            try {
                radius = Integer.parseInt(args[1]);
                if (radius < 1 || radius > 1000) {
                    this.messageManager.sendError(sender, "Radius must be between 1 and 1000 blocks");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                this.messageManager.sendError(sender, "Invalid radius: " + args[1]);
                return true;
            }
        }
        if ((nearbyArenas = this.arenaManager.getArenasNear(player.getWorld().getName(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ(), radius)).isEmpty()) {
            this.messageManager.sendInfo(sender, "No arenas found within " + radius + " blocks");
            return true;
        }
        Component header = Component.text((String)"Nearby Arenas ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)("(within " + radius + " blocks)"), (TextColor)NamedTextColor.GRAY));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
        for (Arena arena : nearbyArenas) {
            double distance = arena.getRegion().getDistanceFrom(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ());
            Component arenaInfo = this.messageManager.createClickableComponent(arena.getName(), "/arena info " + arena.getName(), "Click to view arena info");
            Component entry = ((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append(arenaInfo)).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)String.format("%.1f blocks away", distance), (TextColor)NamedTextColor.WHITE));
            sender.sendMessage(entry);
        }
        return true;
    }

    private boolean handleStats(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.arena.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        ArenaManager.ArenaStatistics stats = this.arenaManager.getStatistics();
        TextComponent header = Component.text((String)"Arena Statistics", (TextColor)NamedTextColor.GOLD);
        sender.sendMessage(this.messageManager.getPrefixedComponent().append((Component)header));
        sender.sendMessage(Component.text((String)"  Total Arenas: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("" + stats.getTotalArenas()), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  Total Blocks: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)String.format("%,d", stats.getTotalBlocks()), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  Total Snapshots: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("" + stats.getTotalSnapshots()), (TextColor)NamedTextColor.WHITE)));
        if (!stats.getArenasByWorld().isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"  Arenas by World:", (TextColor)NamedTextColor.GRAY));
            for (Map.Entry<String, Integer> entry : stats.getArenasByWorld().entrySet()) {
                sender.sendMessage(Component.text((String)("    " + entry.getKey() + ": "), (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)(String.valueOf(entry.getValue()) + " arenas"), (TextColor)NamedTextColor.WHITE)));
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.arena.use")) {
            return List.of();
        }
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("help", "list", "info", "validate", "near", "stats");
            if (sender.hasPermission("restoreit.arena.create")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("create");
            }
            if (sender.hasPermission("restoreit.arena.delete")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("delete");
            }
            String input = args[0].toLowerCase();
            return subCommands.stream().filter(sub -> sub.startsWith(input)).sorted().toList();
        }
        if (args.length == 2 && ("delete".equals(subCommand = args[0].toLowerCase()) || "info".equals(subCommand)) && (sender.hasPermission("restoreit.arena.delete") || sender.hasPermission("restoreit.arena.info"))) {
            String input = args[1].toLowerCase();
            return this.arenaManager.getArenaNames(null).stream().filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
        }
        return List.of();
    }
}

