/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.command;

import com.restoreit.command.ArenaCommand;
import com.restoreit.command.SnapshotCommand;
import com.restoreit.core.ArenaManager;
import com.restoreit.core.RestoreManager;
import com.restoreit.core.SnapshotManager;
import com.restoreit.model.Arena;
import com.restoreit.model.Snapshot;
import com.restoreit.util.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestoreItCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final ArenaManager arenaManager;
    private final SnapshotManager snapshotManager;
    private final RestoreManager restoreManager;
    private final MessageManager messageManager;
    private final Logger logger;
    private final ArenaCommand arenaCommand;
    private final SnapshotCommand snapshotCommand;

    public RestoreItCommand(@NotNull JavaPlugin plugin, @NotNull ArenaManager arenaManager, @NotNull SnapshotManager snapshotManager, @NotNull RestoreManager restoreManager, @NotNull MessageManager messageManager) {
        this.plugin = plugin;
        this.arenaManager = arenaManager;
        this.snapshotManager = snapshotManager;
        this.restoreManager = restoreManager;
        this.messageManager = messageManager;
        this.logger = plugin.getLogger();
        this.arenaCommand = new ArenaCommand(plugin, arenaManager, messageManager);
        this.snapshotCommand = new SnapshotCommand(plugin, snapshotManager, arenaManager, messageManager);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.use")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.showHelp(sender);
                return true;
            }
            case "version": 
            case "ver": {
                this.showVersion(sender);
                return true;
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "debug": {
                return this.handleDebug(sender);
            }
            case "arena": {
                return this.delegateToArenaCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
            }
            case "snapshot": {
                return this.handleSnapshotCreate(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "restore": {
                return this.handleSnapshotRestore(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "list": {
                return this.handleSnapshotList(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "info": {
                return this.handleSnapshotInfo(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "status": {
                return this.handleSnapshotStatus(sender);
            }
            case "delete": 
            case "remove": {
                return this.handleSnapshotDelete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        this.messageManager.sendError(sender, "Unknown subcommand: " + subCommand);
        this.showHelp(sender);
        return true;
    }

    private void showHelp(@NotNull CommandSender sender) {
        Component header = Component.text((String)"RestoreIt Commands", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" - Arena Snapshot & Restoration", (TextColor)NamedTextColor.GRAY));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
        if (sender.hasPermission("restoreit.admin")) {
            sender.sendMessage(Component.text((String)"  /restoreit help", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show this help message", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit version", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show plugin version", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit reload", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Reload plugin configuration", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.arena.use")) {
            sender.sendMessage((Component)Component.text((String)"Arena Management:", (TextColor)NamedTextColor.AQUA));
            sender.sendMessage(Component.text((String)"  /restoreit arena create <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Create new arena", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit arena delete <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Delete arena", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit arena list", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List all arenas", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.snapshot.use")) {
            sender.sendMessage((Component)Component.text((String)"Snapshot Management:", (TextColor)NamedTextColor.AQUA));
            sender.sendMessage(Component.text((String)"  /restoreit snapshot <arena> <name> [description]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Create snapshot", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit list [arena]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List snapshots", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit info <arena> <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show snapshot info", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit delete <arena> <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Delete snapshot", (TextColor)NamedTextColor.GRAY)));
            sender.sendMessage(Component.text((String)"  /restoreit status", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show active operations", (TextColor)NamedTextColor.GRAY)));
        }
        sender.sendMessage(Component.text((String)"  /restoreit restore <arena> <name>", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)" - Restore snapshot", (TextColor)NamedTextColor.GREEN)));
    }

    private boolean delegateToArenaCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.arenaCommand.onCommand(sender, command, label, args);
    }

    private boolean handleSnapshotCreate(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.create")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /restoreit snapshot <arena> <name> [description]");
            return true;
        }
        String arenaName = args[0];
        String snapshotName = args[1];
        String description = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : null;
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            this.messageManager.sendMessage(sender, "arena.not-found", arenaName);
            return true;
        }
        if (snapshotName.trim().isEmpty()) {
            this.messageManager.sendError(sender, "Snapshot name cannot be empty!");
            return true;
        }
        if (this.snapshotManager.hasSnapshot(arenaName, snapshotName)) {
            this.messageManager.sendError(sender, "Snapshot '" + snapshotName + "' already exists in arena '" + arenaName + "'");
            return true;
        }
        this.messageManager.sendInfo(sender, "Creating snapshot '" + snapshotName + "' for arena '" + arenaName + "'...");
        CompletableFuture<Snapshot> future = this.snapshotManager.createSnapshot(arena, snapshotName, player, description);
        future.whenComplete((snapshot, throwable) -> {
            if (throwable != null) {
                this.messageManager.sendError(sender, "Failed to create snapshot: " + throwable.getMessage());
                this.logger.warning("Snapshot creation failed for " + player.getName() + ": " + throwable.getMessage());
            } else {
                this.messageManager.sendSuccess(sender, "Snapshot '" + snapshotName + "' created successfully!");
                this.messageManager.sendInfo(sender, "Size: " + snapshot.getFormattedFileSize() + " (" + snapshot.getFormattedBlockCount() + " blocks)");
            }
        });
        return true;
    }

    private boolean handleSnapshotRestore(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.restore")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        if (args.length < 2) {
            this.messageManager.sendError(sender, "Usage: /restoreit restore <arena> <snapshot>");
            return true;
        }
        String arenaName = args[0];
        String snapshotName = args[1];
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            this.messageManager.sendMessage(sender, "arena.not-found", arenaName);
            return true;
        }
        Snapshot snapshot = this.snapshotManager.getSnapshot(arenaName, snapshotName);
        if (snapshot == null) {
            this.messageManager.sendError(sender, "Snapshot '" + snapshotName + "' not found in arena '" + arenaName + "'");
            return true;
        }
        if (this.restoreManager.isArenaBeingRestored(arena)) {
            this.messageManager.sendError(sender, "Arena '" + arenaName + "' is already being restored!");
            return true;
        }
        this.messageManager.sendInfo(sender, "\u00a76Starting restoration of arena '\u00a7e" + arenaName + "\u00a76' to snapshot '\u00a7e" + snapshotName + "\u00a76'...");
        this.restoreManager.restoreArena(arena, snapshot, sender).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.messageManager.sendError(sender, "Failed to restore arena: " + throwable.getMessage());
                this.logger.warning("Restoration failed for arena '" + arenaName + "': " + throwable.getMessage());
            }
        });
        return true;
    }

    private boolean handleSnapshotList(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        String[] snapshotArgs = new String[args.length + 1];
        snapshotArgs[0] = "list";
        System.arraycopy(args, 0, snapshotArgs, 1, args.length);
        return this.snapshotCommand.onCommand(sender, null, "snapshot", snapshotArgs);
    }

    private boolean handleSnapshotInfo(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.info")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        String[] snapshotArgs = new String[args.length + 1];
        snapshotArgs[0] = "info";
        System.arraycopy(args, 0, snapshotArgs, 1, args.length);
        return this.snapshotCommand.onCommand(sender, null, "snapshot", snapshotArgs);
    }

    private boolean handleSnapshotStatus(@NotNull CommandSender sender) {
        if (!sender.hasPermission("restoreit.snapshot.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        return this.snapshotCommand.onCommand(sender, null, "snapshot", new String[]{"status"});
    }

    private boolean handleSnapshotDelete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.delete")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        String[] snapshotArgs = new String[args.length + 1];
        snapshotArgs[0] = "delete";
        System.arraycopy(args, 0, snapshotArgs, 1, args.length);
        return this.snapshotCommand.onCommand(sender, null, "snapshot", snapshotArgs);
    }

    private void showVersion(@NotNull CommandSender sender) {
        String version = this.plugin.getPluginMeta().getVersion();
        Component versionMessage = ((TextComponent)((TextComponent)Component.text((String)"RestoreIt ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)("v" + version), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"RestoreIt Team", (TextColor)NamedTextColor.AQUA));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(versionMessage));
        TextComponent description = Component.text((String)"Efficient arena snapshot and restoration plugin", (TextColor)NamedTextColor.GRAY);
        sender.sendMessage(this.messageManager.getPrefixedComponent().append((Component)description));
    }

    private boolean handleReload(@NotNull CommandSender sender) {
        if (!sender.hasPermission("restoreit.reload")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        try {
            this.messageManager.sendInfo(sender, "Reloading RestoreIt configuration...");
            this.plugin.reloadConfig();
            this.messageManager.reload();
            this.messageManager.sendSuccess(sender, "RestoreIt reloaded successfully!");
        }
        catch (Exception e) {
            this.messageManager.sendError(sender, "Failed to reload: " + e.getMessage());
            this.logger.severe("Failed to reload configuration: " + e.getMessage());
        }
        return true;
    }

    private boolean handleDebug(@NotNull CommandSender sender) {
        if (!sender.hasPermission("restoreit.debug")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        sender.sendMessage((Component)Component.text((String)"=== RestoreIt Debug Information ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"Plugin Version: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.plugin.getPluginMeta().getVersion(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"Server Version: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.plugin.getServer().getVersion(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"Plugin Status: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)(this.plugin.isEnabled() ? "ENABLED" : "DISABLED"), (TextColor)(this.plugin.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.use")) {
            return List.of();
        }
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("help", "version", "list", "info", "status"));
            if (sender.hasPermission("restoreit.admin")) {
                subCommands.add("reload");
                subCommands.add("debug");
            }
            if (sender.hasPermission("restoreit.arena.use")) {
                subCommands.add("arena");
            }
            if (sender.hasPermission("restoreit.snapshot.create")) {
                subCommands.add("snapshot");
            }
            if (sender.hasPermission("restoreit.snapshot.delete")) {
                subCommands.add("delete");
                subCommands.add("remove");
            }
            subCommands.add("restore");
            String input = args[0].toLowerCase();
            return subCommands.stream().filter(sub -> sub.startsWith(input)).sorted().toList();
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "arena": {
                if (!sender.hasPermission("restoreit.arena.use")) break;
                return this.arenaCommand.onTabComplete(sender, command, alias, Arrays.copyOfRange(args, 1, args.length));
            }
            case "snapshot": 
            case "delete": 
            case "remove": 
            case "info": {
                if (args.length == 2) {
                    String input = args[1].toLowerCase();
                    return this.arenaManager.getArenaNames(null).stream().filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
                }
                if (args.length != 3 || !"delete".equals(subCommand) && !"remove".equals(subCommand) && !"info".equals(subCommand)) break;
                String arenaName = args[1];
                String input = args[2].toLowerCase();
                return this.snapshotManager.getSnapshots(arenaName).stream().map(Snapshot::getName).filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
            }
            case "list": {
                if (args.length != 2) break;
                String input = args[1].toLowerCase();
                return this.arenaManager.getArenaNames(null).stream().filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
            }
            case "restore": {
                if (args.length == 2) {
                    String input = args[1].toLowerCase();
                    return this.arenaManager.getArenaNames(null).stream().filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
                }
                if (args.length != 3) break;
                String arenaName = args[1];
                String input = args[2].toLowerCase();
                return this.snapshotManager.getSnapshots(arenaName).stream().map(Snapshot::getName).filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
            }
        }
        return List.of();
    }
}

