/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.command;

import com.restoreit.core.ArenaManager;
import com.restoreit.core.SnapshotManager;
import com.restoreit.model.Arena;
import com.restoreit.model.Snapshot;
import com.restoreit.util.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SnapshotCommand
implements CommandExecutor,
TabCompleter {
    private final SnapshotManager snapshotManager;
    private final ArenaManager arenaManager;
    private final MessageManager messageManager;
    private final Logger logger;

    public SnapshotCommand(@NotNull JavaPlugin plugin, @NotNull SnapshotManager snapshotManager, @NotNull ArenaManager arenaManager, @NotNull MessageManager messageManager) {
        this.snapshotManager = snapshotManager;
        this.arenaManager = arenaManager;
        this.messageManager = messageManager;
        this.logger = plugin.getLogger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.snapshot.use")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.showSnapshotHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.showSnapshotHelp(sender);
                return true;
            }
            case "create": 
            case "take": {
                return this.handleCreate(sender, args);
            }
            case "delete": 
            case "remove": {
                return this.handleDelete(sender, args);
            }
            case "list": {
                return this.handleList(sender, args);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "status": {
                return this.handleStatus(sender, args);
            }
            case "restore": {
                this.messageManager.sendInfo(sender, "Snapshot restoration will be implemented in Phase 4");
                return true;
            }
        }
        this.messageManager.sendError(sender, "Unknown snapshot subcommand: " + subCommand);
        this.showSnapshotHelp(sender);
        return true;
    }

    private void showSnapshotHelp(@NotNull CommandSender sender) {
        TextComponent header = Component.text((String)"Snapshot Commands", (TextColor)NamedTextColor.GOLD);
        sender.sendMessage(this.messageManager.getPrefixedComponent().append((Component)header));
        if (sender.hasPermission("restoreit.snapshot.create")) {
            sender.sendMessage(Component.text((String)"  /snapshot create <arena> <name> [description]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Create arena snapshot", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.snapshot.delete")) {
            sender.sendMessage(Component.text((String)"  /snapshot delete <arena> <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Delete a snapshot", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.snapshot.list")) {
            sender.sendMessage(Component.text((String)"  /snapshot list [arena]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List snapshots", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.snapshot.info")) {
            sender.sendMessage(Component.text((String)"  /snapshot info <arena> <name>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show snapshot information", (TextColor)NamedTextColor.GRAY)));
        }
        if (sender.hasPermission("restoreit.snapshot.list")) {
            sender.sendMessage(Component.text((String)"  /snapshot status", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show active operations", (TextColor)NamedTextColor.GRAY)));
        }
        sender.sendMessage(Component.text((String)"  /snapshot restore <arena> <name>", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)" - Restore snapshot (Phase 4)", (TextColor)NamedTextColor.GRAY)));
    }

    private boolean handleCreate(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.create")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.messageManager.sendMessage(sender, "player-only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 3) {
            this.messageManager.sendError(sender, "Usage: /snapshot create <arena> <name> [description]");
            return true;
        }
        String arenaName = args[1];
        String snapshotName = args[2];
        String description = args.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : null;
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            this.messageManager.sendMessage(sender, "arena.not-found", arenaName);
            return true;
        }
        if (snapshotName.trim().isEmpty()) {
            this.messageManager.sendError(sender, "Snapshot name cannot be empty!");
            return true;
        }
        if (this.snapshotManager.hasSnapshot(arenaName, snapshotName)) {
            this.messageManager.sendError(sender, "Snapshot '" + snapshotName + "' already exists in arena '" + arenaName + "'");
            return true;
        }
        this.messageManager.sendInfo(sender, "Creating snapshot '" + snapshotName + "' for arena '" + arenaName + "'...");
        CompletableFuture<Snapshot> future = this.snapshotManager.createSnapshot(arena, snapshotName, player, description);
        future.whenComplete((snapshot, throwable) -> {
            if (throwable != null) {
                this.messageManager.sendError(sender, "Failed to create snapshot: " + throwable.getMessage());
                this.logger.warning("Snapshot creation failed for " + player.getName() + ": " + throwable.getMessage());
            } else {
                this.messageManager.sendSuccess(sender, "Snapshot '" + snapshotName + "' created successfully!");
                this.messageManager.sendInfo(sender, "Size: " + snapshot.getFormattedFileSize() + " (" + snapshot.getFormattedBlockCount() + " blocks)");
            }
        });
        return true;
    }

    private boolean handleDelete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.delete")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length < 3) {
            this.messageManager.sendError(sender, "Usage: /snapshot delete <arena> <name>");
            return true;
        }
        String arenaName = args[1];
        String snapshotName = args[2];
        if (!this.snapshotManager.hasSnapshot(arenaName, snapshotName)) {
            this.messageManager.sendError(sender, "Snapshot '" + snapshotName + "' not found in arena '" + arenaName + "'");
            return true;
        }
        boolean deleted = this.snapshotManager.deleteSnapshot(arenaName, snapshotName);
        if (deleted) {
            this.messageManager.sendSuccess(sender, "Snapshot '" + snapshotName + "' deleted successfully!");
        } else {
            this.messageManager.sendError(sender, "Failed to delete snapshot '" + snapshotName + "'");
        }
        return true;
    }

    private boolean handleList(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length > 1) {
            String arenaName2 = args[1];
            if (!this.arenaManager.arenaExists(arenaName2)) {
                this.messageManager.sendMessage(sender, "arena.not-found", arenaName2);
                return true;
            }
            Collection<Snapshot> snapshots2 = this.snapshotManager.getSnapshots(arenaName2);
            if (snapshots2.isEmpty()) {
                this.messageManager.sendInfo(sender, "No snapshots found for arena '" + arenaName2 + "'");
                return true;
            }
            Component header = ((TextComponent)Component.text((String)"Snapshots for arena ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)arenaName2, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(" (" + snapshots2.size() + " total)"), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
            for (Snapshot snapshot : snapshots2) {
                this.showSnapshotListEntry(sender, snapshot);
            }
        } else {
            Collection<Snapshot> allSnapshots = this.snapshotManager.getAllSnapshots();
            if (allSnapshots.isEmpty()) {
                this.messageManager.sendInfo(sender, "No snapshots found. Create one with /snapshot create <arena> <name>");
                return true;
            }
            Component header = Component.text((String)"All Snapshots ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)("(" + allSnapshots.size() + " total)"), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
            allSnapshots.stream().collect(Collectors.groupingBy(Snapshot::getArenaName)).forEach((arenaName, snapshots) -> {
                sender.sendMessage(Component.text((String)"  Arena: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)arenaName, (TextColor)NamedTextColor.WHITE)));
                snapshots.forEach(snapshot -> this.showSnapshotListEntry(sender, (Snapshot)snapshot));
            });
        }
        return true;
    }

    private void showSnapshotListEntry(@NotNull CommandSender sender, @NotNull Snapshot snapshot) {
        Component snapshotInfo = this.messageManager.createClickableComponent(snapshot.getName(), "/snapshot info " + snapshot.getArenaName() + " " + snapshot.getName(), "Click to view snapshot info");
        TextComponent statusColor = switch (snapshot.getStatus()) {
            case Snapshot.SnapshotStatus.READY -> Component.text((String)"\u25cf", (TextColor)NamedTextColor.GREEN);
            case Snapshot.SnapshotStatus.CREATING -> Component.text((String)"\u25cf", (TextColor)NamedTextColor.YELLOW);
            case Snapshot.SnapshotStatus.ERROR, Snapshot.SnapshotStatus.CORRUPTED -> Component.text((String)"\u25cf", (TextColor)NamedTextColor.RED);
            default -> Component.text((String)"\u25cf", (TextColor)NamedTextColor.GRAY);
        };
        Component entry = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"    \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)statusColor)).append((Component)Component.text((String)" ", (TextColor)NamedTextColor.WHITE))).append(snapshotInfo)).append((Component)Component.text((String)" (", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)snapshot.getFormattedFileSize(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)(snapshot.getFormattedBlockCount() + " blocks"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY));
        sender.sendMessage(entry);
    }

    private boolean handleInfo(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.info")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        if (args.length < 3) {
            this.messageManager.sendError(sender, "Usage: /snapshot info <arena> <name>");
            return true;
        }
        String arenaName = args[1];
        String snapshotName = args[2];
        Snapshot snapshot = this.snapshotManager.getSnapshot(arenaName, snapshotName);
        if (snapshot == null) {
            this.messageManager.sendError(sender, "Snapshot '" + snapshotName + "' not found in arena '" + arenaName + "'");
            return true;
        }
        Component header = Component.text((String)"Snapshot Information: ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)snapshot.getFullName(), (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
        sender.sendMessage(Component.text((String)"  Arena: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getArenaName(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  World: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getWorldName(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getStatus().getDisplayName(), (TextColor)this.getStatusColor(snapshot.getStatus()))));
        sender.sendMessage(Component.text((String)"  Blocks: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getFormattedBlockCount(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"  File Size: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getFormattedFileSize(), (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"  Created: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.messageManager.formatTimestamp(snapshot.getCreatedAt()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)snapshot.getCreatedBy(), (TextColor)NamedTextColor.WHITE)));
        if (snapshot.getDescription() != null) {
            sender.sendMessage(Component.text((String)"  Description: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)snapshot.getDescription(), (TextColor)NamedTextColor.WHITE)));
        }
        return true;
    }

    private boolean handleStatus(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission("restoreit.snapshot.list")) {
            this.messageManager.sendMessage(sender, "no-permission", new Object[0]);
            return true;
        }
        Map<String, Snapshot> activeOperations = this.snapshotManager.getActiveOperations();
        if (activeOperations.isEmpty()) {
            this.messageManager.sendInfo(sender, "No active snapshot operations");
            return true;
        }
        Component header = Component.text((String)"Active Snapshot Operations ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)("(" + activeOperations.size() + " total)"), (TextColor)NamedTextColor.GRAY));
        sender.sendMessage(this.messageManager.getPrefixedComponent().append(header));
        for (Map.Entry<String, Snapshot> entry : activeOperations.entrySet()) {
            Snapshot snapshot = entry.getValue();
            Component operation = ((TextComponent)((TextComponent)Component.text((String)"  \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)snapshot.getFullName(), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)snapshot.getStatus().getDisplayName(), (TextColor)this.getStatusColor(snapshot.getStatus())));
            sender.sendMessage(operation);
        }
        return true;
    }

    private NamedTextColor getStatusColor(Snapshot.SnapshotStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case Snapshot.SnapshotStatus.READY -> NamedTextColor.GREEN;
            case Snapshot.SnapshotStatus.CREATING, Snapshot.SnapshotStatus.RESTORING -> NamedTextColor.YELLOW;
            case Snapshot.SnapshotStatus.ERROR, Snapshot.SnapshotStatus.CORRUPTED -> NamedTextColor.RED;
        };
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("restoreit.snapshot.use")) {
            return List.of();
        }
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("help", "list", "info", "status", "restore");
            if (sender.hasPermission("restoreit.snapshot.create")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("create");
            }
            if (sender.hasPermission("restoreit.snapshot.delete")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("delete");
            }
            String input = args[0].toLowerCase();
            return subCommands.stream().filter(sub -> sub.startsWith(input)).sorted().toList();
        }
        if (args.length == 2 && ("create".equals(subCommand = args[0].toLowerCase()) || "delete".equals(subCommand) || "info".equals(subCommand) || "list".equals(subCommand)) && (sender.hasPermission("restoreit.snapshot.create") || sender.hasPermission("restoreit.snapshot.delete") || sender.hasPermission("restoreit.snapshot.info") || sender.hasPermission("restoreit.snapshot.list"))) {
            String input = args[1].toLowerCase();
            return this.arenaManager.getArenaNames(null).stream().filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
        }
        if (args.length == 3) {
            subCommand = args[0].toLowerCase();
            String arenaName = args[1];
            if (("delete".equals(subCommand) || "info".equals(subCommand)) && (sender.hasPermission("restoreit.snapshot.delete") || sender.hasPermission("restoreit.snapshot.info"))) {
                String input = args[2].toLowerCase();
                return this.snapshotManager.getSnapshots(arenaName).stream().map(Snapshot::getName).filter(name -> name.toLowerCase().startsWith(input)).sorted().toList();
            }
        }
        return List.of();
    }
}

