/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.integration;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldEditIntegration {
    private final JavaPlugin plugin;
    private final Logger logger;
    private WorldEditPlugin worldEditPlugin;
    private boolean isAvailable;

    public WorldEditIntegration(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.isAvailable = false;
        this.initialize();
    }

    private void initialize() {
        try {
            Plugin worldEditBukkit = this.plugin.getServer().getPluginManager().getPlugin("WorldEdit");
            if (worldEditBukkit == null) {
                this.logger.severe("WorldEdit plugin not found! RestoreIt requires WorldEdit to function.");
                return;
            }
            if (!worldEditBukkit.isEnabled()) {
                this.logger.severe("WorldEdit plugin is not enabled! RestoreIt requires WorldEdit to function.");
                return;
            }
            if (worldEditBukkit instanceof WorldEditPlugin) {
                this.worldEditPlugin = (WorldEditPlugin)worldEditBukkit;
                this.isAvailable = true;
                this.logger.info("WorldEdit integration initialized successfully (Version: " + this.worldEditPlugin.getPluginMeta().getVersion() + ")");
            } else {
                this.logger.severe("Invalid WorldEdit plugin instance!");
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to initialize WorldEdit integration: " + e.getMessage());
            e.printStackTrace();
            this.isAvailable = false;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable && this.worldEditPlugin != null && this.worldEditPlugin.isEnabled();
    }

    @Nullable
    public Region getPlayerSelection(@NotNull Player player) {
        if (!this.isAvailable()) {
            this.logger.warning("WorldEdit not available when getting player selection");
            return null;
        }
        try {
            SessionManager sessionManager = WorldEdit.getInstance().getSessionManager();
            LocalSession session = sessionManager.get((SessionOwner)BukkitAdapter.adapt((Player)player));
            World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
            Region selection = session.getSelection(world);
            if (selection == null) {
                return null;
            }
            this.logger.fine("Retrieved WorldEdit selection for player " + player.getName() + " (size: " + selection.getVolume() + " blocks)");
            return selection;
        }
        catch (Exception e) {
            this.logger.warning("Failed to get WorldEdit selection for player " + player.getName() + ": " + e.getMessage());
            return null;
        }
    }

    public boolean hasValidSelection(@NotNull Player player) {
        Region selection = this.getPlayerSelection(player);
        return selection != null && selection.getVolume() > 0L;
    }

    public long getRegionVolume(@NotNull Region region) {
        try {
            return region.getVolume();
        }
        catch (Exception e) {
            this.logger.warning("Failed to calculate region volume: " + e.getMessage());
            return 0L;
        }
    }

    public boolean isValidArenaRegion(@NotNull Region region, long maxSize) {
        try {
            long volume = region.getVolume();
            if (volume < 1L) {
                return false;
            }
            return volume <= maxSize;
        }
        catch (Exception e) {
            this.logger.warning("Failed to validate arena region: " + e.getMessage());
            return false;
        }
    }

    @Nullable
    public WorldEditPlugin getWorldEditPlugin() {
        return this.isAvailable() ? this.worldEditPlugin : null;
    }

    @NotNull
    public String getVersion() {
        if (!this.isAvailable()) {
            return "Unknown";
        }
        return this.worldEditPlugin.getPluginMeta().getVersion();
    }

    public boolean supportsAsyncOperations() {
        if (!this.isAvailable()) {
            return false;
        }
        String version = this.getVersion();
        try {
            return !version.startsWith("6.") && !version.equals("Unknown");
        }
        catch (Exception e) {
            this.logger.warning("Failed to check WorldEdit async support: " + e.getMessage());
            return false;
        }
    }

    @NotNull
    public String getDebugInfo() {
        if (!this.isAvailable()) {
            return "WorldEdit: NOT AVAILABLE";
        }
        StringBuilder info = new StringBuilder();
        info.append("WorldEdit Integration:\n");
        info.append("  Version: ").append(this.getVersion()).append("\n");
        info.append("  Plugin Enabled: ").append(this.worldEditPlugin.isEnabled()).append("\n");
        info.append("  Async Support: ").append(this.supportsAsyncOperations()).append("\n");
        return info.toString();
    }
}

